/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.factory;

import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.aggregation.impl.AvgAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.CountAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.FirstValueAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.FirstValueDescAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.LastValueAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.LastValueDescAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MaxTimeAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MaxTimeDescAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MaxValueAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MinTimeAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MinTimeDescAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.MinValueAggrResult;
import org.apache.iotdb.db.query.aggregation.impl.SumAggrResult;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class AggregateResultFactory {
    private AggregateResultFactory() {
    }

    public static AggregateResult getAggrResultByName(String aggrFuncName, TSDataType dataType, boolean ascending) {
        if (aggrFuncName == null) {
            throw new IllegalArgumentException("AggregateFunction Name must not be null");
        }
        switch (aggrFuncName.toLowerCase()) {
            case "min_time": {
                return !ascending ? new MinTimeDescAggrResult() : new MinTimeAggrResult();
            }
            case "max_time": {
                return !ascending ? new MaxTimeDescAggrResult() : new MaxTimeAggrResult();
            }
            case "min_value": {
                return new MinValueAggrResult(dataType);
            }
            case "max_value": {
                return new MaxValueAggrResult(dataType);
            }
            case "count": {
                return new CountAggrResult();
            }
            case "avg": {
                return new AvgAggrResult(dataType);
            }
            case "first_value": {
                return !ascending ? new FirstValueDescAggrResult(dataType) : new FirstValueAggrResult(dataType);
            }
            case "sum": {
                return new SumAggrResult(dataType);
            }
            case "last_value": {
                return !ascending ? new LastValueDescAggrResult(dataType) : new LastValueAggrResult(dataType);
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggrFuncName);
    }

    public static AggregateResult getAggrResultByName(String aggrFuncName, TSDataType dataType) {
        if (aggrFuncName == null) {
            throw new IllegalArgumentException("AggregateFunction Name must not be null");
        }
        switch (aggrFuncName.toLowerCase()) {
            case "min_time": {
                return new MinTimeAggrResult();
            }
            case "max_time": {
                return new MaxTimeDescAggrResult();
            }
            case "min_value": {
                return new MinValueAggrResult(dataType);
            }
            case "max_value": {
                return new MaxValueAggrResult(dataType);
            }
            case "count": {
                return new CountAggrResult();
            }
            case "avg": {
                return new AvgAggrResult(dataType);
            }
            case "first_value": {
                return new FirstValueAggrResult(dataType);
            }
            case "sum": {
                return new SumAggrResult(dataType);
            }
            case "last_value": {
                return new LastValueDescAggrResult(dataType);
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggrFuncName);
    }

    public static AggregateResult getAggrResultByType(AggregationType aggregationType, TSDataType dataType, boolean ascending) {
        switch (aggregationType) {
            case AVG: {
                return new AvgAggrResult(dataType);
            }
            case COUNT: {
                return new CountAggrResult();
            }
            case SUM: {
                return new SumAggrResult(dataType);
            }
            case FIRST_VALUE: {
                return !ascending ? new FirstValueDescAggrResult(dataType) : new FirstValueAggrResult(dataType);
            }
            case LAST_VALUE: {
                return !ascending ? new LastValueDescAggrResult(dataType) : new LastValueAggrResult(dataType);
            }
            case MAX_TIME: {
                return !ascending ? new MaxTimeDescAggrResult() : new MaxTimeAggrResult();
            }
            case MIN_TIME: {
                return !ascending ? new MinTimeDescAggrResult() : new MinTimeAggrResult();
            }
            case MAX_VALUE: {
                return new MaxValueAggrResult(dataType);
            }
            case MIN_VALUE: {
                return new MinValueAggrResult(dataType);
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation Type: " + aggregationType.name());
    }
}

