/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.cost.statistic.Measurement;
import org.apache.iotdb.db.cost.statistic.Operation;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.ChunkMetadataCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.exception.BatchInsertionException;
import org.apache.iotdb.db.exception.QueryInBatchStatementException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metrics.server.SqlArgument;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.control.TracingManager;
import org.apache.iotdb.db.query.dataset.AlignByDeviceDataSet;
import org.apache.iotdb.db.query.dataset.NonAlignEngineDataSet;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithoutValueFilter;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.StaticResps;
import org.apache.iotdb.db.tools.watermark.GroupedLSBWatermarkEncoder;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSQueryNonAlignDataSet;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.apache.thrift.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSServiceImpl
implements TSIService.Iface,
ServerContext {
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"IoTDB_AUDIT_LOGGER");
    private static final Logger logger = LoggerFactory.getLogger(TSServiceImpl.class);
    private static final Logger SLOW_SQL_LOGGER = LoggerFactory.getLogger((String)"SLOW_SQL");
    private static final Logger QUERY_FREQUENCY_LOGGER = LoggerFactory.getLogger((String)"QUERY_FREQUENCY");
    private static final String INFO_NOT_LOGIN = "{}: Not login.";
    private static final int MAX_SIZE = IoTDBDescriptor.getInstance().getConfig().getQueryCacheSizeInMetric();
    private static final int DELETE_SIZE = 20;
    private static final int DEFAULT_FETCH_SIZE = 10000;
    private static final String ERROR_PARSING_SQL = "meet error while parsing SQL to physical plan: {}";
    private static final String SERVER_INTERNAL_ERROR = "{}: server Internal Error: ";
    private static final String CHECK_METADATA_ERROR = "check metadata error: ";
    private static final List<SqlArgument> sqlArgumentList = new ArrayList<SqlArgument>(MAX_SIZE);
    protected Planner processor;
    protected IPlanExecutor executor;
    private boolean enableMetric = IoTDBDescriptor.getInstance().getConfig().isEnableMetricService();
    private Map<Long, String> sessionIdUsernameMap = new ConcurrentHashMap<Long, String>();
    private Map<Long, ZoneId> sessionIdZoneIdMap = new ConcurrentHashMap<Long, ZoneId>();
    private AtomicLong sessionIdGenerator = new AtomicLong();
    private AtomicLong statementIdGenerator = new AtomicLong();
    private Map<Long, Set<Long>> sessionId2StatementId = new ConcurrentHashMap<Long, Set<Long>>();
    private Map<Long, Set<Long>> statementId2QueryId = new ConcurrentHashMap<Long, Set<Long>>();
    private Map<Long, QueryDataSet> queryId2DataSet = new ConcurrentHashMap<Long, QueryDataSet>();
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private ThreadLocal<Long> currSessionId = new ThreadLocal();
    public static final TSProtocolVersion CURRENT_RPC_VERSION = TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V3;
    private static final AtomicInteger queryCount = new AtomicInteger(0);

    public TSServiceImpl() throws QueryProcessException {
        this.processor = new Planner();
        this.executor = new PlanExecutor();
        ScheduledExecutorService timedQuerySqlCountThread = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "timedQuerySqlCountThread"));
        timedQuerySqlCountThread.scheduleAtFixedRate(() -> {
            if (queryCount.get() != 0) {
                QUERY_FREQUENCY_LOGGER.info("Query count in current 1 minute: " + queryCount.getAndSet(0));
            }
        }, this.config.getFrequencyIntervalInMinute(), this.config.getFrequencyIntervalInMinute(), TimeUnit.MINUTES);
    }

    public static List<SqlArgument> getSqlArgumentList() {
        return sqlArgumentList;
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        TSStatus tsStatus;
        boolean status;
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        String loginMessage = null;
        try {
            status = authorizer.login(req.getUsername(), req.getPassword());
        }
        catch (AuthException e) {
            logger.info("meet error while logging in.", (Throwable)e);
            status = false;
            loginMessage = e.getMessage();
        }
        long sessionId = -1L;
        if (status) {
            boolean compatible = this.checkCompatibility(req.getClient_protocol());
            if (!compatible) {
                TSStatus tsStatus2 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INCOMPATIBLE_VERSION, (String)("The version is incompatible, please upgrade to " + IoTDBConstant.VERSION));
                TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus2, CURRENT_RPC_VERSION);
                resp.setSessionId(sessionId);
                return resp;
            }
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Login successfully");
            sessionId = this.sessionIdGenerator.incrementAndGet();
            this.sessionIdUsernameMap.put(sessionId, req.getUsername());
            this.sessionIdZoneIdMap.put(sessionId, ZoneId.of(req.getZoneId()));
            this.currSessionId.set(sessionId);
            auditLogger.info("User {} opens Session-{}", (Object)req.getUsername(), (Object)sessionId);
            logger.info("{}: Login status: {}. User : {}", new Object[]{"IoTDB", tsStatus.message, req.getUsername()});
        } else {
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR, (String)(loginMessage != null ? loginMessage : "Authentication failed."));
            auditLogger.info("User {} opens Session failed with an incorrect password", (Object)req.getUsername());
        }
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, CURRENT_RPC_VERSION);
        resp.setSessionId(sessionId);
        return resp;
    }

    private boolean checkCompatibility(TSProtocolVersion version) {
        return version.equals((Object)CURRENT_RPC_VERSION);
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        long sessionId = req.getSessionId();
        auditLogger.info("Session-{} is closing", (Object)sessionId);
        this.currSessionId.remove();
        TSStatus tsStatus = this.sessionIdUsernameMap.remove(sessionId) == null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        this.sessionIdZoneIdMap.remove(sessionId);
        ArrayList<StorageEngineException> exceptions = new ArrayList<StorageEngineException>();
        Set statementIds = this.sessionId2StatementId.getOrDefault(sessionId, Collections.emptySet());
        Iterator iterator = statementIds.iterator();
        while (iterator.hasNext()) {
            long statementId = (Long)iterator.next();
            Set queryIds = this.statementId2QueryId.getOrDefault(statementId, Collections.emptySet());
            Iterator iterator2 = queryIds.iterator();
            while (iterator2.hasNext()) {
                long queryId = (Long)iterator2.next();
                try {
                    this.releaseQueryResource(queryId);
                }
                catch (StorageEngineException e) {
                    exceptions.add(e);
                    logger.error("Error in closeSession : ", (Throwable)e);
                }
            }
        }
        if (!exceptions.isEmpty()) {
            return new TSStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.CLOSE_OPERATION_ERROR, (String)String.format("%d errors in closeOperation, see server logs for detail", exceptions.size())));
        }
        return new TSStatus(tsStatus);
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)"Cancellation is not implemented");
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        if (auditLogger.isDebugEnabled()) {
            auditLogger.debug("{}: receive close operation from Session {}", (Object)"IoTDB", (Object)this.currSessionId.get());
        }
        if (!this.checkLogin(req.getSessionId())) {
            auditLogger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        try {
            if (req.isSetStatementId() && req.isSetQueryId()) {
                this.releaseQueryResource(req.queryId);
                if (this.statementId2QueryId.containsKey(req.getStatementId())) {
                    this.statementId2QueryId.get(req.getStatementId()).remove(req.getQueryId());
                }
            } else {
                long stmtId = req.getStatementId();
                Set<Long> queryIdSet = this.statementId2QueryId.remove(stmtId);
                if (queryIdSet != null) {
                    for (long queryId : queryIdSet) {
                        this.releaseQueryResource(queryId);
                    }
                }
                if (this.sessionId2StatementId.containsKey(req.getSessionId())) {
                    this.sessionId2StatementId.get(req.getSessionId()).remove(req.getStatementId());
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in closeOperation : ", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.CLOSE_OPERATION_ERROR, (String)"Error in closeOperation");
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    protected void releaseQueryResource(long queryId) throws StorageEngineException {
        this.queryId2DataSet.remove(queryId);
        QueryResourceManager.getInstance().endQuery(queryId);
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        TSStatus status;
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            TSStatus status2 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            return new TSFetchMetadataResp(status2);
        }
        TSFetchMetadataResp resp = new TSFetchMetadataResp();
        try {
            switch (req.getType()) {
                case "METADATA_IN_JSON": {
                    String metadataInJson = this.getMetadataInString();
                    resp.setMetadataInJson(metadataInJson);
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "COLUMN": {
                    resp.setDataType(this.getSeriesTypeByPath(new PartialPath(req.getColumnPath())).toString());
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                case "ALL_COLUMNS": {
                    resp.setColumnsList(this.getPaths(new PartialPath(req.getColumnPath())).stream().map(PartialPath::getFullPath).collect(Collectors.toList()));
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                    break;
                }
                default: {
                    status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)req.getType());
                    break;
                }
            }
        }
        catch (OutOfMemoryError | MetadataException e) {
            logger.error(String.format("Failed to fetch timeseries %s's metadata", req.getColumnPath()), e);
            TSStatus status3 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)e.getMessage());
            resp.setStatus(status3);
            return resp;
        }
        catch (Exception e) {
            logger.error("Error in fetchMetadata : ", (Throwable)e);
            TSStatus status4 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            resp.setStatus(status4);
            return resp;
        }
        resp.setStatus(status);
        return resp;
    }

    private String getMetadataInString() {
        return IoTDB.metaManager.getMetadataInString();
    }

    protected List<PartialPath> getPaths(PartialPath path) throws MetadataException {
        return IoTDB.metaManager.getAllTimeseriesPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<TSStatus> result = new ArrayList<TSStatus>();
        try {
            TSStatus tSStatus;
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSStatus tSStatus2 = RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSStatus2;
            }
            List statements = req.getStatements();
            boolean isAllSuccessful = true;
            for (String statement : statements) {
                long t2 = System.currentTimeMillis();
                isAllSuccessful = this.executeStatementInBatch(statement, result, req.getSessionId()) && isAllSuccessful;
                Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
            }
            if (isAllSuccessful) {
                tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute batch statements successfully");
                return tSStatus;
            }
            tSStatus = RpcUtils.getStatus(result);
            return tSStatus;
        }
        catch (Exception e) {
            logger.error(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            return tSStatus;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_JDBC_BATCH, t1);
        }
    }

    private boolean executeStatementInBatch(String statement, List<TSStatus> result, long sessionId) {
        try {
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(sessionId), 10000);
            if (physicalPlan.isQuery()) {
                throw new QueryInBatchStatementException(statement);
            }
            TSExecuteStatementResp resp = this.executeUpdateStatement(physicalPlan, sessionId);
            if (resp.getStatus().code != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                result.add(resp.status);
                return false;
            }
            result.add(resp.status);
        }
        catch (ParseCancellationException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)(statement + " " + e.getMessage()));
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)("meet error while parsing SQL to physical plan: {} " + statement + " " + e.getMessage())));
            return false;
        }
        catch (SQLParserException e) {
            logger.error("Error occurred when executing {}, check metadata error: ", (Object)statement, (Object)e);
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)("meet error while parsing SQL to physical plan: {} " + statement + " " + e.getMessage())));
            return false;
        }
        catch (QueryProcessException e) {
            logger.info("Error occurred when executing {}, meet error while parsing SQL to physical plan: {}", (Object)statement, (Object)e.getMessage());
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)("Meet error in query process: " + e.getMessage())));
            return false;
        }
        catch (QueryInBatchStatementException e) {
            logger.info("Error occurred when executing {}, query statement not allowed: ", (Object)statement, (Object)e);
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_NOT_ALLOWED, (String)("query statement not allowed: " + statement)));
            return false;
        }
        catch (Exception e) {
            logger.error(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            result.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)("server Internal Error: " + e.getMessage())));
        }
        return true;
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            String statement = req.getStatement();
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(req.getSessionId()), req.fetchSize);
            if (physicalPlan.isQuery()) {
                return this.internalExecuteQueryStatement(statement, req.statementId, physicalPlan, req.fetchSize, this.sessionIdUsernameMap.get(req.getSessionId()));
            }
            return this.executeUpdateStatement(physicalPlan, req.getSessionId());
        }
        catch (ParseCancellationException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)(req.getStatement() + " " + e.getMessage()));
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)e.getMessage());
        }
        catch (SQLParserException e) {
            logger.error(CHECK_METADATA_ERROR, (Throwable)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)(CHECK_METADATA_ERROR + e.getMessage()));
        }
        catch (QueryProcessException e) {
            logger.info(ERROR_PARSING_SQL, (Object)e.getMessage());
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.QUERY_PROCESS_ERROR, (String)("Meet error in query process: " + e.getMessage())));
        }
        catch (Exception e) {
            logger.error(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        try {
            PhysicalPlan physicalPlan;
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            String statement = req.getStatement();
            try {
                physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(req.getSessionId()), req.fetchSize);
            }
            catch (QueryProcessException | SQLParserException e) {
                logger.info(ERROR_PARSING_SQL, (Object)(req.getStatement() + " " + e.getMessage()));
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)e.getMessage());
            }
            if (!physicalPlan.isQuery()) {
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
            }
            return this.internalExecuteQueryStatement(statement, req.statementId, physicalPlan, req.fetchSize, this.sessionIdUsernameMap.get(req.getSessionId()));
        }
        catch (ParseCancellationException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)(req.getStatement() + " " + e.getMessage()));
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)(ERROR_PARSING_SQL + e.getMessage()));
        }
        catch (SQLParserException e) {
            logger.error(CHECK_METADATA_ERROR, (Throwable)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)(CHECK_METADATA_ERROR + e.getMessage()));
        }
        catch (Exception e) {
            logger.error(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
        }
    }

    public TSExecuteStatementResp executeRawDataQuery(TSRawDataQueryReq req) {
        try {
            PhysicalPlan physicalPlan;
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            try {
                physicalPlan = this.processor.rawDataQueryReqToPhysicalPlan(req);
            }
            catch (QueryProcessException | SQLParserException e) {
                logger.info(ERROR_PARSING_SQL, (Object)e.getMessage());
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)e.getMessage());
            }
            if (!physicalPlan.isQuery()) {
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is not a query statement.");
            }
            return this.internalExecuteQueryStatement("", req.statementId, physicalPlan, req.fetchSize, this.sessionIdUsernameMap.get(req.getSessionId()));
        }
        catch (ParseCancellationException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)e.getMessage());
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)(ERROR_PARSING_SQL + e.getMessage()));
        }
        catch (SQLParserException e) {
            logger.error(CHECK_METADATA_ERROR, (Throwable)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.METADATA_ERROR, (String)(CHECK_METADATA_ERROR + e.getMessage()));
        }
        catch (Exception e) {
            logger.error(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp internalExecuteQueryStatement(String statement, long statementId, PhysicalPlan plan, int fetchSize, String username) throws IOException {
        queryCount.incrementAndGet();
        auditLogger.debug("Session {} execute Query: {}", (Object)this.currSessionId.get(), (Object)statement);
        long startTime = System.currentTimeMillis();
        long queryId = -1L;
        try {
            TSQueryDataSet result;
            TSExecuteStatementResp resp = this.getQueryResp(plan, username);
            if (fetchSize == 0) {
                fetchSize = 10000;
            }
            if (plan instanceof ShowTimeSeriesPlan) {
                if (((ShowTimeSeriesPlan)plan).getLimit() == 0) {
                    ((ShowTimeSeriesPlan)plan).setLimit(fetchSize);
                    ((ShowTimeSeriesPlan)plan).setHasLimit(false);
                } else {
                    ((ShowTimeSeriesPlan)plan).setHasLimit(true);
                }
            }
            if (plan instanceof QueryPlan && !((QueryPlan)plan).isAlignByTime()) {
                if (plan.getOperatorType() == Operator.OperatorType.AGGREGATION) {
                    throw new QueryProcessException("Aggregation doesn't support disable align clause.");
                }
                if (plan.getOperatorType() == Operator.OperatorType.FILL) {
                    throw new QueryProcessException("Fill doesn't support disable align clause.");
                }
                if (plan.getOperatorType() == Operator.OperatorType.GROUPBYTIME) {
                    throw new QueryProcessException("Group by doesn't support disable align clause.");
                }
            }
            if (plan.getOperatorType() == Operator.OperatorType.AGGREGATION) {
                resp.setIgnoreTimeStamp(true);
                fetchSize = 1;
            }
            if (plan instanceof GroupByTimePlan) {
                GroupByTimePlan groupByTimePlan = (GroupByTimePlan)plan;
                fetchSize = Math.min((int)((groupByTimePlan.getEndTime() - groupByTimePlan.getStartTime()) / groupByTimePlan.getInterval()), fetchSize);
            }
            resp.setOperationType(plan.getOperatorType().toString());
            int deduplicatedPathNum = -1;
            if (plan instanceof AlignByDevicePlan) {
                deduplicatedPathNum = ((AlignByDevicePlan)plan).getMeasurements().size();
            } else if (plan instanceof LastQueryPlan) {
                deduplicatedPathNum = 2;
                fetchSize = Math.min(((LastQueryPlan)plan).getDeduplicatedPaths().size(), fetchSize);
            } else if (plan instanceof RawDataQueryPlan) {
                deduplicatedPathNum = ((RawDataQueryPlan)plan).getDeduplicatedPaths().size();
            }
            queryId = this.generateQueryId(true, fetchSize, deduplicatedPathNum);
            if (plan instanceof QueryPlan && this.config.isEnablePerformanceTracing()) {
                if (!(plan instanceof AlignByDevicePlan)) {
                    TracingManager.getInstance().writeQueryInfo(queryId, statement, startTime, plan.getPaths().size());
                } else {
                    TracingManager.getInstance().writeQueryInfo(queryId, statement, startTime);
                }
            }
            this.statementId2QueryId.computeIfAbsent(statementId, k -> new CopyOnWriteArraySet()).add(queryId);
            if (plan instanceof AuthorPlan) {
                plan.setLoginUserName(username);
            }
            QueryDataSet newDataSet = this.createQueryDataSet(queryId, plan);
            if (plan instanceof QueryPlan && !((QueryPlan)plan).isAlignByTime() && newDataSet instanceof NonAlignEngineDataSet) {
                result = this.fillRpcNonAlignReturnData(fetchSize, newDataSet, username);
                resp.setNonAlignQueryDataSet((TSQueryNonAlignDataSet)result);
            } else {
                if (plan instanceof ShowPlan && ((ShowPlan)plan).getShowContentType() == ShowPlan.ShowContentType.TIMESERIES) {
                    resp.setColumns(newDataSet.getPaths().stream().map(Path::getFullPath).collect(Collectors.toList()));
                    resp.setDataTypeList(newDataSet.getDataTypes().stream().map(Enum::toString).collect(Collectors.toList()));
                }
                result = this.fillRpcReturnData(fetchSize, newDataSet, username);
                resp.setQueryDataSet(result);
            }
            resp.setQueryId(queryId);
            if (plan instanceof AlignByDevicePlan && this.config.isEnablePerformanceTracing()) {
                TracingManager.getInstance().writePathsNum(queryId, ((AlignByDeviceDataSet)newDataSet).getPathsNum());
            }
            if (this.enableMetric) {
                long endTime = System.currentTimeMillis();
                SqlArgument sqlArgument = new SqlArgument(resp, plan, statement, startTime, endTime);
                List<SqlArgument> list = sqlArgumentList;
                synchronized (list) {
                    sqlArgumentList.add(sqlArgument);
                    if (sqlArgumentList.size() >= MAX_SIZE) {
                        sqlArgumentList.subList(0, 20).clear();
                    }
                }
            }
            TSExecuteStatementResp tSExecuteStatementResp = resp;
            return tSExecuteStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            }
            if (queryId != -1L) {
                try {
                    this.releaseQueryResource(queryId);
                }
                catch (StorageEngineException ex) {
                    logger.error("Error happened while releasing query resource: ", (Throwable)ex);
                }
            }
            TSExecuteStatementResp tSExecuteStatementResp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            return tSExecuteStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_QUERY, startTime);
            long costTime = System.currentTimeMillis() - startTime;
            if (costTime >= this.config.getSlowQueryThreshold()) {
                SLOW_SQL_LOGGER.info("Cost: " + costTime + " ms, sql is " + statement);
            }
            if (plan.isDebug()) {
                SLOW_SQL_LOGGER.info("ChunkCache used memory proportion: " + ChunkCache.getInstance().getUsedMemoryProportion() + "\nChunkMetadataCache used memory proportion: " + ChunkMetadataCache.getInstance().getUsedMemoryProportion() + "\nTimeSeriesMetadataCache used memory proportion: " + TimeSeriesMetadataCache.getInstance().getUsedMemoryProportion());
            }
        }
    }

    private TSExecuteStatementResp getQueryResp(PhysicalPlan plan, String username) throws QueryProcessException, AuthException, TException, MetadataException {
        if (plan instanceof AuthorPlan) {
            return this.getAuthQueryColumnHeaders(plan);
        }
        if (plan instanceof ShowPlan) {
            return this.getShowQueryColumnHeaders((ShowPlan)plan);
        }
        return this.getQueryColumnHeaders(plan, username);
    }

    private TSExecuteStatementResp getShowQueryColumnHeaders(ShowPlan showPlan) throws QueryProcessException {
        switch (showPlan.getShowContentType()) {
            case TTL: {
                return StaticResps.TTL_RESP;
            }
            case FLUSH_TASK_INFO: {
                return StaticResps.FLUSH_INFO_RESP;
            }
            case VERSION: {
                return StaticResps.SHOW_VERSION_RESP;
            }
            case TIMESERIES: {
                return StaticResps.SHOW_TIMESERIES_RESP;
            }
            case STORAGE_GROUP: {
                return StaticResps.SHOW_STORAGE_GROUP;
            }
            case CHILD_PATH: {
                return StaticResps.SHOW_CHILD_PATHS;
            }
            case DEVICES: {
                return StaticResps.SHOW_DEVICES;
            }
            case COUNT_NODE_TIMESERIES: {
                return StaticResps.COUNT_NODE_TIMESERIES;
            }
            case COUNT_NODES: {
                return StaticResps.COUNT_NODES;
            }
            case COUNT_TIMESERIES: {
                return StaticResps.COUNT_TIMESERIES;
            }
            case COUNT_DEVICES: {
                return StaticResps.COUNT_DEVICES;
            }
            case COUNT_STORAGE_GROUP: {
                return StaticResps.COUNT_STORAGE_GROUP;
            }
            case MERGE_STATUS: {
                return StaticResps.MERGE_STATUS_RESP;
            }
        }
        logger.error("Unsupported show content type: {}", (Object)showPlan.getShowContentType());
        throw new QueryProcessException("Unsupported show content type:" + (Object)((Object)showPlan.getShowContentType()));
    }

    private TSExecuteStatementResp getAuthQueryColumnHeaders(PhysicalPlan plan) {
        AuthorPlan authorPlan = (AuthorPlan)plan;
        switch (authorPlan.getAuthorType()) {
            case LIST_ROLE: 
            case LIST_USER_ROLES: {
                return StaticResps.LIST_ROLE_RESP;
            }
            case LIST_USER: 
            case LIST_ROLE_USERS: {
                return StaticResps.LIST_USER_RESP;
            }
            case LIST_ROLE_PRIVILEGE: {
                return StaticResps.LIST_ROLE_PRIVILEGE_RESP;
            }
            case LIST_USER_PRIVILEGE: {
                return StaticResps.LIST_USER_PRIVILEGE_RESP;
            }
        }
        return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)String.format("%s is not an auth query", new Object[]{authorPlan.getAuthorType()})));
    }

    private TSExecuteStatementResp getQueryColumnHeaders(PhysicalPlan physicalPlan, String username) throws AuthException, TException, QueryProcessException, MetadataException {
        ArrayList<String> respColumns = new ArrayList<String>();
        ArrayList<String> columnsTypes = new ArrayList<String>();
        if (!this.checkAuthorization(physicalPlan.getPaths(), physicalPlan, username)) {
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation " + (Object)((Object)physicalPlan.getOperatorType()))));
        }
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        QueryPlan plan = (QueryPlan)physicalPlan;
        if (plan instanceof AlignByDevicePlan) {
            this.getAlignByDeviceQueryHeaders((AlignByDevicePlan)plan, respColumns, columnsTypes);
        } else {
            if (plan instanceof LastQueryPlan) {
                return StaticResps.LAST_RESP.deepCopy();
            }
            if (plan instanceof AggregationPlan && ((AggregationPlan)plan).getLevel() >= 0) {
                Map<String, Long> finalPaths = FilePathUtils.getPathByLevel(((AggregationPlan)plan).getDeduplicatedPaths(), ((AggregationPlan)plan).getLevel(), null);
                for (Map.Entry<String, Long> entry : finalPaths.entrySet()) {
                    respColumns.add("count(" + entry.getKey() + ")");
                    columnsTypes.add(TSDataType.INT64.toString());
                }
            } else {
                this.getWideQueryHeaders(plan, respColumns, columnsTypes);
                resp.setColumnNameIndexMap(plan.getPathToIndex());
            }
        }
        resp.setColumns(respColumns);
        resp.setDataTypeList(columnsTypes);
        return resp;
    }

    /*
     * WARNING - void declaration
     */
    private void getWideQueryHeaders(QueryPlan plan, List<String> respColumns, List<String> columnTypes) throws TException, MetadataException {
        List<PartialPath> paths = plan.getPaths();
        List<Object> seriesTypes = new ArrayList();
        switch (plan.getOperatorType()) {
            case QUERY: 
            case FILL: {
                for (PartialPath partialPath : paths) {
                    String column = partialPath.getTsAlias();
                    if (column == null) {
                        column = partialPath.getMeasurementAlias() != null ? partialPath.getFullPathWithAlias() : partialPath.getFullPath();
                    }
                    respColumns.add(column);
                    seriesTypes.add(this.getSeriesTypeByPath(partialPath));
                }
                break;
            }
            case AGGREGATION: 
            case GROUPBYTIME: 
            case GROUP_BY_FILL: {
                void var7_11;
                List<String> aggregations = plan.getAggregations();
                if (aggregations.size() != paths.size()) {
                    void var7_9;
                    boolean bl = true;
                    while (var7_9 < paths.size()) {
                        aggregations.add(aggregations.get(0));
                        ++var7_9;
                    }
                }
                boolean bl = false;
                while (var7_11 < paths.size()) {
                    PartialPath path = paths.get((int)var7_11);
                    String column = path.getTsAlias();
                    if (column == null) {
                        column = path.getMeasurementAlias() != null ? aggregations.get((int)var7_11) + "(" + paths.get((int)var7_11).getFullPathWithAlias() + ")" : aggregations.get((int)var7_11) + "(" + paths.get((int)var7_11).getFullPath() + ")";
                    }
                    respColumns.add(column);
                    ++var7_11;
                }
                seriesTypes = this.getSeriesTypesByPaths(paths, aggregations);
                break;
            }
            default: {
                throw new TException("unsupported query type: " + (Object)((Object)plan.getOperatorType()));
            }
        }
        for (TSDataType tSDataType : seriesTypes) {
            columnTypes.add(tSDataType.toString());
        }
    }

    private void getAlignByDeviceQueryHeaders(AlignByDevicePlan plan, List<String> respColumns, List<String> columnTypes) {
        respColumns.add("Device");
        columnTypes.add(TSDataType.TEXT.toString());
        ArrayList<TSDataType> deduplicatedColumnsType = new ArrayList<TSDataType>();
        deduplicatedColumnsType.add(TSDataType.TEXT);
        LinkedHashSet<String> deduplicatedMeasurements = new LinkedHashSet<String>();
        Map<String, TSDataType> measurementDataTypeMap = plan.getColumnDataTypeMap();
        List<String> measurements = plan.getMeasurements();
        Map<String, String> measurementAliasMap = plan.getMeasurementAliasMap();
        Map<String, AlignByDevicePlan.MeasurementType> measurementTypeMap = plan.getMeasurementTypeMap();
        for (String measurement : measurements) {
            TSDataType type = TSDataType.TEXT;
            switch (measurementTypeMap.get(measurement)) {
                case Exist: {
                    type = measurementDataTypeMap.get(measurement);
                    break;
                }
                case NonExist: 
                case Constant: {
                    type = TSDataType.TEXT;
                }
            }
            respColumns.add(measurementAliasMap.getOrDefault(measurement, measurement));
            columnTypes.add(type.toString());
            if (deduplicatedMeasurements.contains(measurement)) continue;
            deduplicatedMeasurements.add(measurement);
            deduplicatedColumnsType.add(type);
        }
        plan.setMeasurements(new ArrayList<String>(deduplicatedMeasurements));
        plan.setDataTypes(deduplicatedColumnsType);
        plan.setPaths(null);
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                return RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (!this.queryId2DataSet.containsKey(req.queryId)) {
                return RpcUtils.getTSFetchResultsResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Has not executed query"));
            }
            QueryDataSet queryDataSet = this.queryId2DataSet.get(req.queryId);
            if (req.isAlign) {
                boolean hasResultSet;
                TSQueryDataSet result = this.fillRpcReturnData(req.fetchSize, queryDataSet, this.sessionIdUsernameMap.get(req.sessionId));
                boolean bl = hasResultSet = result.bufferForTime().limit() != 0;
                if (!hasResultSet) {
                    this.releaseQueryResource(req.queryId);
                }
                TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
                resp.setHasResultSet(hasResultSet);
                resp.setQueryDataSet(result);
                resp.setIsAlign(true);
                return resp;
            }
            TSQueryNonAlignDataSet nonAlignResult = this.fillRpcNonAlignReturnData(req.fetchSize, queryDataSet, this.sessionIdUsernameMap.get(req.sessionId));
            boolean hasResultSet = false;
            for (ByteBuffer timeBuffer : nonAlignResult.getTimeList()) {
                if (timeBuffer.limit() == 0) continue;
                hasResultSet = true;
                break;
            }
            if (!hasResultSet) {
                this.queryId2DataSet.remove(req.queryId);
            }
            TSFetchResultsResp resp = RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            resp.setHasResultSet(hasResultSet);
            resp.setNonAlignQueryDataSet(nonAlignResult);
            resp.setIsAlign(false);
            return resp;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            try {
                this.releaseQueryResource(req.queryId);
            }
            catch (StorageEngineException ex) {
                logger.error("Error happened while releasing query resource: ", (Throwable)ex);
            }
            return RpcUtils.getTSFetchResultsResp((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
    }

    private TSQueryDataSet fillRpcReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, IOException, InterruptedException {
        TSQueryDataSet result;
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        if (this.config.isEnableWatermark() && authorizer.isUserUseWaterMark(userName)) {
            if (!this.config.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", this.config.getWatermarkMethodName()));
            }
            GroupedLSBWatermarkEncoder encoder = new GroupedLSBWatermarkEncoder(this.config);
            result = queryDataSet instanceof RawQueryDataSetWithoutValueFilter ? ((RawQueryDataSetWithoutValueFilter)queryDataSet).fillBuffer(fetchSize, encoder) : QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize, encoder);
        } else {
            result = queryDataSet instanceof RawQueryDataSetWithoutValueFilter ? ((RawQueryDataSetWithoutValueFilter)queryDataSet).fillBuffer(fetchSize, null) : QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize);
        }
        return result;
    }

    private TSQueryNonAlignDataSet fillRpcNonAlignReturnData(int fetchSize, QueryDataSet queryDataSet, String userName) throws TException, AuthException, InterruptedException {
        TSQueryNonAlignDataSet result;
        IAuthorizer authorizer;
        try {
            authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        if (this.config.isEnableWatermark() && authorizer.isUserUseWaterMark(userName)) {
            if (!this.config.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", this.config.getWatermarkMethodName()));
            }
            GroupedLSBWatermarkEncoder encoder = new GroupedLSBWatermarkEncoder(this.config);
            result = ((NonAlignEngineDataSet)queryDataSet).fillBuffer(fetchSize, encoder);
        } else {
            result = ((NonAlignEngineDataSet)queryDataSet).fillBuffer(fetchSize, null);
        }
        return result;
    }

    private QueryDataSet createQueryDataSet(long queryId, PhysicalPlan physicalPlan) throws QueryProcessException, QueryFilterOptimizationException, StorageEngineException, IOException, MetadataException, SQLException, TException, InterruptedException {
        QueryContext context = this.genQueryContext(queryId, physicalPlan.isDebug());
        QueryDataSet queryDataSet = this.executor.processQuery(physicalPlan, context);
        this.queryId2DataSet.put(queryId, queryDataSet);
        return queryDataSet;
    }

    protected QueryContext genQueryContext(long queryId, boolean debug) {
        return new QueryContext(queryId, debug);
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            String statement = req.getStatement();
            return this.executeUpdateStatement(statement, req.getSessionId());
        }
        catch (Exception e) {
            logger.error(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage()));
        }
    }

    private TSExecuteStatementResp executeUpdateStatement(PhysicalPlan plan, long sessionId) {
        TSStatus status = this.checkAuthority(plan, sessionId);
        if (status != null) {
            return new TSExecuteStatementResp(status);
        }
        status = this.executeNonQueryPlan(plan);
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatus)status);
        long queryId = this.generateQueryId(false, 10000, -1);
        resp.setQueryId(queryId);
        return resp;
    }

    private boolean executeNonQuery(PhysicalPlan plan) throws QueryProcessException, StorageGroupNotSetException, StorageEngineException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new QueryProcessException("Current system mode is read-only, does not support non-query operation");
        }
        return this.executor.processNonQuery(plan);
    }

    private TSExecuteStatementResp executeUpdateStatement(String statement, long sessionId) {
        PhysicalPlan physicalPlan;
        try {
            physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.sessionIdZoneIdMap.get(sessionId), 10000);
        }
        catch (QueryProcessException | SQLParserException e) {
            logger.warn(ERROR_PARSING_SQL, (Object)statement, (Object)e);
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SQL_PARSE_ERROR, (String)e.getMessage());
        }
        if (physicalPlan.isQuery()) {
            return RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Statement is a query statement.");
        }
        return this.executeUpdateStatement(physicalPlan, sessionId);
    }

    private boolean checkLogin(long sessionId) {
        return this.sessionIdUsernameMap.get(sessionId) != null;
    }

    private boolean checkAuthorization(List<PartialPath> paths, PhysicalPlan plan, String username) throws AuthException {
        String targetUser = null;
        if (plan instanceof AuthorPlan) {
            targetUser = ((AuthorPlan)plan).getUserName();
        }
        return AuthorityChecker.check(username, paths, plan.getOperatorType(), targetUser);
    }

    protected void handleClientExit() {
        Long sessionId = this.currSessionId.get();
        if (sessionId != null) {
            TSCloseSessionReq req = new TSCloseSessionReq(sessionId.longValue());
            this.closeSession(req);
        }
    }

    public TSGetTimeZoneResp getTimeZone(long sessionId) {
        TSGetTimeZoneResp resp = null;
        try {
            TSStatus tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            ZoneId zoneId = this.sessionIdZoneIdMap.get(sessionId);
            if (zoneId != null) {
                resp = new TSGetTimeZoneResp(tsStatus, zoneId.toString());
            }
        }
        catch (Exception e) {
            logger.error("meet error while generating time zone.", (Throwable)e);
            TSStatus tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.GENERATE_TIME_ZONE_ERROR);
            resp = new TSGetTimeZoneResp(tsStatus, "Unknown time zone");
        }
        return resp;
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        TSStatus tsStatus;
        try {
            String timeZoneID = req.getTimeZone();
            this.sessionIdZoneIdMap.put(req.getSessionId(), ZoneId.of(timeZoneID));
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            logger.error("meet error while setting time zone.", (Throwable)e);
            tsStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SET_TIME_ZONE_ERROR);
        }
        return new TSStatus(tsStatus);
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion(IoTDBConstant.VERSION);
        logger.info("IoTDB server version: {}", (Object)IoTDBConstant.VERSION);
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        return properties;
    }

    public TSStatus insertRecords(TSInsertRecordsReq req) {
        if (auditLogger.isDebugEnabled()) {
            auditLogger.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{this.currSessionId.get(), req.deviceIds.get(0), req.getTimestamps().get(0)});
        }
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        for (int i = 0; i < req.deviceIds.size(); ++i) {
            try {
                InsertRowPlan plan = new InsertRowPlan(new PartialPath((String)req.getDeviceIds().get(i)), (long)((Long)req.getTimestamps().get(i)), ((List)req.getMeasurementsList().get(i)).toArray(new String[0]), (ByteBuffer)req.valuesList.get(i));
                TSStatus status = this.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    statusList.add(status);
                    continue;
                }
                statusList.add(this.executeNonQueryPlan(plan));
                continue;
            }
            catch (Exception e) {
                logger.error("meet error when insert in batch", (Throwable)e);
                statusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR));
            }
        }
        return RpcUtils.getStatus(statusList);
    }

    public TSStatus insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) throws TException {
        if (auditLogger.isDebugEnabled()) {
            auditLogger.debug("Session {} insertRecords, device {}, first time {}", new Object[]{this.currSessionId.get(), req.deviceId, req.getTimestamps().get(0)});
        }
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        try {
            InsertRowsOfOneDevicePlan plan = new InsertRowsOfOneDevicePlan(new PartialPath(req.getDeviceId()), req.getTimestamps().toArray(new Long[0]), req.getMeasurementsList(), req.getValuesList().toArray(new ByteBuffer[0]));
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                statusList.add(status);
            } else {
                statusList.add(this.executeNonQueryPlan(plan));
            }
        }
        catch (Exception e) {
            logger.error("meet error when insert in batch", (Throwable)e);
            statusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR));
        }
        return RpcUtils.getStatus(statusList);
    }

    public TSStatus insertStringRecords(TSInsertStringRecordsReq req) throws TException {
        if (auditLogger.isDebugEnabled()) {
            auditLogger.debug("Session {} insertRecords, first device {}, first time {}", new Object[]{this.currSessionId.get(), req.deviceIds.get(0), req.getTimestamps().get(0)});
        }
        if (!this.checkLogin(req.getSessionId())) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
        }
        ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
        InsertRowPlan plan = new InsertRowPlan();
        for (int i = 0; i < req.deviceIds.size(); ++i) {
            try {
                plan.setDeviceId(new PartialPath((String)req.getDeviceIds().get(i)));
                plan.setTime((Long)req.getTimestamps().get(i));
                plan.setMeasurements(((List)req.getMeasurementsList().get(i)).toArray(new String[0]));
                plan.setDataTypes(new TSDataType[plan.getMeasurements().length]);
                plan.setValues(((List)req.getValuesList().get(i)).toArray(new Object[((List)req.getValuesList().get(i)).size()]));
                plan.setNeedInferType(true);
                TSStatus status = this.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    statusList.add(status);
                    continue;
                }
                statusList.add(this.executeNonQueryPlan(plan));
                continue;
            }
            catch (Exception e) {
                logger.error("meet error when insert in batch", (Throwable)e);
                statusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR));
            }
        }
        return RpcUtils.getStatus(statusList);
    }

    public TSStatus testInsertTablet(TSInsertTabletReq req) {
        logger.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertTablets(TSInsertTabletsReq req) {
        logger.debug("Test insert batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecord(TSInsertRecordReq req) {
        logger.debug("Test insert row request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecord(TSInsertStringRecordReq req) throws TException {
        logger.debug("Test insert string record request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecords(TSInsertRecordsReq req) {
        logger.debug("Test insert row in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq req) throws TException {
        logger.debug("Test insert rows in batch request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus testInsertStringRecords(TSInsertStringRecordsReq req) throws TException {
        logger.debug("Test insert string records request receive.");
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus insertRecord(TSInsertRecordReq req) {
        try {
            auditLogger.debug("Session {} insertRecord, device {}, time {}", new Object[]{this.currSessionId.get(), req.getDeviceId(), req.getTimestamp()});
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            InsertRowPlan plan = new InsertRowPlan(new PartialPath(req.getDeviceId()), req.getTimestamp(), req.getMeasurements().toArray(new String[0]), req.values);
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                return status;
            }
            return this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            logger.error("meet error when insert", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus insertStringRecord(TSInsertStringRecordReq req) throws TException {
        try {
            auditLogger.debug("Session {} insertRecord, device {}, time {}", new Object[]{this.currSessionId.get(), req.getDeviceId(), req.getTimestamp()});
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            InsertRowPlan plan = new InsertRowPlan();
            plan.setDeviceId(new PartialPath(req.getDeviceId()));
            plan.setTime(req.getTimestamp());
            plan.setMeasurements(req.getMeasurements().toArray(new String[0]));
            plan.setDataTypes(new TSDataType[plan.getMeasurements().length]);
            plan.setValues(req.getValues().toArray(new Object[req.getValues().size()]));
            plan.setNeedInferType(true);
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                return status;
            }
            return this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            logger.error("meet error when insert", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteData(TSDeleteDataReq req) throws TException {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            DeletePlan plan = new DeletePlan();
            plan.setDeleteStartTime(req.getStartTime());
            plan.setDeleteEndTime(req.getEndTime());
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            for (String path : req.getPaths()) {
                paths.add(new PartialPath(path));
            }
            plan.addPaths(paths);
            TSStatus status = this.checkAuthority(plan, req.getSessionId());
            if (status != null) {
                return new TSStatus(status);
            }
            return new TSStatus(this.executeNonQueryPlan(plan));
        }
        catch (Exception e) {
            logger.error("meet error when delete data", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablet(TSInsertTabletReq req) {
        long t1 = System.currentTimeMillis();
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSStatus;
            }
            InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(req.deviceId), req.measurements);
            insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer(req.timestamps, req.size));
            insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer(req.values, req.types, req.measurements.size(), req.size));
            insertTabletPlan.setRowCount(req.size);
            insertTabletPlan.setDataTypes(req.types);
            TSStatus status = this.checkAuthority(insertTabletPlan, req.getSessionId());
            if (status != null) {
                TSStatus tSStatus = status;
                return tSStatus;
            }
            TSStatus tSStatus = this.executeNonQueryPlan(insertTabletPlan);
            return tSStatus;
        }
        catch (Exception e) {
            logger.error("{}: error occurs when executing statements", (Object)"IoTDB", (Object)e);
            TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            return tSStatus;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus insertTablets(TSInsertTabletsReq req) {
        long t1 = System.currentTimeMillis();
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
                return tSStatus;
            }
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>();
            for (int i = 0; i < req.deviceIds.size(); ++i) {
                InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath((String)req.deviceIds.get(i)), (List)req.measurementsList.get(i));
                insertTabletPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer((ByteBuffer)req.timestampsList.get(i), (Integer)req.sizeList.get(i)));
                insertTabletPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer((ByteBuffer)req.valuesList.get(i), (List)req.typesList.get(i), ((List)req.measurementsList.get(i)).size(), (int)((Integer)req.sizeList.get(i))));
                insertTabletPlan.setRowCount((Integer)req.sizeList.get(i));
                insertTabletPlan.setDataTypes((List)req.typesList.get(i));
                TSStatus status = this.checkAuthority(insertTabletPlan, req.getSessionId());
                if (status != null) {
                    statusList.add(status);
                    continue;
                }
                statusList.add(this.executeNonQueryPlan(insertTabletPlan));
            }
            TSStatus tSStatus = RpcUtils.getStatus(statusList);
            return tSStatus;
        }
        catch (Exception e) {
            logger.error("{}: error occurs when insertTablets", (Object)"IoTDB", (Object)e);
            TSStatus tSStatus = RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)e.getMessage());
            return tSStatus;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    public TSStatus setStorageGroup(long sessionId, String storageGroup) {
        try {
            if (!this.checkLogin(sessionId)) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            SetStorageGroupPlan plan = new SetStorageGroupPlan(new PartialPath(storageGroup));
            TSStatus status = this.checkAuthority(plan, sessionId);
            if (status != null) {
                return new TSStatus(status);
            }
            return new TSStatus(this.executeNonQueryPlan(plan));
        }
        catch (Exception e) {
            logger.error("meet error when set storage group", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteStorageGroups(long sessionId, List<String> storageGroups) {
        try {
            if (!this.checkLogin(sessionId)) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            ArrayList<PartialPath> storageGroupList = new ArrayList<PartialPath>();
            for (String storageGroup : storageGroups) {
                storageGroupList.add(new PartialPath(storageGroup));
            }
            DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(storageGroupList);
            TSStatus status = this.checkAuthority(plan, sessionId);
            if (status != null) {
                return new TSStatus(status);
            }
            return new TSStatus(this.executeNonQueryPlan(plan));
        }
        catch (Exception e) {
            logger.error("meet error when delete storage groups", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        try {
            CreateTimeSeriesPlan plan;
            TSStatus status;
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (auditLogger.isDebugEnabled()) {
                auditLogger.debug("Session-{} create timeseries {}", (Object)this.currSessionId.get(), (Object)req.getPath());
            }
            if ((status = this.checkAuthority(plan = new CreateTimeSeriesPlan(new PartialPath(req.path), TSDataType.values()[req.dataType], TSEncoding.values()[req.encoding], CompressionType.values()[req.compressor], req.props, req.tags, req.attributes, req.measurementAlias), req.getSessionId())) != null) {
                return status;
            }
            return this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            logger.error("meet error when create timeseries", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus createMultiTimeseries(TSCreateMultiTimeseriesReq req) {
        try {
            if (!this.checkLogin(req.getSessionId())) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            if (auditLogger.isDebugEnabled()) {
                auditLogger.debug("Session-{} create {} timeseries, the first is {}", new Object[]{this.currSessionId.get(), req.getPaths().size(), req.getPaths().get(0)});
            }
            ArrayList<TSStatus> statusList = new ArrayList<TSStatus>(req.paths.size());
            CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan();
            CreateMultiTimeSeriesPlan createMultiTimeSeriesPlan = new CreateMultiTimeSeriesPlan();
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>(req.paths.size());
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>(req.paths.size());
            ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>(req.paths.size());
            ArrayList<CompressionType> compressors = new ArrayList<CompressionType>(req.paths.size());
            ArrayList<String> alias = null;
            if (req.measurementAliasList != null) {
                alias = new ArrayList<String>(req.paths.size());
            }
            ArrayList<Map<String, String>> props = null;
            if (req.propsList != null) {
                props = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> tags = null;
            if (req.tagsList != null) {
                tags = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Map<String, String>> attributes = null;
            if (req.attributesList != null) {
                attributes = new ArrayList<Map<String, String>>(req.paths.size());
            }
            ArrayList<Integer> indexes = new ArrayList<Integer>(req.paths.size());
            for (int i = 0; i < req.paths.size(); ++i) {
                plan.setPath(new PartialPath((String)req.paths.get(i)));
                TSStatus status = this.checkAuthority(plan, req.getSessionId());
                if (status != null) {
                    statusList.add(status);
                    continue;
                }
                paths.add(new PartialPath((String)req.paths.get(i)));
                dataTypes.add(TSDataType.values()[(Integer)req.dataTypes.get(i)]);
                encodings.add(TSEncoding.values()[(Integer)req.encodings.get(i)]);
                compressors.add(CompressionType.values()[(Integer)req.compressors.get(i)]);
                if (alias != null) {
                    alias.add((String)req.measurementAliasList.get(i));
                }
                if (props != null) {
                    props.add((Map)req.propsList.get(i));
                }
                if (tags != null) {
                    tags.add((Map)req.tagsList.get(i));
                }
                if (attributes != null) {
                    attributes.add((Map)req.attributesList.get(i));
                }
                indexes.add(i);
                statusList.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)""));
            }
            createMultiTimeSeriesPlan.setPaths(paths);
            createMultiTimeSeriesPlan.setDataTypes(dataTypes);
            createMultiTimeSeriesPlan.setEncodings(encodings);
            createMultiTimeSeriesPlan.setCompressors(compressors);
            createMultiTimeSeriesPlan.setAlias(alias);
            createMultiTimeSeriesPlan.setProps(props);
            createMultiTimeSeriesPlan.setTags(tags);
            createMultiTimeSeriesPlan.setAttributes(attributes);
            createMultiTimeSeriesPlan.setIndexes(indexes);
            this.executeNonQuery(createMultiTimeSeriesPlan);
            boolean isAllSuccessful = true;
            if (createMultiTimeSeriesPlan.getResults().entrySet().size() > 0) {
                isAllSuccessful = false;
                for (Map.Entry<Integer, Exception> entry : createMultiTimeSeriesPlan.getResults().entrySet()) {
                    statusList.set(entry.getKey(), RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)entry.getValue().getMessage()));
                }
            }
            if (isAllSuccessful) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Create multiple timeseries successfully");
                }
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            logger.debug("Create multiple timeseries failed!");
            return RpcUtils.getStatus(statusList);
        }
        catch (Exception e) {
            logger.error("meet error when create multi timeseries", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public TSStatus deleteTimeseries(long sessionId, List<String> paths) {
        try {
            if (!this.checkLogin(sessionId)) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NOT_LOGIN_ERROR);
            }
            ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
            for (String path : paths) {
                pathList.add(new PartialPath(path));
            }
            DeleteTimeSeriesPlan plan = new DeleteTimeSeriesPlan(pathList);
            TSStatus status = this.checkAuthority(plan, sessionId);
            if (status != null) {
                return status;
            }
            return this.executeNonQueryPlan(plan);
        }
        catch (Exception e) {
            logger.error("meet error when delete timeseries", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
        }
    }

    public long requestStatementId(long sessionId) {
        long statementId = this.statementIdGenerator.incrementAndGet();
        this.sessionId2StatementId.computeIfAbsent(sessionId, s -> new CopyOnWriteArraySet()).add(statementId);
        return statementId;
    }

    private TSStatus checkAuthority(PhysicalPlan plan, long sessionId) {
        List<PartialPath> paths = plan.getPaths();
        try {
            if (!this.checkAuthorization(paths, plan, this.sessionIdUsernameMap.get(sessionId))) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, (String)("No permissions for this operation " + plan.getOperatorType().toString()));
            }
        }
        catch (AuthException e) {
            logger.error("meet error while checking authorization.", (Throwable)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.UNINITIALIZED_AUTH_ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return null;
    }

    protected TSStatus executeNonQueryPlan(PhysicalPlan plan) {
        boolean execRet;
        try {
            execRet = this.executeNonQuery(plan);
        }
        catch (BatchInsertionException e) {
            return RpcUtils.getStatus(Arrays.asList(e.getFailingStatus()));
        }
        catch (QueryProcessException e) {
            logger.warn("meet error while processing non-query. ", (Throwable)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.warn(SERVER_INTERNAL_ERROR, (Object)"IoTDB", (Object)e);
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
        }
        return execRet ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Execute successfully") : RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR);
    }

    private long generateQueryId(boolean isDataQuery, int fetchSize, int deduplicatedPathNum) {
        return QueryResourceManager.getInstance().assignQueryId(isDataQuery, fetchSize, deduplicatedPathNum);
    }

    protected List<TSDataType> getSeriesTypesByPaths(List<PartialPath> paths, List<String> aggregations) throws MetadataException {
        return SchemaUtils.getSeriesTypesByPaths(paths, aggregations);
    }

    protected TSDataType getSeriesTypeByPath(PartialPath path) throws MetadataException {
        return SchemaUtils.getSeriesTypeByPaths(path);
    }
}

