/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.manage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;

public class MergeContext {
    private Map<TsFileResource, Integer> mergedChunkCnt = new HashMap<TsFileResource, Integer>();
    private Map<TsFileResource, Integer> unmergedChunkCnt = new HashMap<TsFileResource, Integer>();
    private Map<TsFileResource, Map<PartialPath, List<Long>>> unmergedChunkStartTimes = new HashMap<TsFileResource, Map<PartialPath, List<Long>>>();
    private AtomicInteger totalChunkWritten = new AtomicInteger();
    private AtomicLong totalPointWritten = new AtomicLong();

    public void clear() {
        this.mergedChunkCnt.clear();
        this.unmergedChunkCnt.clear();
        this.unmergedChunkStartTimes.clear();
    }

    public Map<TsFileResource, Integer> getMergedChunkCnt() {
        return this.mergedChunkCnt;
    }

    public void setMergedChunkCnt(Map<TsFileResource, Integer> mergedChunkCnt) {
        this.mergedChunkCnt = mergedChunkCnt;
    }

    public Map<TsFileResource, Integer> getUnmergedChunkCnt() {
        return this.unmergedChunkCnt;
    }

    public void setUnmergedChunkCnt(Map<TsFileResource, Integer> unmergedChunkCnt) {
        this.unmergedChunkCnt = unmergedChunkCnt;
    }

    public Map<TsFileResource, Map<PartialPath, List<Long>>> getUnmergedChunkStartTimes() {
        return this.unmergedChunkStartTimes;
    }

    public void setUnmergedChunkStartTimes(Map<TsFileResource, Map<PartialPath, List<Long>>> unmergedChunkStartTimes) {
        this.unmergedChunkStartTimes = unmergedChunkStartTimes;
    }

    public int getTotalChunkWritten() {
        return this.totalChunkWritten.get();
    }

    public void incTotalChunkWritten() {
        this.totalChunkWritten.incrementAndGet();
    }

    public void incTotalPointWritten(long increment) {
        this.totalPointWritten.addAndGet(increment);
    }

    public long getTotalPointWritten() {
        return this.totalPointWritten.get();
    }
}

