/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.rescon.SystemInfo;

public class StorageGroupInfo {
    private StorageGroupProcessor storageGroupProcessor;
    private AtomicLong memoryCost;
    private long storageGroupSizeReportThreshold = IoTDBDescriptor.getInstance().getConfig().getStorageGroupSizeReportThreshold();
    private AtomicLong lastReportedSize = new AtomicLong();
    private List<TsFileProcessor> reportedTsps = new CopyOnWriteArrayList<TsFileProcessor>();

    public StorageGroupInfo(StorageGroupProcessor storageGroupProcessor) {
        this.storageGroupProcessor = storageGroupProcessor;
        this.memoryCost = new AtomicLong();
    }

    public StorageGroupProcessor getStorageGroupProcessor() {
        return this.storageGroupProcessor;
    }

    public void initTsFileProcessorInfo(TsFileProcessor tsFileProcessor) {
        if (this.reportedTsps.add(tsFileProcessor)) {
            this.memoryCost.getAndAdd(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize());
        }
    }

    public void addStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(cost);
    }

    public void releaseStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(-cost);
    }

    public long getMemCost() {
        return this.memoryCost.get();
    }

    public List<TsFileProcessor> getAllReportedTsp() {
        return this.reportedTsps;
    }

    public boolean needToReportToSystem() {
        return this.memoryCost.get() - this.lastReportedSize.get() > this.storageGroupSizeReportThreshold;
    }

    public void setLastReportedSize(long size) {
        this.lastReportedSize.set(size);
    }

    public void closeTsFileProcessorAndReportToSystem(TsFileProcessor tsFileProcessor) {
        this.reportedTsps.remove(tsFileProcessor);
        SystemInfo.getInstance().resetStorageGroupStatus(this);
    }
}

