/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;

public class InsertRowsOfOneDevicePlan
extends InsertPlan {
    private InsertRowPlan[] rowPlans;

    public InsertRowsOfOneDevicePlan(PartialPath deviceId, Long[] insertTimes, List<List<String>> measurements, ByteBuffer[] insertValues) throws QueryProcessException {
        super(Operator.OperatorType.BATCH_INSERT_ONE_DEVICE);
        this.deviceId = deviceId;
        this.rowPlans = new InsertRowPlan[insertTimes.length];
        for (int i = 0; i < insertTimes.length; ++i) {
            this.rowPlans[i] = new InsertRowPlan(deviceId, (long)insertTimes[i], measurements.get(i).toArray(new String[0]), insertValues[i]);
            if (this.rowPlans[i].getMeasurements().length == 0) {
                throw new QueryProcessException("The measurements are null, deviceId:" + deviceId + ", time:" + insertTimes[i]);
            }
            if (this.rowPlans[i].getValues().length != 0) continue;
            throw new QueryProcessException("The size of values in InsertRowsOfOneDevicePlan is 0, deviceId:" + deviceId + ", time:" + insertTimes[i]);
        }
    }

    @Override
    public List<PartialPath> getPaths() {
        HashSet<PartialPath> paths = new HashSet<PartialPath>();
        for (InsertRowPlan plan : this.rowPlans) {
            paths.addAll(plan.getPaths());
        }
        return new ArrayList<PartialPath>(paths);
    }

    @Override
    public long getMinTime() {
        long minTime = Long.MAX_VALUE;
        for (InsertRowPlan plan : this.rowPlans) {
            if (minTime <= plan.getTime()) continue;
            minTime = plan.getTime();
        }
        return minTime;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = PhysicalPlan.PhysicalPlanType.BATCH_INSERT_ONE_DEVICE.ordinal();
        stream.writeByte((byte)type);
        this.putString(stream, this.deviceId.getFullPath());
        stream.writeInt(this.rowPlans.length);
        for (InsertRowPlan plan : this.rowPlans) {
            stream.writeLong(plan.getTime());
            plan.serializeMeasurementsAndValues(stream);
        }
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        buffer.put((byte)type);
        this.putString(buffer, this.deviceId.getFullPath());
        buffer.putInt(this.rowPlans.length);
        for (InsertRowPlan plan : this.rowPlans) {
            buffer.putLong(plan.getTime());
            plan.serializeMeasurementsAndValues(buffer);
        }
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.deviceId = new PartialPath(this.readString(buffer));
        this.rowPlans = new InsertRowPlan[buffer.getInt()];
        for (int i = 0; i < this.rowPlans.length; ++i) {
            this.rowPlans[i] = new InsertRowPlan();
            this.rowPlans[i].setDeviceId(this.deviceId);
            this.rowPlans[i].setTime(buffer.getLong());
            this.rowPlans[i].deserializeMeasurementsAndValues(buffer);
        }
    }

    public String toString() {
        return "deviceId: " + this.deviceId + ", times: " + this.rowPlans.length;
    }

    @Override
    public InsertPlan getPlanFromFailed() {
        if (super.getPlanFromFailed() == null) {
            return null;
        }
        ArrayList<InsertRowPlan> plans = new ArrayList<InsertRowPlan>();
        for (InsertRowPlan plan : this.rowPlans) {
            if (!plan.hasFailedValues()) continue;
            plans.add((InsertRowPlan)plan.getPlanFromFailed());
        }
        this.rowPlans = plans.toArray(new InsertRowPlan[0]);
        return this;
    }

    public InsertRowPlan[] getRowPlans() {
        return this.rowPlans;
    }
}

