/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.universal.DescPriorityMergeReader;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.utils.FileLoaderUtils;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.BatchDataFactory;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class SeriesReader {
    private TimeOrderUtils orderUtils;
    private final PartialPath seriesPath;
    private final Set<String> allSensors;
    private final TSDataType dataType;
    private final QueryContext context;
    private final Filter timeFilter;
    private final Filter valueFilter;
    private final List<TsFileResource> seqFileResource;
    private final List<TsFileResource> unseqFileResource;
    private TimeseriesMetadata firstTimeSeriesMetadata;
    private final List<TimeseriesMetadata> seqTimeSeriesMetadata = new LinkedList<TimeseriesMetadata>();
    private final PriorityQueue<TimeseriesMetadata> unSeqTimeSeriesMetadata;
    private ChunkMetadata firstChunkMetadata;
    private final PriorityQueue<ChunkMetadata> cachedChunkMetadata;
    private VersionPageReader firstPageReader;
    private final List<VersionPageReader> seqPageReaders = new LinkedList<VersionPageReader>();
    private final PriorityQueue<VersionPageReader> unSeqPageReaders;
    private final PriorityMergeReader mergeReader;
    private boolean hasCachedNextOverlappedPage;
    private BatchData cachedBatchData;

    public SeriesReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, QueryDataSource dataSource, Filter timeFilter, Filter valueFilter, TsFileFilter fileFilter, boolean ascending) {
        this.seriesPath = seriesPath;
        this.allSensors = allSensors;
        this.dataType = dataType;
        this.context = context;
        QueryUtils.filterQueryDataSource(dataSource, fileFilter);
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
        if (ascending) {
            this.orderUtils = new AscTimeOrderUtils();
            this.mergeReader = new PriorityMergeReader();
        } else {
            this.orderUtils = new DescTimeOrderUtils();
            this.mergeReader = new DescPriorityMergeReader();
        }
        this.seqFileResource = new LinkedList<TsFileResource>(dataSource.getSeqResources());
        this.unseqFileResource = this.sortUnSeqFileResources(dataSource.getUnseqResources());
        this.unSeqTimeSeriesMetadata = new PriorityQueue<TimeseriesMetadata>(this.orderUtils.comparingLong(timeSeriesMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)timeSeriesMetadata.getStatistics())));
        this.cachedChunkMetadata = new PriorityQueue<ChunkMetadata>(this.orderUtils.comparingLong(chunkMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)chunkMetadata.getStatistics())));
        this.unSeqPageReaders = new PriorityQueue<VersionPageReader>(this.orderUtils.comparingLong(versionPageReader -> this.orderUtils.getOrderTime((Statistics<? extends Object>)versionPageReader.getStatistics())));
    }

    SeriesReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, QueryContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, Filter timeFilter, Filter valueFilter, boolean ascending) {
        this.seriesPath = seriesPath;
        this.allSensors = allSensors;
        this.dataType = dataType;
        this.context = context;
        this.timeFilter = timeFilter;
        this.valueFilter = valueFilter;
        if (ascending) {
            this.orderUtils = new AscTimeOrderUtils();
            this.mergeReader = new PriorityMergeReader();
        } else {
            this.orderUtils = new DescTimeOrderUtils();
            this.mergeReader = new DescPriorityMergeReader();
        }
        this.seqFileResource = new LinkedList<TsFileResource>(seqFileResource);
        this.unseqFileResource = this.sortUnSeqFileResources(unseqFileResource);
        this.unSeqTimeSeriesMetadata = new PriorityQueue<TimeseriesMetadata>(this.orderUtils.comparingLong(timeSeriesMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)timeSeriesMetadata.getStatistics())));
        this.cachedChunkMetadata = new PriorityQueue<ChunkMetadata>(this.orderUtils.comparingLong(chunkMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)chunkMetadata.getStatistics())));
        this.unSeqPageReaders = new PriorityQueue<VersionPageReader>(this.orderUtils.comparingLong(versionPageReader -> this.orderUtils.getOrderTime((Statistics<? extends Object>)versionPageReader.getStatistics())));
    }

    public boolean isEmpty() throws IOException {
        return !this.hasNextPage() && !this.hasNextChunk() && !this.hasNextFile();
    }

    boolean hasNextFile() throws IOException {
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first cachedPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null || !this.cachedChunkMetadata.isEmpty()) {
            throw new IOException("all cached chunks should be consumed first");
        }
        if (this.firstTimeSeriesMetadata != null) {
            return true;
        }
        this.tryToUnpackAllOverlappedFilesToTimeSeriesMetadata();
        return this.firstTimeSeriesMetadata != null;
    }

    boolean isFileOverlapped() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        Statistics fileStatistics = this.firstTimeSeriesMetadata.getStatistics();
        return !this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics()) || !this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
    }

    Statistics currentFileStatistics() {
        return this.firstTimeSeriesMetadata.getStatistics();
    }

    boolean currentFileModified() throws IOException {
        if (this.firstTimeSeriesMetadata == null) {
            throw new IOException("no first file");
        }
        return this.firstTimeSeriesMetadata.isModified();
    }

    void skipCurrentFile() {
        this.firstTimeSeriesMetadata = null;
    }

    boolean hasNextChunk() throws IOException {
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IOException("all cached pages should be consumed first cachedPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null) {
            return true;
        }
        if (this.firstTimeSeriesMetadata != null) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()));
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()), true);
        } else if (!this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.peek();
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()));
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), false);
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
        }
        return this.firstChunkMetadata != null;
    }

    private void unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(long endpointTime, boolean init) throws IOException {
        while (!this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.seqTimeSeriesMetadata.remove(0));
        }
        while (!this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.unSeqTimeSeriesMetadata.poll());
        }
        if (this.firstTimeSeriesMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.firstTimeSeriesMetadata);
            this.firstTimeSeriesMetadata = null;
        }
        if (init && this.firstChunkMetadata == null && !this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
        }
    }

    private void unpackOneTimeSeriesMetadata(TimeseriesMetadata timeSeriesMetadata) throws IOException {
        List<ChunkMetadata> chunkMetadataList = FileLoaderUtils.loadChunkMetadataList(timeSeriesMetadata);
        chunkMetadataList.forEach(chunkMetadata -> chunkMetadata.setSeq(timeSeriesMetadata.isSeq()));
        if (IoTDBDescriptor.getInstance().getConfig().isEnablePerformanceTracing()) {
            QueryResourceManager queryResourceManager = QueryResourceManager.getInstance();
            queryResourceManager.getChunkNumMap().compute(this.context.getQueryId(), (k, v) -> v == null ? chunkMetadataList.size() : v + chunkMetadataList.size());
            long totalChunkSize = chunkMetadataList.stream().mapToLong(chunkMetadata -> chunkMetadata.getStatistics().getCount()).sum();
            queryResourceManager.getChunkSizeMap().compute(this.context.getQueryId(), (k, v) -> v == null ? totalChunkSize : v + totalChunkSize);
        }
        this.cachedChunkMetadata.addAll(chunkMetadataList);
    }

    boolean isChunkOverlapped() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        Statistics chunkStatistics = this.firstChunkMetadata.getStatistics();
        return !this.cachedChunkMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)chunkStatistics, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics());
    }

    Statistics currentChunkStatistics() {
        return this.firstChunkMetadata.getStatistics();
    }

    boolean currentChunkModified() throws IOException {
        if (this.firstChunkMetadata == null) {
            throw new IOException("no first chunk");
        }
        return this.firstChunkMetadata.isModified();
    }

    void skipCurrentChunk() {
        this.firstChunkMetadata = null;
    }

    boolean hasNextPage() throws IOException {
        long endpointTime;
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair() && this.hasNextOverlappedPage()) {
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData != null && this.cachedBatchData.hasCurrent()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        if (this.firstPageReader != null) {
            return true;
        }
        if (this.firstChunkMetadata != null) {
            this.unpackAllOverlappedChunkMetadataToPageReaders(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), true);
        } else {
            this.initFirstPageReader();
            if (this.firstPageReader != null) {
                endpointTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endpointTime);
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(endpointTime, false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(endpointTime, false);
            }
        }
        if (this.firstPageOverlapped() && this.hasNextOverlappedPage()) {
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData != null && this.cachedBatchData.hasCurrent()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        while (!(this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
            if (this.firstPageReader != null) {
                endpointTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endpointTime);
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(endpointTime, false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(endpointTime, false);
            }
            if (!this.firstPageOverlapped() || !this.hasNextOverlappedPage()) continue;
            this.cachedBatchData = this.nextOverlappedPage();
            if (this.cachedBatchData == null || !this.cachedBatchData.hasCurrent()) continue;
            this.hasCachedNextOverlappedPage = true;
            return true;
        }
        return this.firstPageReader != null;
    }

    private boolean firstPageOverlapped() throws IOException {
        if (this.firstPageReader == null) {
            return false;
        }
        return !this.seqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics()) || !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) || this.mergeReader.hasNextTimeValuePair() && this.mergeReader.currentTimeValuePair().getTimestamp() >= this.firstPageReader.getStatistics().getStartTime();
    }

    private void unpackAllOverlappedChunkMetadataToPageReaders(long endpointTime, boolean init) throws IOException {
        if (this.firstChunkMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstChunkMetadata.getStatistics())) {
            this.unpackOneChunkMetaData(this.firstChunkMetadata);
            this.firstChunkMetadata = null;
        }
        boolean hasMeetSeq = false;
        while (!(this.cachedChunkMetadata.isEmpty() || !this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics()) || this.cachedChunkMetadata.peek().isSeq() && hasMeetSeq)) {
            if (this.cachedChunkMetadata.peek().isSeq()) {
                hasMeetSeq = true;
            }
            this.unpackOneChunkMetaData(this.cachedChunkMetadata.poll());
        }
        if (!(!init || this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
        }
    }

    private void unpackOneChunkMetaData(ChunkMetadata chunkMetaData) throws IOException {
        FileLoaderUtils.loadPageReaderList(chunkMetaData, this.timeFilter).forEach(pageReader -> {
            if (chunkMetaData.isSeq()) {
                if (this.orderUtils.getAscending()) {
                    this.seqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), (IPageReader)pageReader, true));
                } else {
                    this.seqPageReaders.add(0, new VersionPageReader(chunkMetaData.getVersion(), (IPageReader)pageReader, true));
                }
            } else {
                this.unSeqPageReaders.add(new VersionPageReader(chunkMetaData.getVersion(), (IPageReader)pageReader, false));
            }
        });
    }

    boolean isPageOverlapped() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair() && (this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() <= this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && this.mergeReader.currentTimeValuePair().getTimestamp() >= this.firstPageReader.getStatistics().getStartTime())) {
            throw new IOException("overlapped data should be consumed first");
        }
        Statistics firstPageStatistics = this.firstPageReader.getStatistics();
        return !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)firstPageStatistics, (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics());
    }

    Statistics currentPageStatistics() {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getStatistics();
    }

    boolean currentPageModified() throws IOException {
        if (this.firstPageReader == null) {
            throw new IOException("no first page");
        }
        return this.firstPageReader.isModified();
    }

    void skipCurrentPage() {
        this.firstPageReader = null;
    }

    BatchData nextPage() throws IOException {
        if (!this.hasNextPage()) {
            throw new IOException("no next page, neither non-overlapped nor overlapped");
        }
        if (this.hasCachedNextOverlappedPage) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedBatchData;
        }
        if (this.valueFilter != null) {
            this.firstPageReader.setFilter(this.valueFilter);
        }
        BatchData batchData = this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending());
        this.firstPageReader = null;
        return batchData;
    }

    private boolean hasNextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        this.tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader();
        while (this.mergeReader.hasNextTimeValuePair()) {
            this.cachedBatchData = BatchDataFactory.createBatchData((TSDataType)this.dataType, (boolean)this.orderUtils.getAscending(), (boolean)true);
            long currentPageEndPointTime = this.mergeReader.getCurrentReadStopTime();
            if (this.firstPageReader != null) {
                currentPageEndPointTime = this.orderUtils.getCurrentEndPoint(currentPageEndPointTime, (Statistics<? extends Object>)this.firstPageReader.getStatistics());
            }
            if (!this.seqPageReaders.isEmpty()) {
                currentPageEndPointTime = this.orderUtils.getCurrentEndPoint(currentPageEndPointTime, (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics());
            }
            while (this.mergeReader.hasNextTimeValuePair()) {
                TimeValuePair timeValuePair = this.mergeReader.currentTimeValuePair();
                if (this.orderUtils.isExcessEndpoint(timeValuePair.getTimestamp(), currentPageEndPointTime)) {
                    if (this.cachedBatchData.hasCurrent() || this.firstPageReader != null || !this.seqPageReaders.isEmpty()) break;
                    currentPageEndPointTime = this.mergeReader.getCurrentReadStopTime();
                }
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(timeValuePair.getTimestamp());
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(timeValuePair.getTimestamp(), false);
                this.unpackAllOverlappedUnseqPageReadersToMergeReader(timeValuePair.getTimestamp());
                timeValuePair = this.mergeReader.currentTimeValuePair();
                if (this.firstPageReader != null) {
                    if (this.orderUtils.getAscending() && timeValuePair.getTimestamp() > this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && timeValuePair.getTimestamp() < this.firstPageReader.getStatistics().getStartTime()) {
                        this.hasCachedNextOverlappedPage = this.cachedBatchData.hasCurrent();
                        return this.hasCachedNextOverlappedPage;
                    }
                    this.mergeReader.addReader((IPointReader)this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()).getBatchDataIterator(), this.firstPageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics()));
                    currentPageEndPointTime = this.updateEndPointTime(currentPageEndPointTime, this.firstPageReader);
                    this.firstPageReader = null;
                }
                if (!this.seqPageReaders.isEmpty()) {
                    if (this.orderUtils.getAscending() && timeValuePair.getTimestamp() > this.seqPageReaders.get(0).getStatistics().getEndTime() || !this.orderUtils.getAscending() && timeValuePair.getTimestamp() < this.seqPageReaders.get(0).getStatistics().getStartTime()) {
                        this.hasCachedNextOverlappedPage = this.cachedBatchData.hasCurrent();
                        return this.hasCachedNextOverlappedPage;
                    }
                    VersionPageReader pageReader = this.seqPageReaders.remove(0);
                    this.mergeReader.addReader((IPointReader)pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()).getBatchDataIterator(), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()));
                    currentPageEndPointTime = this.updateEndPointTime(currentPageEndPointTime, pageReader);
                }
                timeValuePair = this.mergeReader.nextTimeValuePair();
                if (this.valueFilter != null && !this.valueFilter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
                this.cachedBatchData.putAnObject(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue());
            }
            this.cachedBatchData.flip();
            this.hasCachedNextOverlappedPage = this.cachedBatchData.hasCurrent();
            if (this.hasCachedNextOverlappedPage) {
                return true;
            }
            if (!this.mergeReader.hasNextTimeValuePair()) continue;
            return false;
        }
        return false;
    }

    private long updateEndPointTime(long currentPageEndPointTime, VersionPageReader pageReader) {
        if (this.orderUtils.getAscending()) {
            return Math.min(currentPageEndPointTime, pageReader.getStatistics().getEndTime());
        }
        return Math.max(currentPageEndPointTime, pageReader.getStatistics().getStartTime());
    }

    private void tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader() throws IOException {
        if (this.firstPageReader == null && this.unSeqPageReaders.isEmpty() && this.seqPageReaders.isEmpty()) {
            return;
        }
        if (this.firstPageReader == null) {
            this.initFirstPageReader();
        }
        long currentPageEndpointTime = this.mergeReader.hasNextTimeValuePair() ? this.mergeReader.getCurrentReadStopTime() : this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedUnseqPageReadersToMergeReader(currentPageEndpointTime);
    }

    private void initFirstPageReader() {
        if (!this.seqPageReaders.isEmpty() && !this.unSeqPageReaders.isEmpty()) {
            this.firstPageReader = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) ? this.seqPageReaders.remove(0) : this.unSeqPageReaders.poll();
        } else if (!this.seqPageReaders.isEmpty()) {
            this.firstPageReader = this.seqPageReaders.remove(0);
        } else if (!this.unSeqPageReaders.isEmpty()) {
            this.firstPageReader = this.unSeqPageReaders.poll();
        }
    }

    private void unpackAllOverlappedUnseqPageReadersToMergeReader(long endpointTime) throws IOException {
        while (!this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqPageReaders.peek().data.getStatistics())) {
            this.putPageReaderToMergeReader(this.unSeqPageReaders.poll());
        }
        if (this.firstPageReader != null && !this.firstPageReader.isSeq() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstPageReader.getStatistics())) {
            this.putPageReaderToMergeReader(this.firstPageReader);
            this.firstPageReader = null;
        }
    }

    private void putPageReaderToMergeReader(VersionPageReader pageReader) throws IOException {
        this.mergeReader.addReader((IPointReader)pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()).getBatchDataIterator(), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()));
    }

    private BatchData nextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage || this.hasNextOverlappedPage()) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedBatchData;
        }
        throw new IOException("No more batch data");
    }

    private LinkedList<TsFileResource> sortUnSeqFileResources(List<TsFileResource> tsFileResources) {
        return tsFileResources.stream().sorted(this.orderUtils.comparingLong(tsFileResource -> this.orderUtils.getOrderTime((TsFileResource)tsFileResource))).collect(Collectors.toCollection(LinkedList::new));
    }

    private void tryToUnpackAllOverlappedFilesToTimeSeriesMetadata() throws IOException {
        TimeseriesMetadata timeseriesMetadata;
        while (this.seqTimeSeriesMetadata.isEmpty() && !this.seqFileResource.isEmpty()) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.orderUtils.getNextSeqFileResource(this.seqFileResource, true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setSeq(true);
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        while (this.unSeqTimeSeriesMetadata.isEmpty() && !this.unseqFileResource.isEmpty()) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.unseqFileResource.remove(0), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setModified(true);
            timeseriesMetadata.setSeq(false);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        long endTime = -1L;
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics());
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getCurrentEndPoint((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        }
        if (endTime != -1L) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endTime);
        }
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.seqTimeSeriesMetadata.remove(0);
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.unSeqTimeSeriesMetadata.poll();
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics()) ? this.seqTimeSeriesMetadata.remove(0) : this.unSeqTimeSeriesMetadata.poll();
        }
    }

    private void unpackAllOverlappedTsFilesToTimeSeriesMetadata(long endpointTime) throws IOException {
        TimeseriesMetadata timeseriesMetadata;
        while (!this.unseqFileResource.isEmpty() && this.orderUtils.isOverlapped(endpointTime, this.unseqFileResource.get(0))) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.unseqFileResource.remove(0), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setModified(true);
            timeseriesMetadata.setSeq(false);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
        }
        while (!this.seqFileResource.isEmpty() && this.orderUtils.isOverlapped(endpointTime, this.orderUtils.getNextSeqFileResource(this.seqFileResource, false))) {
            timeseriesMetadata = FileLoaderUtils.loadTimeSeriesMetadata(this.orderUtils.getNextSeqFileResource(this.seqFileResource, true), this.seriesPath, this.context, this.getAnyFilter(), this.allSensors);
            if (timeseriesMetadata == null) continue;
            timeseriesMetadata.setSeq(true);
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
        }
    }

    private Filter getAnyFilter() {
        return this.timeFilter != null ? this.timeFilter : this.valueFilter;
    }

    void setTimeFilter(long timestamp) {
        ((UnaryFilter)this.timeFilter).setValue((Comparable)Long.valueOf(timestamp));
    }

    Filter getTimeFilter() {
        return this.timeFilter;
    }

    public TimeOrderUtils getOrderUtils() {
        return this.orderUtils;
    }

    class AscTimeOrderUtils
    implements TimeOrderUtils {
        AscTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getStartTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getStartTime(SeriesReader.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getEndTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getEndTime() >= right.getStartTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time >= right.getStartTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time >= right.getStartTime(SeriesReader.this.seriesPath.getDevice());
        }

        @Override
        public TsFileResource getNextSeqFileResource(List<TsFileResource> seqResources, boolean isDelete) {
            if (isDelete) {
                return seqResources.remove(0);
            }
            return seqResources.get(0);
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.min(time, statistics.getEndTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.min(seqStatistics.getEndTime(), unseqStatistics.getEndTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time > endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getStartTime() < unseqStatistics.getStartTime();
        }

        @Override
        public boolean getAscending() {
            return true;
        }
    }

    class DescTimeOrderUtils
    implements TimeOrderUtils {
        DescTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getEndTime();
        }

        @Override
        public long getOrderTime(TsFileResource fileResource) {
            return fileResource.getEndTime(SeriesReader.this.seriesPath.getDevice());
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getStartTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getStartTime() <= right.getEndTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time <= right.getEndTime();
        }

        @Override
        public boolean isOverlapped(long time, TsFileResource right) {
            return time <= right.getEndTime(SeriesReader.this.seriesPath.getDevice());
        }

        @Override
        public TsFileResource getNextSeqFileResource(List<TsFileResource> seqResources, boolean isDelete) {
            if (isDelete) {
                return seqResources.remove(seqResources.size() - 1);
            }
            return seqResources.get(seqResources.size() - 1);
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c2), keyExtractor.applyAsLong(c1));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.max(time, statistics.getStartTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.max(seqStatistics.getStartTime(), unseqStatistics.getStartTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time < endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getEndTime() > unseqStatistics.getEndTime();
        }

        @Override
        public boolean getAscending() {
            return false;
        }
    }

    public static interface TimeOrderUtils {
        public long getOrderTime(Statistics<? extends Object> var1);

        public long getOrderTime(TsFileResource var1);

        public long getOverlapCheckTime(Statistics<? extends Object> var1);

        public boolean isOverlapped(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isOverlapped(long var1, Statistics<? extends Object> var3);

        public boolean isOverlapped(long var1, TsFileResource var3);

        public TsFileResource getNextSeqFileResource(List<TsFileResource> var1, boolean var2);

        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> var1);

        public long getCurrentEndPoint(long var1, Statistics<? extends Object> var3);

        public long getCurrentEndPoint(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isExcessEndpoint(long var1, long var3);

        public boolean isTakeSeqAsFirst(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean getAscending();
    }

    private class VersionPageReader {
        protected long version;
        protected IPageReader data;
        protected boolean isSeq;

        VersionPageReader(long version, IPageReader data, boolean isSeq) {
            this.version = version;
            this.data = data;
            this.isSeq = isSeq;
        }

        Statistics getStatistics() {
            return this.data.getStatistics();
        }

        BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
            return this.data.getAllSatisfiedPageData(ascending);
        }

        void setFilter(Filter filter) {
            this.data.setFilter(filter);
        }

        boolean isModified() {
            return this.data.isModified();
        }

        public boolean isSeq() {
            return this.isSeq;
        }
    }
}

