/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionMergeTaskPoolManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(CompactionMergeTaskPoolManager.class);
    private static final CompactionMergeTaskPoolManager INSTANCE = new CompactionMergeTaskPoolManager();
    private ExecutorService pool;

    public static CompactionMergeTaskPoolManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void start() {
        if (this.pool == null) {
            this.pool = IoTDBThreadPoolFactory.newScheduledThreadPool(IoTDBDescriptor.getInstance().getConfig().getCompactionThreadNum(), ThreadName.COMPACTION_SERVICE.getName());
        }
        logger.info("Compaction task manager started.");
    }

    @Override
    public void stop() {
        if (this.pool != null) {
            this.pool.shutdownNow();
            logger.info("Waiting for task pool to shut down");
            this.waitTermination();
        }
    }

    @Override
    public void waitAndStop(long milliseconds) {
        if (this.pool != null) {
            this.awaitTermination(this.pool, milliseconds);
            logger.info("Waiting for task pool to shut down");
            this.waitTermination();
        }
    }

    public void waitAllCompactionFinish() {
        if (this.pool != null) {
            File sgDir = FSFactoryProducer.getFSFactory().getFile(FilePathUtils.regularizePath(IoTDBDescriptor.getInstance().getConfig().getSystemDir()) + "storage_groups");
            File[] subDirList = sgDir.listFiles();
            if (subDirList != null) {
                for (File subDir : subDirList) {
                    while (FSFactoryProducer.getFSFactory().getFile(subDir.getAbsoluteFile() + File.separator + subDir.getName() + ".compaction.log").exists()) {
                    }
                }
            }
            logger.info("All compaction task finish");
        }
    }

    private void waitTermination() {
        long startTime = System.currentTimeMillis();
        while (!this.pool.isTerminated()) {
            int timeMillis = 0;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.error("CompactionMergeTaskPoolManager {} shutdown", (Object)ThreadName.COMPACTION_SERVICE.getName(), (Object)e);
                Thread.currentThread().interrupt();
            }
            long time = System.currentTimeMillis() - startTime;
            if ((timeMillis += 200) % 60000 != 0) continue;
            logger.warn("CompactionManager has wait for {} seconds to stop", (Object)(time / 1000L));
        }
        this.pool = null;
        logger.info("CompactionManager stopped");
    }

    private void awaitTermination(ExecutorService service, long milliseconds) {
        try {
            service.shutdown();
            service.awaitTermination(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("CompactionThreadPool can not be closed in {} ms", (Object)milliseconds);
            Thread.currentThread().interrupt();
        }
        service.shutdownNow();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.COMPACTION_SERVICE;
    }

    public void submitTask(Runnable compactionMergeTask) throws RejectedExecutionException {
        if (this.pool != null && !this.pool.isTerminated()) {
            this.pool.submit(compactionMergeTask);
        }
    }

    public boolean isTerminated() {
        return this.pool == null || this.pool.isTerminated();
    }
}

