/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.no;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCompactionTsFileManagement
extends TsFileManagement {
    private static final Logger logger = LoggerFactory.getLogger(NoCompactionTsFileManagement.class);
    private final Map<Long, TreeSet<TsFileResource>> sequenceFileTreeSetMap = new TreeMap<Long, TreeSet<TsFileResource>>();
    private final Map<Long, List<TsFileResource>> unSequenceFileListMap = new TreeMap<Long, List<TsFileResource>>();

    public NoCompactionTsFileManagement(String storageGroupName, String storageGroupDir) {
        super(storageGroupName, storageGroupDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public List<TsFileResource> getTsFileList(boolean sequence) {
        ArrayList<TsFileResource> result = new ArrayList<TsFileResource>();
        if (sequence) {
            Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
            synchronized (map) {
                for (TreeSet<TsFileResource> tsFileResourceTreeSet : this.sequenceFileTreeSetMap.values()) {
                    result.addAll(tsFileResourceTreeSet);
                }
            }
        }
        Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
        synchronized (map) {
            for (List<TsFileResource> tsFileResourceList : this.unSequenceFileListMap.values()) {
                result.addAll(tsFileResourceList);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TsFileResource> getTsFileListByTimePartition(boolean sequence, long timePartition) {
        if (sequence) {
            Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
            synchronized (map) {
                return new ArrayList<TsFileResource>(this.sequenceFileTreeSetMap.getOrDefault(timePartition, new TreeSet()));
            }
        }
        Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
        synchronized (map) {
            return new ArrayList<TsFileResource>(this.unSequenceFileListMap.getOrDefault(timePartition, Collections.emptyList()));
        }
    }

    @Override
    public Iterator<TsFileResource> getIterator(boolean sequence) {
        return this.getTsFileList(sequence).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
            synchronized (map) {
                TreeSet<TsFileResource> sequenceFileTreeSet = this.sequenceFileTreeSetMap.get(tsFileResource.getTimePartition());
                sequenceFileTreeSet.remove(tsFileResource);
            }
        }
        Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
        synchronized (map) {
            List<TsFileResource> unSequenceFileList = this.unSequenceFileListMap.get(tsFileResource.getTimePartition());
            unSequenceFileList.remove(tsFileResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        if (tsFileResourceList.size() > 0) {
            tsFileResourceList.sort((o1, o2) -> (int)(o1.getTimePartition() - o2.getTimePartition()));
            if (sequence) {
                Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
                synchronized (map) {
                    long currTimePartition = tsFileResourceList.get(0).getTimePartition();
                    int startIndex = 0;
                    for (int i = 1; i < tsFileResourceList.size(); ++i) {
                        TsFileResource tsFileResource = tsFileResourceList.get(i);
                        if (tsFileResource.getTimePartition() == currTimePartition) continue;
                        this.sequenceFileTreeSetMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, i));
                        currTimePartition = tsFileResource.getTimePartition();
                        startIndex = i;
                    }
                    this.sequenceFileTreeSetMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, tsFileResourceList.size()));
                }
            }
            Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
            synchronized (map) {
                long currTimePartition = tsFileResourceList.get(0).getTimePartition();
                int startIndex = 0;
                for (int i = 1; i < tsFileResourceList.size(); ++i) {
                    TsFileResource tsFileResource = tsFileResourceList.get(i);
                    if (tsFileResource.getTimePartition() == currTimePartition) continue;
                    this.unSequenceFileListMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, i));
                    currTimePartition = tsFileResource.getTimePartition();
                    startIndex = i;
                }
                this.unSequenceFileListMap.get(currTimePartition).removeAll(tsFileResourceList.subList(startIndex, tsFileResourceList.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TsFileResource tsFileResource, boolean sequence) {
        long timePartitionId = tsFileResource.getTimePartition();
        if (sequence) {
            Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
            synchronized (map) {
                this.sequenceFileTreeSetMap.computeIfAbsent(timePartitionId, this::newSequenceTsFileResources).add(tsFileResource);
            }
        }
        Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
        synchronized (map) {
            this.unSequenceFileListMap.computeIfAbsent(timePartitionId, this::newUnSequenceTsFileResources).add(tsFileResource);
        }
    }

    @Override
    public void addRecover(TsFileResource tsFileResource, boolean sequence) {
        logger.info("{} do not need to recover", (Object)this.storageGroupName);
    }

    @Override
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            this.add(tsFileResource, sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
            synchronized (map) {
                return this.sequenceFileTreeSetMap.getOrDefault(tsFileResource.getTimePartition(), this.newSequenceTsFileResources(0L)).contains(tsFileResource);
            }
        }
        Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
        synchronized (map) {
            return ((List)this.unSequenceFileListMap.getOrDefault(tsFileResource.getTimePartition(), new ArrayList())).contains(tsFileResource);
        }
    }

    @Override
    public void clear() {
        this.sequenceFileTreeSetMap.clear();
        this.unSequenceFileListMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(boolean sequence) {
        if (sequence) {
            Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
            synchronized (map) {
                for (Set set : this.sequenceFileTreeSetMap.values()) {
                    if (set.isEmpty()) continue;
                    return false;
                }
            }
        }
        Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
        synchronized (map) {
            for (List<TsFileResource> list : this.unSequenceFileListMap.values()) {
                if (list.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(boolean sequence) {
        int result = 0;
        if (sequence) {
            Map<Long, TreeSet<TsFileResource>> map = this.sequenceFileTreeSetMap;
            synchronized (map) {
                for (Set set : this.sequenceFileTreeSetMap.values()) {
                    result += set.size();
                }
            }
        }
        Map<Long, List<TsFileResource>> map = this.unSequenceFileListMap;
        synchronized (map) {
            for (List<TsFileResource> list : this.unSequenceFileListMap.values()) {
                result += list.size();
            }
        }
        return result;
    }

    @Override
    public void recover() {
        logger.info("{} no recover logic", (Object)this.storageGroupName);
    }

    @Override
    public void forkCurrentFileList(long timePartition) {
        logger.info("{} do not need fork", (Object)this.storageGroupName);
    }

    @Override
    protected void merge(long timePartition) {
        logger.info("{} no merge logic", (Object)this.storageGroupName);
    }

    private TreeSet<TsFileResource> newSequenceTsFileResources(Long k) {
        return new TreeSet<TsFileResource>((o1, o2) -> NoCompactionTsFileManagement.compareFileName(o1.getTsFile(), o2.getTsFile()));
    }

    private List<TsFileResource> newUnSequenceTsFileResources(Long k) {
        return new ArrayList<TsFileResource>();
    }
}

