/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompactionLogAnalyzer {
    public static final String STR_DEVICE_OFFSET_SEPARATOR = " ";
    private File logFile;
    private Set<String> deviceSet = new HashSet<String>();
    private long offset = 0L;
    private List<String> sourceFiles = new ArrayList<String>();
    private String targetFile = null;
    private boolean isSeq = false;
    private boolean fullMerge = false;

    public CompactionLogAnalyzer(File logFile) {
        this.logFile = logFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void analyze() throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.logFile));){
            String currLine;
            block19: while ((currLine = bufferedReader.readLine()) != null) {
                switch (currLine) {
                    case "source": {
                        currLine = bufferedReader.readLine();
                        this.sourceFiles.add(currLine);
                        continue block19;
                    }
                    case "target": {
                        this.targetFile = currLine = bufferedReader.readLine();
                        continue block19;
                    }
                    case "full merge": {
                        this.fullMerge = true;
                        continue block19;
                    }
                    case "sequence": {
                        this.isSeq = true;
                        continue block19;
                    }
                    case "unsequence": {
                        this.isSeq = false;
                        continue block19;
                    }
                }
                int separatorIndex = currLine.lastIndexOf(STR_DEVICE_OFFSET_SEPARATOR);
                this.deviceSet.add(currLine.substring(0, separatorIndex));
                this.offset = Long.parseLong(currLine.substring(separatorIndex + 1));
            }
            return;
        }
    }

    public Set<String> getDeviceSet() {
        return this.deviceSet;
    }

    public long getOffset() {
        return this.offset;
    }

    public List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public String getTargetFile() {
        return this.targetFile;
    }

    public boolean isSeq() {
        return this.isSeq;
    }

    public boolean isFullMerge() {
        return this.fullMerge;
    }
}

