/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class LastQueryPlan
extends RawDataQueryPlan {
    public LastQueryPlan() {
        this.setOperatorType(Operator.OperatorType.LAST);
    }

    @Override
    public void setExpression(IExpression expression) throws QueryProcessException {
        if (!this.isValidExpression(expression)) {
            throw new QueryProcessException("Only '>' and '>=' are supported in LAST query");
        }
        super.setExpression(expression);
    }

    private boolean isValidExpression(IExpression expression) {
        Filter filter;
        return expression instanceof GlobalTimeExpression && ((filter = ((GlobalTimeExpression)expression).getFilter()) instanceof TimeFilter.TimeGtEq || filter instanceof TimeFilter.TimeGt);
    }
}

