/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.PathNumOverLimitException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryFileManager;
import org.apache.iotdb.db.query.control.QueryTimeManager;
import org.apache.iotdb.db.query.control.TracingManager;
import org.apache.iotdb.db.query.externalsort.serialize.IExternalSortFileDeserializer;
import org.apache.iotdb.db.query.udf.service.TemporaryQueryDataFileService;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResourceManager {
    private final AtomicLong queryIdAtom = new AtomicLong();
    private final QueryFileManager filePathsManager;
    private static final Logger logger = LoggerFactory.getLogger(QueryResourceManager.class);
    private Map<Long, Integer> chunkNumMap = new ConcurrentHashMap<Long, Integer>();
    private Map<Long, Long> chunkSizeMap = new ConcurrentHashMap<Long, Long>();
    private Map<Long, Set<TsFileResource>> seqFileNumMap = new ConcurrentHashMap<Long, Set<TsFileResource>>();
    private Map<Long, Set<TsFileResource>> unseqFileNumMap = new ConcurrentHashMap<Long, Set<TsFileResource>>();
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Map<Long, List<IExternalSortFileDeserializer>> externalSortFileMap;
    private final Map<Long, Long> queryIdEstimatedMemoryMap;
    private final AtomicLong totalFreeMemoryForRead;
    private static final long POINT_ESTIMATED_SIZE = 16L;
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    private QueryResourceManager() {
        this.filePathsManager = new QueryFileManager();
        this.externalSortFileMap = new ConcurrentHashMap<Long, List<IExternalSortFileDeserializer>>();
        this.queryIdEstimatedMemoryMap = new ConcurrentHashMap<Long, Long>();
        this.totalFreeMemoryForRead = new AtomicLong(IoTDBDescriptor.getInstance().getConfig().getAllocateMemoryForReadWithoutCache());
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public int getMaxDeduplicatedPathNum(int fetchSize) {
        if (fetchSize == 0) {
            return CONFIG.getMaxQueryDeduplicatedPathNum();
        }
        return (int)Math.min(this.totalFreeMemoryForRead.get() / (long)fetchSize / 16L, (long)CONFIG.getMaxQueryDeduplicatedPathNum());
    }

    public long assignQueryId(boolean isDataQuery, int fetchSize, int deduplicatedPathNum) {
        int maxDeduplicatedPathNum = this.getMaxDeduplicatedPathNum(fetchSize);
        if (deduplicatedPathNum > maxDeduplicatedPathNum) {
            throw new RuntimeException(new PathNumOverLimitException(maxDeduplicatedPathNum, (long)deduplicatedPathNum));
        }
        long queryId = this.queryIdAtom.incrementAndGet();
        if (isDataQuery) {
            this.filePathsManager.addQueryId(queryId);
            if (deduplicatedPathNum > 0) {
                long estimatedMemoryUsage = (long)deduplicatedPathNum * 16L * (long)fetchSize;
                if (this.totalFreeMemoryForRead.addAndGet(-estimatedMemoryUsage) >= 0L) {
                    this.queryIdEstimatedMemoryMap.put(queryId, estimatedMemoryUsage);
                } else {
                    this.totalFreeMemoryForRead.addAndGet(estimatedMemoryUsage);
                }
            }
        }
        return queryId;
    }

    public Map<Long, Integer> getChunkNumMap() {
        return this.chunkNumMap;
    }

    public Map<Long, Long> getChunkSizeMap() {
        return this.chunkSizeMap;
    }

    public void registerTempExternalSortFile(long queryId, IExternalSortFileDeserializer deserializer) {
        this.externalSortFileMap.computeIfAbsent(queryId, x -> new ArrayList()).add(deserializer);
    }

    public QueryDataSource getQueryDataSource(PartialPath selectedPath, QueryContext context, Filter filter) throws StorageEngineException, QueryProcessException {
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)selectedPath, filter);
        QueryDataSource queryDataSource = StorageEngine.getInstance().query(singleSeriesExpression, context, this.filePathsManager);
        if (this.config.isEnablePerformanceTracing()) {
            this.seqFileNumMap.computeIfAbsent(context.getQueryId(), k -> new HashSet()).addAll(queryDataSource.getSeqResources());
            this.unseqFileNumMap.computeIfAbsent(context.getQueryId(), k -> new HashSet()).addAll(queryDataSource.getUnseqResources());
        }
        return queryDataSource;
    }

    public void endQuery(long queryId) throws StorageEngineException {
        Long estimatedMemoryUsage;
        try {
            if (this.config.isEnablePerformanceTracing()) {
                boolean isprinted = false;
                if (this.seqFileNumMap.get(queryId) != null && this.unseqFileNumMap.get(queryId) != null) {
                    TracingManager.getInstance().writeTsFileInfo(queryId, this.seqFileNumMap.remove(queryId), this.unseqFileNumMap.remove(queryId));
                    isprinted = true;
                }
                if (this.chunkNumMap.get(queryId) != null && this.chunkSizeMap.get(queryId) != null) {
                    TracingManager.getInstance().writeChunksInfo(queryId, this.chunkNumMap.remove(queryId).intValue(), this.chunkSizeMap.remove(queryId));
                }
                if (isprinted) {
                    TracingManager.getInstance().writeEndTime(queryId);
                }
            }
        }
        catch (IOException e) {
            logger.error("Error while writing performance info to {}, {}", (Object)(this.config.getTracingDir() + File.separator + "tracing.txt"), (Object)e.getMessage());
        }
        if (this.externalSortFileMap.get(queryId) != null) {
            for (IExternalSortFileDeserializer deserializer : this.externalSortFileMap.get(queryId)) {
                try {
                    deserializer.close();
                }
                catch (IOException e) {
                    throw new StorageEngineException(e);
                }
            }
            this.externalSortFileMap.remove(queryId);
        }
        if ((estimatedMemoryUsage = this.queryIdEstimatedMemoryMap.remove(queryId)) != null) {
            this.totalFreeMemoryForRead.addAndGet(estimatedMemoryUsage);
        }
        this.filePathsManager.removeUsedFilesForQuery(queryId);
        TemporaryQueryDataFileService.getInstance().deregister(queryId);
        QueryTimeManager.getInstance().unRegisterQuery(queryId);
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

