/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.query.dataset.ShowDataSet;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;

public class ShowDevicesDataSet
extends ShowDataSet {
    private static final Path[] resourcePathsWithSg = new Path[]{new PartialPath("devices", false), new PartialPath("storage group", false)};
    private static final TSDataType[] resourceTypesWithSg = new TSDataType[]{TSDataType.TEXT, TSDataType.TEXT};
    private static final Path[] resourcePaths = new Path[]{new PartialPath("devices", false)};
    private static final TSDataType[] resourceTypes = new TSDataType[]{TSDataType.TEXT};
    private boolean hasSgCol;

    public ShowDevicesDataSet(ShowDevicesPlan showDevicesPlan) throws MetadataException {
        super(showDevicesPlan.hasSgCol() ? Arrays.asList(resourcePathsWithSg) : Arrays.asList(resourcePaths), showDevicesPlan.hasSgCol() ? Arrays.asList(resourceTypesWithSg) : Arrays.asList(resourceTypes));
        this.hasSgCol = showDevicesPlan.hasSgCol();
        this.plan = showDevicesPlan;
        this.hasLimit = this.plan.hasLimit();
        this.getQueryDataSet();
    }

    @Override
    public List<RowRecord> getQueryDataSet() throws MetadataException {
        List<ShowDevicesResult> devicesList = IoTDB.metaManager.getDevices((ShowDevicesPlan)this.plan);
        ArrayList<RowRecord> records = new ArrayList<RowRecord>();
        for (ShowDevicesResult result : devicesList) {
            RowRecord record = new RowRecord(0L);
            this.updateRecord(record, result.getName());
            if (this.hasSgCol) {
                this.updateRecord(record, result.getSgName());
            }
            records.add(record);
            this.putRecord(record);
        }
        return records;
    }
}

