/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class GroupByEngineDataSet
extends QueryDataSet {
    protected long queryId;
    protected long interval;
    protected long slidingStep;
    protected long startTime;
    protected long endTime;
    protected long curStartTime;
    protected long curEndTime;
    protected boolean hasCachedTimeInterval;
    protected boolean leftCRightO;
    private boolean isIntervalByMonth = false;
    private boolean isSlidingStepByMonth = false;
    protected int intervalTimes;
    private static final long MS_TO_MONTH = 2592000000L;

    public GroupByEngineDataSet() {
    }

    public GroupByEngineDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) {
        super(new ArrayList<PartialPath>(groupByTimePlan.getDeduplicatedPaths()), groupByTimePlan.getDeduplicatedDataTypes(), groupByTimePlan.isAscending());
        this.initGroupByEngineDataSetFields(context, groupByTimePlan);
    }

    protected void initGroupByEngineDataSetFields(QueryContext context, GroupByTimePlan groupByTimePlan) {
        this.queryId = context.getQueryId();
        this.interval = groupByTimePlan.getInterval();
        this.slidingStep = groupByTimePlan.getSlidingStep();
        this.startTime = groupByTimePlan.getStartTime();
        this.endTime = groupByTimePlan.getEndTime();
        this.leftCRightO = groupByTimePlan.isLeftCRightO();
        this.ascending = groupByTimePlan.isAscending();
        this.isIntervalByMonth = groupByTimePlan.isIntervalByMonth();
        this.isSlidingStepByMonth = groupByTimePlan.isSlidingStepByMonth();
        if (this.isIntervalByMonth) {
            this.interval /= 2592000000L;
        }
        if (this.ascending) {
            this.curStartTime = this.startTime;
        } else {
            long queryRange = this.endTime - this.startTime;
            long intervalNum = (long)Math.ceil((double)queryRange / (double)this.slidingStep);
            if (this.isSlidingStepByMonth) {
                this.intervalTimes = (int)intervalNum - 1;
                this.curStartTime = this.calcIntervalByMonth((long)this.intervalTimes * this.slidingStep / 2592000000L);
            } else {
                this.curStartTime = this.slidingStep * (intervalNum - 1L) + this.startTime;
            }
        }
        if (this.isSlidingStepByMonth) {
            this.slidingStep /= 2592000000L;
        }
        this.curEndTime = this.isIntervalByMonth ? Math.min(this.calcIntervalByMonth(this.interval + this.slidingStep * (long)this.intervalTimes), this.endTime) : Math.min(this.curStartTime + this.interval, this.endTime);
        this.hasCachedTimeInterval = true;
    }

    public boolean hasNextWithoutConstraint() {
        long curSlidingStep = this.slidingStep;
        long curInterval = this.interval;
        if (this.hasCachedTimeInterval) {
            return true;
        }
        this.intervalTimes += this.ascending ? 1 : -1;
        if (this.ascending) {
            this.curStartTime = this.isSlidingStepByMonth ? this.calcIntervalByMonth(this.slidingStep * (long)this.intervalTimes) : (this.curStartTime += curSlidingStep);
            if (this.curStartTime >= this.endTime) {
                return false;
            }
        } else {
            this.curStartTime = this.isSlidingStepByMonth ? this.calcIntervalByMonth(this.slidingStep * (long)this.intervalTimes) : (this.curStartTime -= curSlidingStep);
            if (this.curStartTime < this.startTime) {
                return false;
            }
        }
        this.hasCachedTimeInterval = true;
        this.curEndTime = this.isIntervalByMonth ? Math.min(this.calcIntervalByMonth((long)this.intervalTimes * this.slidingStep + this.interval), this.endTime) : Math.min(this.curStartTime + curInterval, this.endTime);
        return true;
    }

    public long calcIntervalByMonth(long numMonths) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.startTime);
        calendar.add(2, (int)numMonths);
        return calendar.getTimeInMillis();
    }

    public abstract RowRecord nextWithoutConstraint() throws IOException;

    public long getStartTime() {
        return this.startTime;
    }

    public Pair<Long, Long> nextTimePartition() {
        this.hasCachedTimeInterval = false;
        return new Pair((Object)this.curStartTime, (Object)this.curEndTime);
    }

    public abstract Pair<Long, Object> peekNextNotNullValue(Path var1, int var2) throws IOException;
}

