/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk.metadata;

import java.util.List;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.chunk.DiskChunkLoader;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.controller.IChunkMetadataLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskChunkMetadataLoader
implements IChunkMetadataLoader {
    private final TsFileResource resource;
    private final PartialPath seriesPath;
    private final QueryContext context;
    private final Filter filter;
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");

    public DiskChunkMetadataLoader(TsFileResource resource, PartialPath seriesPath, QueryContext context, Filter filter) {
        this.resource = resource;
        this.seriesPath = seriesPath;
        this.context = context;
        this.filter = filter;
    }

    public List<ChunkMetadata> loadChunkMetadataList(TimeseriesMetadata timeseriesMetadata) {
        List chunkMetadataList = timeseriesMetadata.getChunkMetadataList();
        DiskChunkMetadataLoader.setDiskChunkLoader(chunkMetadataList, this.resource, this.seriesPath, this.context);
        chunkMetadataList.removeIf(chunkMetaData -> this.filter != null && !this.filter.satisfyStartEndTime(chunkMetaData.getStartTime(), chunkMetaData.getEndTime()) || chunkMetaData.getStartTime() > chunkMetaData.getEndTime());
        for (ChunkMetadata metadata : chunkMetadataList) {
            if (metadata.isFromOldTsFile()) continue;
            metadata.setVersion(this.resource.getVersion());
        }
        if (this.context.isDebug()) {
            DEBUG_LOGGER.info("After removed by filter Chunk meta data list is: ");
            chunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
        }
        return chunkMetadataList;
    }

    public static void setDiskChunkLoader(List<ChunkMetadata> chunkMetadataList, TsFileResource resource, PartialPath seriesPath, QueryContext context) {
        List<Modification> pathModifications = context.getPathModifications(resource.getModFile(), seriesPath);
        if (context.isDebug()) {
            DEBUG_LOGGER.info("Modifications size is {} for file Path: {} ", (Object)pathModifications.size(), (Object)resource.getTsFilePath());
            pathModifications.forEach(c -> DEBUG_LOGGER.info(c.toString()));
        }
        if (!pathModifications.isEmpty()) {
            QueryUtils.modifyChunkMetaData(chunkMetadataList, pathModifications);
        }
        if (context.isDebug()) {
            DEBUG_LOGGER.info("After modification Chunk meta data list is: ");
            chunkMetadataList.forEach(c -> DEBUG_LOGGER.info(c.toString()));
        }
        chunkMetadataList.forEach(chunkMetadata -> {
            if (chunkMetadata.getChunkLoader() == null) {
                chunkMetadata.setFilePath(resource.getTsFilePath());
                chunkMetadata.setClosed(resource.isClosed());
                chunkMetadata.setChunkLoader((IChunkLoader)new DiskChunkLoader(context));
            }
        });
    }
}

