/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.StartupCheck;
import org.apache.iotdb.db.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupChecks {
    private static final Logger logger = LoggerFactory.getLogger(StartupChecks.class);
    public static final StartupCheck checkJMXPort = () -> {
        String jmxPort = System.getProperty("iotdb.jmx.port");
        if (jmxPort == null) {
            logger.warn("{} missing from {}.sh(Unix or OS X, if you use Windows, check conf/{}.bat)", new Object[]{"iotdb.jmx.port", "iotdb-env", "iotdb-env"});
        } else {
            logger.info("JMX is enabled to receive remote connection on port {}", (Object)jmxPort);
        }
    };
    public static final StartupCheck checkJDK = () -> {
        int version = CommonUtils.getJdkVersion();
        if (version < 8) {
            throw new StartupException(String.format("Requires JDK version >= %d, current version is %d", 8, version));
        }
        logger.info("JDK veriosn is {}.", (Object)version);
    };
    private final List<StartupCheck> preChecks = new ArrayList<StartupCheck>();
    private final List<StartupCheck> defaultTests = new ArrayList<StartupCheck>();

    public StartupChecks() {
        this.defaultTests.add(checkJMXPort);
        this.defaultTests.add(checkJDK);
    }

    public StartupChecks withDefaultTest() {
        this.preChecks.addAll(this.defaultTests);
        return this;
    }

    public void verify() throws StartupException {
        for (StartupCheck check : this.preChecks) {
            check.execute();
        }
    }
}

