/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.MetadataIndexEntry;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.Pair;

public class TsFileSketchTool {
    public static void main(String[] args) throws IOException {
        Pair<String, String> fileNames = TsFileSketchTool.checkArgs(args);
        String filename = (String)fileNames.left;
        String outFile = (String)fileNames.right;
        System.out.println("TsFile path:" + filename);
        System.out.println("Sketch save path:" + outFile);
        try (PrintWriter pw = new PrintWriter(new FileWriter(outFile));){
            long length = FSFactoryProducer.getFSFactory().getFile(filename).length();
            TsFileSketchTool.printlnBoth(pw, "-------------------------------- TsFile Sketch --------------------------------");
            TsFileSketchTool.printlnBoth(pw, "file path: " + filename);
            TsFileSketchTool.printlnBoth(pw, "file length: " + length);
            try (TsFileSequenceReader reader = new TsFileSequenceReader(filename);){
                TsFileMetadata tsFileMetaData = reader.readFileMetadata();
                ArrayList allChunkGroupMetadata = new ArrayList();
                reader.selfCheck(null, allChunkGroupMetadata, false);
                StringBuilder str1 = new StringBuilder();
                for (int i = 0; i < 21; ++i) {
                    str1.append("|");
                }
                TsFileSketchTool.printlnBoth(pw, "");
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "POSITION") + "|\tCONTENT");
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "--------") + " \t-------");
                TsFileSketchTool.printlnBoth(pw, String.format("%20d", 0) + "|\t[magic head] " + reader.readHeadMagic());
                TsFileSketchTool.printlnBoth(pw, String.format("%20d", "TsFile".getBytes().length) + "|\t[version number] " + reader.readVersionNumber());
                long nextChunkGroupHeaderPos = (long)"TsFile".getBytes().length + 1L;
                for (ChunkGroupMetadata chunkGroupMetadata : allChunkGroupMetadata) {
                    TsFileSketchTool.printlnBoth(pw, str1 + "\t[Chunk Group] of " + chunkGroupMetadata.getDevice() + ", num of Chunks:" + chunkGroupMetadata.getChunkMetadataList().size());
                    TsFileSketchTool.printlnBoth(pw, String.format("%20s", nextChunkGroupHeaderPos) + "|\t[Chunk Group Header]");
                    ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader(nextChunkGroupHeaderPos, false);
                    TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[marker] 0");
                    TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[deviceID] " + chunkGroupHeader.getDeviceID());
                    for (ChunkMetadata chunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                        Chunk chunk = reader.readMemChunk(chunkMetadata);
                        TsFileSketchTool.printlnBoth(pw, String.format("%20d", chunkMetadata.getOffsetOfChunkHeader()) + "|\t[Chunk] of " + chunkMetadata.getMeasurementUid() + ", numOfPoints:" + chunkMetadata.getNumOfPoints() + ", time range:[" + chunkMetadata.getStartTime() + "," + chunkMetadata.getEndTime() + "], tsDataType:" + chunkMetadata.getDataType() + ", \n" + String.format("%20s", "") + " \t" + chunkMetadata.getStatistics());
                        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[marker] " + chunk.getHeader().getChunkType());
                        nextChunkGroupHeaderPos = chunkMetadata.getOffsetOfChunkHeader() + (long)chunk.getHeader().getSerializedSize() + (long)chunk.getHeader().getDataSize() + 17L;
                    }
                    TsFileSketchTool.printlnBoth(pw, str1 + "\t[Chunk Group] of " + chunkGroupMetadata.getDevice() + " ends");
                }
                if (tsFileMetaData.getMetadataIndex().getChildren().isEmpty()) {
                    TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.getFileMetadataPos() - 1L) + "|\t[marker] 2");
                } else {
                    TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.readFileMetadata().getMetaOffset()) + "|\t[marker] 2");
                }
                Map allTimeseriesMetadata = reader.getAllTimeseriesMetadata();
                TreeMap<String, Pair> timeseriesMetadataMap = new TreeMap<String, Pair>();
                for (Map.Entry entry : allTimeseriesMetadata.entrySet()) {
                    String device = (String)entry.getKey();
                    List seriesMetadataList = (List)entry.getValue();
                    for (TimeseriesMetadata seriesMetadata : seriesMetadataList) {
                        timeseriesMetadataMap.put(seriesMetadata.getMeasurementId(), new Pair((Object)new Path(device, seriesMetadata.getMeasurementId()), (Object)seriesMetadata));
                    }
                }
                for (Map.Entry entry : timeseriesMetadataMap.entrySet()) {
                    TsFileSketchTool.printlnBoth(pw, (String)entry.getKey() + "|\t[ChunkMetadataList] of " + ((Pair)entry.getValue()).left + ", tsDataType:" + ((TimeseriesMetadata)((Pair)entry.getValue()).right).getTSDataType());
                    TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t[" + ((TimeseriesMetadata)((Pair)entry.getValue()).right).getStatistics() + "] ");
                }
                for (MetadataIndexEntry metadataIndexEntry : tsFileMetaData.getMetadataIndex().getChildren()) {
                    TsFileSketchTool.printlnBoth(pw, String.format("%20s", metadataIndexEntry.getOffset()) + "|\t[MetadataIndex] of " + metadataIndexEntry.getName());
                }
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.getFileMetadataPos()) + "|\t[TsFileMetadata]");
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[num of devices] " + tsFileMetaData.getMetadataIndex().getChildren().size());
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t" + tsFileMetaData.getMetadataIndex().getChildren().size() + " key&TsMetadataIndex");
                BloomFilter bloomFilter = tsFileMetaData.getBloomFilter();
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter bit vector byte array length] " + bloomFilter.serialize().length);
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter bit vector byte array] ");
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter number of bits] " + bloomFilter.getSize());
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter number of hash functions] " + bloomFilter.getHashFunctionSize());
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.getFileMetadataPos() + (long)reader.getFileMetadataSize()) + "|\t[TsFileMetadataSize] " + reader.getFileMetadataSize());
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.getFileMetadataPos() + (long)reader.getFileMetadataSize() + 4L) + "|\t[magic tail] " + reader.readTailMagic());
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", length) + "|\tEND of TsFile");
                TsFileSketchTool.printlnBoth(pw, "");
                TsFileSketchTool.printlnBoth(pw, "---------------------------------- TsFile Sketch End ----------------------------------");
            }
        }
    }

    private static void printlnBoth(PrintWriter pw, String str) {
        System.out.println(str);
        pw.println(str);
    }

    private static Pair<String, String> checkArgs(String[] args) {
        String filename = "test.tsfile";
        String outFile = "TsFile_sketch_view.txt";
        if (args.length == 1) {
            filename = args[0];
        } else if (args.length == 2) {
            filename = args[0];
            outFile = args[1];
        }
        return new Pair((Object)filename, (Object)outFile);
    }
}

