/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.mlog;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogParser {
    private static final Logger logger = LoggerFactory.getLogger(MLogParser.class);
    private static final String MLOG_CLI_PREFIX = "MlogParser";
    private static final String FILE_ARGS = "f";
    private static final String FILE_NAME = "mlog file";
    private static final String OUT_ARGS = "o";
    private static final String OUT_NAME = "output txt file";
    private static final String HELP_ARGS = "help";
    private static String inputFile;
    private static String outputFile;

    public static Options createOptions() {
        Options options = new Options();
        Option opFile = Option.builder((String)FILE_ARGS).required().argName(FILE_NAME).hasArg().desc("Need to specify a binary mlog file to parse (required)").build();
        options.addOption(opFile);
        Option opOut = Option.builder((String)OUT_ARGS).required(false).argName(OUT_NAME).hasArg().desc("Could specify the output file after parse (optional)").build();
        options.addOption(opOut);
        Option opHelp = Option.builder((String)HELP_ARGS).longOpt(HELP_ARGS).hasArg(false).desc("Display help information").build();
        options.addOption(opHelp);
        return options;
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Options options = MLogParser.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            logger.warn("Too few params input, please check the following hint.");
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            logger.error("Parse error: {}", (Object)e.getMessage());
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        if (commandLine.hasOption(HELP_ARGS)) {
            hf.printHelp(MLOG_CLI_PREFIX, options, true);
            return;
        }
        try {
            MLogParser.parseBasicParams(commandLine);
            MLogParser.parseFromFile(inputFile, outputFile);
        }
        catch (Exception e) {
            logger.error("Encounter an error, because: {} ", (Object)e.getMessage());
        }
    }

    public static void parseBasicParams(CommandLine commandLine) throws ParseException {
        inputFile = MLogParser.checkRequiredArg(FILE_ARGS, FILE_NAME, commandLine);
        outputFile = commandLine.getOptionValue(OUT_ARGS);
        if (outputFile == null) {
            outputFile = "tmp.txt";
        }
    }

    public static String checkRequiredArg(String arg, String name, CommandLine commandLine) throws ParseException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            String msg = String.format("Required values for option '%s' not provided", name);
            logger.info(msg);
            logger.info("Use -help for more information");
            throw new ParseException(msg);
        }
        return str;
    }

    /*
     * Exception decompiling
     */
    public static void parseFromFile(String inputFile, String outputFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[DOLOOP]], but top level block is 23[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

