/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.TsFileManagement;
import org.apache.iotdb.db.engine.merge.task.MergeCallback;
import org.apache.iotdb.db.engine.merge.task.RecoverMergeTask;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionMergeRecoverTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CompactionMergeRecoverTask.class);
    private RecoverMergeTask recoverMergeTask;
    private TsFileManagement tsFileManagement;
    private String storageGroupName;
    private StorageGroupProcessor.CloseCompactionMergeCallBack closeCompactionMergeCallBack;

    public CompactionMergeRecoverTask(TsFileManagement tsFileManagement, List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, String storageGroupSysDir, MergeCallback callback, String taskName, boolean fullMerge, String storageGroupName, StorageGroupProcessor.CloseCompactionMergeCallBack closeCompactionMergeCallBack) {
        this.tsFileManagement = tsFileManagement;
        this.storageGroupName = storageGroupName;
        this.closeCompactionMergeCallBack = closeCompactionMergeCallBack;
        this.recoverMergeTask = new RecoverMergeTask(seqFiles, unseqFiles, storageGroupSysDir, callback, taskName, fullMerge, storageGroupName);
    }

    @Override
    public void run() {
        this.tsFileManagement.recovered = false;
        try {
            this.recoverMergeTask.recoverMerge(true);
        }
        catch (IOException | MetadataException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.tsFileManagement.canMerge = false;
            logger.warn("{} [Compaction] Exception occurs while recovering merge, set can merge to false", (Object)this.storageGroupName);
        }
        this.tsFileManagement.recovered = true;
        this.closeCompactionMergeCallBack.call(false, -1L);
        logger.info("{} Compaction recover finish", (Object)this.storageGroupName);
    }
}

