/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;

public class MetaUtils {
    private MetaUtils() {
    }

    static String getNodeRegByIdx(int idx, String[] nodes) {
        return idx >= nodes.length ? "*" : nodes[idx];
    }

    public static String[] splitPathToDetachedPath(String path) throws IllegalPathException {
        ArrayList<String> nodes = new ArrayList<String>();
        int startIndex = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '.') {
                String node = path.substring(startIndex, i);
                if (node.isEmpty()) {
                    throw new IllegalPathException(path);
                }
                nodes.add(node);
                startIndex = i + 1;
                if (startIndex != path.length()) continue;
                throw new IllegalPathException(path);
            }
            if (path.charAt(i) == '\"') {
                int endIndex = path.indexOf(34, i + 1);
                while (endIndex != -1 && path.charAt(endIndex - 1) == '\\') {
                    endIndex = path.indexOf(34, endIndex + 1);
                }
                if (endIndex != -1 && (endIndex == path.length() - 1 || path.charAt(endIndex + 1) == '.')) {
                    String node = path.substring(startIndex, endIndex + 1);
                    if (node.isEmpty()) {
                        throw new IllegalPathException(path);
                    }
                    nodes.add(node);
                    i = endIndex + 1;
                    startIndex = endIndex + 2;
                    continue;
                }
                throw new IllegalPathException(path);
            }
            if (path.charAt(i) != '\'') continue;
            throw new IllegalPathException(path);
        }
        if (startIndex <= path.length() - 1) {
            String node = path.substring(startIndex);
            if (node.isEmpty()) {
                throw new IllegalPathException(path);
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }

    public static PartialPath getStorageGroupPathByLevel(PartialPath path, int level) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= level || !nodeNames[0].equals("root")) {
            throw new IllegalPathException(path.getFullPath());
        }
        String[] storageGroupNodes = new String[level + 1];
        System.arraycopy(nodeNames, 0, storageGroupNodes, 0, level + 1);
        return new PartialPath(storageGroupNodes);
    }

    public static List<String> getMultiFullPaths(MNode node) {
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList<MNode> lastNodeList = new ArrayList<MNode>();
        MetaUtils.collectLastNode(node, lastNodeList);
        ArrayList<String> result = new ArrayList<String>();
        for (MNode mNode : lastNodeList) {
            result.add(mNode.getFullPath());
        }
        return result;
    }

    public static void collectLastNode(MNode node, List<MNode> lastNodeList) {
        if (node != null) {
            Map<String, MNode> children = node.getChildren();
            if (children.isEmpty()) {
                lastNodeList.add(node);
            }
            for (Map.Entry<String, MNode> entry : children.entrySet()) {
                MNode childNode = entry.getValue();
                MetaUtils.collectLastNode(childNode, lastNodeList);
            }
        }
    }
}

