/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.monitor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.virtualSg.VirtualStorageGroupManager;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.monitor.MonitorConstants;
import org.apache.iotdb.db.monitor.StatMonitorMBean;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatMonitor
implements StatMonitorMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(StatMonitor.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final MManager mManager = IoTDB.metaManager;
    private static final StorageEngine storageEngine = StorageEngine.getInstance();
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());
    List<PartialPath> globalSeries = new ArrayList<PartialPath>(3);
    private List<Long> globalSeriesValue = new ArrayList<Long>(3);

    public StatMonitor() {
        if (config.isEnableStatMonitor()) {
            this.initMonitorSeriesInfo();
            this.recovery();
        }
    }

    public static StatMonitor getInstance() {
        return StatMonitorHolder.INSTANCE;
    }

    public void initMonitorSeriesInfo() {
        String[] globalMonitorSeries = MonitorConstants.STAT_GLOBAL_ARRAY;
        for (int i = 0; i < MonitorConstants.StatMeasurementConstants.values().length; ++i) {
            PartialPath globalMonitorPath = new PartialPath(globalMonitorSeries).concatNode(MonitorConstants.StatMeasurementConstants.values()[i].getMeasurement());
            this.globalSeries.add(globalMonitorPath);
            this.globalSeriesValue.add(0L);
        }
    }

    public void saveStatValue(String storageGroupName) throws MetadataException, StorageEngineException {
        long insertTime = System.currentTimeMillis();
        PartialPath storageGroupSeries = this.getStorageGroupMonitorSeries(storageGroupName);
        if (!mManager.isPathExist(storageGroupSeries)) {
            this.registSeriesToMManager(storageGroupSeries);
        }
        TSRecord tsRecord = new TSRecord(insertTime, storageGroupSeries.getDevice());
        tsRecord.addTuple((DataPoint)new LongDataPoint(MonitorConstants.StatMeasurementConstants.TOTAL_POINTS.getMeasurement(), storageEngine.getProcessorMap().get(new PartialPath(storageGroupName)).getMonitorSeriesValue()));
        storageEngine.insert(new InsertRowPlan(tsRecord));
        for (int i = 0; i < this.globalSeries.size(); ++i) {
            PartialPath seriesPath = this.globalSeries.get(i);
            if (!mManager.isPathExist(seriesPath)) {
                this.registSeriesToMManager(seriesPath);
            }
            tsRecord = new TSRecord(insertTime, seriesPath.getDevice());
            tsRecord.addTuple((DataPoint)new LongDataPoint(seriesPath.getMeasurement(), this.globalSeriesValue.get(i).longValue()));
            storageEngine.insert(new InsertRowPlan(tsRecord));
        }
    }

    public void recovery() {
        try {
            for (int i = 0; i < this.globalSeries.size(); ++i) {
                PartialPath globalMonitorPath = this.globalSeries.get(i);
                TimeValuePair timeValuePair = this.getLastValue(globalMonitorPath);
                if (timeValuePair == null) continue;
                this.globalSeriesValue.set(i, timeValuePair.getValue().getLong());
            }
            List<PartialPath> storageGroupPaths = mManager.getAllStorageGroupPaths();
            for (PartialPath storageGroupPath : storageGroupPaths) {
                PartialPath monitorSeriesPath;
                TimeValuePair timeValuePair;
                if (storageGroupPath.getFullPath().equals("root.stats") || (timeValuePair = this.getLastValue(monitorSeriesPath = this.getStorageGroupMonitorSeries(storageGroupPath.getFullPath()))) == null) continue;
                storageEngine.getProcessorMap().get(storageGroupPath).setMonitorSeriesValue(timeValuePair.getValue().getLong());
            }
        }
        catch (IOException | StorageEngineException | QueryProcessException e) {
            logger.error("Load last value from disk error.", (Throwable)e);
        }
    }

    private TimeValuePair getLastValue(PartialPath monitorSeries) throws StorageEngineException, QueryProcessException, IOException {
        TimeValuePair timeValuePair;
        if (mManager.isPathExist(monitorSeries) && (timeValuePair = (TimeValuePair)LastQueryExecutor.calculateLastPairForSeriesLocally(Collections.singletonList(monitorSeries), Collections.singletonList(TSDataType.INT64), (QueryContext)new QueryContext((long)QueryResourceManager.getInstance().assignQueryId((boolean)true)), null, Collections.singletonMap(monitorSeries.getDevice(), Collections.singleton(monitorSeries.getMeasurement()))).get((int)0).right).getValue() != null) {
            return timeValuePair;
        }
        return null;
    }

    private PartialPath getStorageGroupMonitorSeries(String storageGroupName) {
        String[] monitorSeries = Arrays.copyOf(MonitorConstants.STAT_STORAGE_GROUP_ARRAY, 4);
        monitorSeries[2] = "\"" + storageGroupName + "\"";
        monitorSeries[3] = MonitorConstants.StatMeasurementConstants.TOTAL_POINTS.getMeasurement();
        return new PartialPath(monitorSeries);
    }

    private void registSeriesToMManager(PartialPath fullPath) throws MetadataException {
        mManager.createTimeseries(fullPath, TSDataType.valueOf((String)"INT64"), TSEncoding.valueOf((String)"TS_2DIFF"), TSFileDescriptor.getInstance().getConfig().getCompressor(), null);
    }

    public void updateStatGlobalValue(int successPointsNum) {
        this.globalSeriesValue.set(0, this.globalSeriesValue.get(0) + (long)successPointsNum);
        if (successPointsNum != 0) {
            this.globalSeriesValue.set(1, this.globalSeriesValue.get(1) + 1L);
        }
    }

    public void updateFailedStatValue() {
        this.globalSeriesValue.set(2, this.globalSeriesValue.get(2) + 1L);
    }

    public void close() {
        config.setEnableStatMonitor(false);
        config.setEnableMonitorSeriesWrite(false);
    }

    @Override
    public long getGlobalTotalPointsNum() {
        return this.globalSeriesValue.get(0);
    }

    @Override
    public long getGlobalReqSuccessNum() {
        return this.globalSeriesValue.get(1);
    }

    @Override
    public long getGlobalReqFailNum() {
        return this.globalSeriesValue.get(2);
    }

    @Override
    public long getStorageGroupTotalPointsNum(String storageGroupName) {
        try {
            VirtualStorageGroupManager virtualStorageGroupManager = storageEngine.getProcessorMap().get(new PartialPath(storageGroupName));
            if (virtualStorageGroupManager == null) {
                return 0L;
            }
            return virtualStorageGroupManager.getMonitorSeriesValue();
        }
        catch (IllegalPathException e) {
            logger.error(e.getMessage());
            return -1L;
        }
    }

    @Override
    public String getSystemDirectory() {
        try {
            File file = SystemFileFactory.INSTANCE.getFile(config.getSystemDir());
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            logger.error("meet error while trying to get base dir.", (Throwable)e);
            return "Unavailable";
        }
    }

    @Override
    public long getDataSizeInByte() {
        try {
            long totalSize = 0L;
            for (String dataDir : config.getDataDirs()) {
                totalSize += FileUtils.sizeOfDirectory((File)SystemFileFactory.INSTANCE.getFile(dataDir));
            }
            return totalSize;
        }
        catch (Exception e) {
            logger.error("meet error while trying to get data size.", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public boolean getWriteAheadLogStatus() {
        return config.isEnableWal();
    }

    @Override
    public boolean getEnableStatMonitor() {
        return config.isEnableStatMonitor();
    }

    @Override
    public void start() throws StartupException {
        try {
            JMXService.registerMBean(StatMonitor.getInstance(), this.mbeanName);
        }
        catch (Exception e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public ServiceType getID() {
        return ServiceType.MONITOR_SERVICE;
    }

    private static class StatMonitorHolder {
        private static final StatMonitor INSTANCE = new StatMonitor();

        private StatMonitorHolder() {
        }
    }
}

