/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.GroupByLevelController;
import org.apache.iotdb.db.query.udf.core.context.UDFContext;

public final class SelectOperator
extends Operator {
    private final ZoneId zoneId;
    private List<PartialPath> suffixList;
    private List<String> aggregations;
    private List<UDFContext> udfList;
    private boolean lastQuery;
    private boolean udfQuery;
    private boolean hasBuiltinAggregation;
    private GroupByLevelController groupByLevelController;
    private boolean isCountStar;
    private int[] levels;

    public SelectOperator(int tokenIntType, ZoneId zoneId) {
        super(tokenIntType);
        this.zoneId = zoneId;
        this.operatorType = Operator.OperatorType.SELECT;
        this.suffixList = new ArrayList<PartialPath>();
        this.aggregations = new ArrayList<String>();
        this.udfList = new ArrayList<UDFContext>();
        this.lastQuery = false;
        this.udfQuery = false;
        this.hasBuiltinAggregation = false;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void addSelectPath(PartialPath suffixPath) {
        this.suffixList.add(suffixPath);
    }

    public void addClusterPath(PartialPath suffixPath, String aggregation) {
        this.suffixList.add(suffixPath);
        this.aggregations.add(aggregation);
        if (aggregation != null) {
            this.hasBuiltinAggregation = true;
        }
    }

    public boolean isLastQuery() {
        return this.lastQuery;
    }

    public void setLastQuery() {
        this.lastQuery = true;
    }

    public List<String> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<String> aggregations) {
        this.aggregations = aggregations;
    }

    public boolean hasAggregation() {
        return this.hasBuiltinAggregation;
    }

    public void setSuffixPathList(List<PartialPath> suffixPaths) {
        this.suffixList = suffixPaths;
    }

    public List<PartialPath> getSuffixPaths() {
        return this.suffixList;
    }

    public void addUdf(UDFContext udf) {
        if (udf != null) {
            this.udfQuery = true;
        }
        this.udfList.add(udf);
    }

    public List<UDFContext> getUdfList() {
        return this.udfList;
    }

    public boolean isUdfQuery() {
        return this.udfQuery;
    }

    public void setUdfList(List<UDFContext> udfList) {
        this.udfList = udfList;
    }

    public boolean isCountStar() {
        return this.isCountStar;
    }

    public void checkCountStar() {
        if (this.hasAggregation() && this.getAggregations().size() == 1 && this.getAggregations().get(0).equals("count") && this.getSuffixPaths().size() == 1 && this.getSuffixPaths().get(0).equals("*")) {
            this.isCountStar = true;
        }
    }

    public int[] getLevels() {
        return this.levels;
    }

    public void setLevels(int[] levels) {
        this.levels = levels;
    }

    public boolean isGroupByLevel() {
        return this.levels != null && this.levels.length != 0;
    }

    public GroupByLevelController getGroupByLevelController() {
        return this.groupByLevelController;
    }

    public void setGroupByLevelController(GroupByLevelController groupByLevelController) {
        this.groupByLevelController = groupByLevelController;
    }
}

