/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.sql;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.api.TriggerEvent;
import org.apache.iotdb.db.exception.index.UnsupportedIndexTypeException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.index.common.IndexUtils;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.LikeOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.RegexpOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.logical.sys.AlterTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.ClearCacheOperator;
import org.apache.iotdb.db.qp.logical.sys.CountOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateIndexOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateSnapshotOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeletePartitionOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DropFunctionOperator;
import org.apache.iotdb.db.qp.logical.sys.DropIndexOperator;
import org.apache.iotdb.db.qp.logical.sys.DropTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.FlushOperator;
import org.apache.iotdb.db.qp.logical.sys.KillQueryOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadConfigurationOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadFilesOperator;
import org.apache.iotdb.db.qp.logical.sys.MergeOperator;
import org.apache.iotdb.db.qp.logical.sys.MoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.RemoveFileOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetSystemModeOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildNodesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowChildPathsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowDevicesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowFunctionsOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowLockInfoOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowMergeStatusOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTriggersOperator;
import org.apache.iotdb.db.qp.logical.sys.StartTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.StopTriggerOperator;
import org.apache.iotdb.db.qp.logical.sys.TracingOperator;
import org.apache.iotdb.db.qp.sql.SqlBaseBaseVisitor;
import org.apache.iotdb.db.qp.sql.SqlBaseParser;
import org.apache.iotdb.db.qp.utils.DatetimeUtils;
import org.apache.iotdb.db.query.executor.fill.IFill;
import org.apache.iotdb.db.query.executor.fill.LinearFill;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.executor.fill.ValueFill;
import org.apache.iotdb.db.query.udf.core.context.UDFContext;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class IoTDBSqlVisitor
extends SqlBaseBaseVisitor<Operator> {
    private static final String DELETE_RANGE_ERROR_MSG = "For delete statement, where clause can only contain atomic expressions like : time > XXX, time <= XXX, or two atomic expressions connected by 'AND'";
    private static final String DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG = "For delete statement, where clause can only contain time expressions, value filter is not currently supported.";
    private ZoneId zoneId;
    QueryOperator queryOp;

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public Operator visitSingleStatement(SqlBaseParser.SingleStatementContext ctx) {
        Operator operator = (Operator)this.visit((ParseTree)ctx.statement());
        if (ctx.DEBUG() != null) {
            operator.setDebug(true);
        }
        return operator;
    }

    public Operator visitCreateTimeseries(SqlBaseParser.CreateTimeseriesContext ctx) {
        CreateTimeSeriesOperator createTimeSeriesOperator = new CreateTimeSeriesOperator(51);
        createTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        if (ctx.alias() != null) {
            createTimeSeriesOperator.setAlias(ctx.alias().ID().getText());
        }
        if (ctx.attributeClauses() != null) {
            this.parseAttributeClauses(ctx.attributeClauses(), createTimeSeriesOperator);
        }
        return createTimeSeriesOperator;
    }

    public Operator visitDeleteTimeseries(SqlBaseParser.DeleteTimeseriesContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteTimeSeriesOperator deleteTimeSeriesOperator = new DeleteTimeSeriesOperator(52);
        deleteTimeSeriesOperator.setDeletePathList(deletePaths);
        return deleteTimeSeriesOperator;
    }

    public Operator visitAlterTimeseries(SqlBaseParser.AlterTimeseriesContext ctx) {
        AlterTimeSeriesOperator alterTimeSeriesOperator = new AlterTimeSeriesOperator(80);
        alterTimeSeriesOperator.setPath(this.parseFullPath(ctx.fullPath()));
        this.parseAlterClause(ctx.alterClause(), alterTimeSeriesOperator);
        return alterTimeSeriesOperator;
    }

    public Operator visitInsertStatement(SqlBaseParser.InsertStatementContext ctx) {
        InsertOperator insertOp = new InsertOperator(24);
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        selectOp.addSelectPath(this.parsePrefixPath(ctx.prefixPath()));
        insertOp.setSelectOperator(selectOp);
        this.parseInsertColumnSpec(ctx.insertColumnsSpec(), insertOp);
        this.parseInsertValuesSpec(ctx.insertValuesSpec(), insertOp);
        return insertOp;
    }

    public Operator visitDeleteStatement(SqlBaseParser.DeleteStatementContext ctx) {
        DeleteDataOperator deleteDataOp = new DeleteDataOperator(25);
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        List prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            PartialPath path = this.parsePrefixPath(prefixPath);
            selectOp.addSelectPath(path);
        }
        deleteDataOp.setSelectOperator(selectOp);
        if (ctx.whereClause() != null) {
            FilterOperator whereOp = (FilterOperator)this.visit((ParseTree)ctx.whereClause());
            deleteDataOp.setFilterOperator(whereOp.getChildren().get(0));
            Pair<Long, Long> timeInterval = this.parseDeleteTimeInterval(deleteDataOp);
            deleteDataOp.setStartTime((Long)timeInterval.left);
            deleteDataOp.setEndTime((Long)timeInterval.right);
        } else {
            deleteDataOp.setStartTime(Long.MIN_VALUE);
            deleteDataOp.setEndTime(Long.MAX_VALUE);
        }
        return deleteDataOp;
    }

    public Operator visitSetStorageGroup(SqlBaseParser.SetStorageGroupContext ctx) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupOperator.setPath(path);
        return setStorageGroupOperator;
    }

    public Operator visitDeleteStorageGroup(SqlBaseParser.DeleteStorageGroupContext ctx) {
        ArrayList<PartialPath> deletePaths = new ArrayList<PartialPath>();
        List prefixPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            deletePaths.add(this.parsePrefixPath(prefixPath));
        }
        DeleteStorageGroupOperator deleteStorageGroupOperator = new DeleteStorageGroupOperator(62);
        deleteStorageGroupOperator.setDeletePathList(deletePaths);
        return deleteStorageGroupOperator;
    }

    public Operator visitCreateIndex(SqlBaseParser.CreateIndexContext ctx) {
        CreateIndexOperator createIndexOp = new CreateIndexOperator(31);
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        List<SqlBaseParser.PrefixPathContext> prefixPaths = Collections.singletonList(ctx.prefixPath());
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            PartialPath path = this.parsePrefixPath(prefixPath);
            selectOp.addSelectPath(path);
        }
        createIndexOp.setSelectOperator(selectOp);
        this.parseIndexWithClause(ctx.indexWithClause(), createIndexOp);
        if (ctx.whereClause() != null) {
            FilterOperator whereOp = (FilterOperator)this.visit((ParseTree)ctx.whereClause());
            createIndexOp.setFilterOperator(whereOp.getChildren().get(0));
            long indexTime = this.parseCreateIndexFilter(createIndexOp);
            createIndexOp.setTime(indexTime);
        }
        return createIndexOp;
    }

    private long parseCreateIndexFilter(CreateIndexOperator operator) {
        FilterOperator filterOperator = operator.getFilterOperator();
        if (filterOperator.getTokenIntType() != 162 && filterOperator.getTokenIntType() != 163) {
            throw new SQLParserException("For create index command, where clause must be like : time > XXX or time >= XXX");
        }
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        if (filterOperator.getTokenIntType() == 164) {
            --time;
        }
        return time;
    }

    public void parseIndexWithClause(SqlBaseParser.IndexWithClauseContext ctx, CreateIndexOperator createIndexOp) {
        IndexType indexType;
        try {
            indexType = IndexType.getIndexType(ctx.indexName.getText());
        }
        catch (UnsupportedIndexTypeException e) {
            throw new SQLParserException(ctx.indexName.getText());
        }
        List properties = ctx.property();
        HashMap<String, String> props = new HashMap<String, String>(properties.size(), 1.0f);
        if (ctx.property(0) != null) {
            for (SqlBaseParser.PropertyContext property : properties) {
                String k = property.ID().getText().toUpperCase();
                String v = property.propertyValue().getText().toUpperCase();
                v = IndexUtils.removeQuotation(v);
                props.put(k, v);
            }
        }
        createIndexOp.setIndexType(indexType);
        createIndexOp.setProps(props);
    }

    public Operator visitDropIndex(SqlBaseParser.DropIndexContext ctx) {
        DropIndexOperator dropIndexOperator = new DropIndexOperator(32);
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        List<SqlBaseParser.PrefixPathContext> prefixPaths = Collections.singletonList(ctx.prefixPath());
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPaths) {
            PartialPath path = this.parsePrefixPath(prefixPath);
            selectOp.addSelectPath(path);
        }
        dropIndexOperator.setSelectOperator(selectOp);
        try {
            dropIndexOperator.setIndexType(IndexType.getIndexType(ctx.indexName.getText()));
        }
        catch (UnsupportedIndexTypeException e) {
            throw new SQLParserException(ctx.indexName.getText());
        }
        return dropIndexOperator;
    }

    public Operator visitCreateFunction(SqlBaseParser.CreateFunctionContext ctx) {
        CreateFunctionOperator createFunctionOperator = new CreateFunctionOperator(92);
        createFunctionOperator.setTemporary(ctx.TEMPORARY() != null);
        createFunctionOperator.setUdfName(ctx.udfName.getText());
        createFunctionOperator.setClassName(this.removeStringQuote(ctx.className.getText()));
        return createFunctionOperator;
    }

    public Operator visitDropFunction(SqlBaseParser.DropFunctionContext ctx) {
        DropFunctionOperator dropFunctionOperator = new DropFunctionOperator(93);
        dropFunctionOperator.setUdfName(ctx.udfName.getText());
        return dropFunctionOperator;
    }

    public Operator visitShowFunctions(SqlBaseParser.ShowFunctionsContext ctx) {
        ShowFunctionsOperator showFunctionsOperator = new ShowFunctionsOperator(94);
        showFunctionsOperator.setShowTemporary(ctx.TEMPORARY() != null);
        return showFunctionsOperator;
    }

    public Operator visitCreateTrigger(SqlBaseParser.CreateTriggerContext ctx) {
        CreateTriggerOperator createTriggerOperator = new CreateTriggerOperator(100);
        createTriggerOperator.setTriggerName(ctx.triggerName.getText());
        createTriggerOperator.setEvent(ctx.triggerEventClause().BEFORE() != null ? TriggerEvent.BEFORE_INSERT : TriggerEvent.AFTER_INSERT);
        createTriggerOperator.setFullPath(this.parseFullPath(ctx.fullPath()));
        createTriggerOperator.setClassName(this.removeStringQuote(ctx.className.getText()));
        if (ctx.triggerAttributeClause() != null) {
            for (SqlBaseParser.TriggerAttributeContext triggerAttributeContext : ctx.triggerAttributeClause().triggerAttribute()) {
                createTriggerOperator.addAttribute(this.removeStringQuote(triggerAttributeContext.key.getText()), this.removeStringQuote(triggerAttributeContext.value.getText()));
            }
        }
        return createTriggerOperator;
    }

    public Operator visitDropTrigger(SqlBaseParser.DropTriggerContext ctx) {
        DropTriggerOperator dropTriggerOperator = new DropTriggerOperator(101);
        dropTriggerOperator.setTriggerName(ctx.triggerName.getText());
        return dropTriggerOperator;
    }

    public Operator visitStartTrigger(SqlBaseParser.StartTriggerContext ctx) {
        StartTriggerOperator startTriggerOperator = new StartTriggerOperator(102);
        startTriggerOperator.setTriggerName(ctx.triggerName.getText());
        return startTriggerOperator;
    }

    public Operator visitStopTrigger(SqlBaseParser.StopTriggerContext ctx) {
        StopTriggerOperator stopTriggerOperator = new StopTriggerOperator(103);
        stopTriggerOperator.setTriggerName(ctx.triggerName.getText());
        return stopTriggerOperator;
    }

    public Operator visitShowTriggers(SqlBaseParser.ShowTriggersContext ctx) {
        ShowTriggersOperator showTriggersOperator = new ShowTriggersOperator(104);
        if (ctx.fullPath() != null) {
            showTriggersOperator.setPath(this.parseFullPath(ctx.fullPath()));
        }
        return showTriggersOperator;
    }

    public Operator visitMerge(SqlBaseParser.MergeContext ctx) {
        return new MergeOperator(82);
    }

    public Operator visitFlush(SqlBaseParser.FlushContext ctx) {
        FlushOperator flushOperator = new FlushOperator(81);
        if (ctx.booleanClause() != null) {
            flushOperator.setSeq(Boolean.parseBoolean(ctx.booleanClause().getText()));
        }
        if (ctx.prefixPath(0) != null) {
            ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
            for (SqlBaseParser.PrefixPathContext prefixPathContext : ctx.prefixPath()) {
                storageGroups.add(this.parsePrefixPath(prefixPathContext));
            }
            flushOperator.setStorageGroupList(storageGroups);
        }
        return flushOperator;
    }

    public Operator visitFullMerge(SqlBaseParser.FullMergeContext ctx) {
        return new MergeOperator(83);
    }

    public Operator visitClearcache(SqlBaseParser.ClearcacheContext ctx) {
        return new ClearCacheOperator(84);
    }

    public Operator visitCreateUser(SqlBaseParser.CreateUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPassWord(this.removeStringQuote(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitAlterUser(SqlBaseParser.AlterUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(46, AuthorOperator.AuthorType.UPDATE_USER);
        if (ctx.ID() != null) {
            authorOperator.setUserName(ctx.ID().getText());
        } else {
            authorOperator.setUserName(ctx.ROOT().getText());
        }
        authorOperator.setNewPassword(this.removeStringQuote(ctx.password.getText()));
        return authorOperator;
    }

    public Operator visitDropUser(SqlBaseParser.DropUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_USER);
        authorOperator.setUserName(ctx.ID().getText());
        return authorOperator;
    }

    public Operator visitCreateRole(SqlBaseParser.CreateRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        return authorOperator;
    }

    public Operator visitDropRole(SqlBaseParser.DropRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        return authorOperator;
    }

    public Operator visitGrantUser(SqlBaseParser.GrantUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitGrantRole(SqlBaseParser.GrantRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitRevokeUser(SqlBaseParser.RevokeUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_USER);
        authorOperator.setUserName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitRevokeRole(SqlBaseParser.RevokeRoleContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE);
        authorOperator.setRoleName(ctx.ID().getText());
        authorOperator.setPrivilegeList(this.parsePrivilege(ctx.privileges()));
        authorOperator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return authorOperator;
    }

    public Operator visitGrantRoleToUser(SqlBaseParser.GrantRoleToUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE_TO_USER);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        return authorOperator;
    }

    public Operator visitRevokeRoleFromUser(SqlBaseParser.RevokeRoleFromUserContext ctx) {
        AuthorOperator authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.REVOKE_ROLE_FROM_USER);
        authorOperator.setRoleName(ctx.roleName.getText());
        authorOperator.setUserName(ctx.userName.getText());
        return authorOperator;
    }

    public Operator visitLoadStatement(SqlBaseParser.LoadStatementContext ctx) {
        if (ctx.prefixPath().nodeName().size() < 3) {
            throw new SQLParserException("data load command: child count < 3\n");
        }
        String csvPath = ctx.stringLiteral().getText();
        StringContainer sc = new StringContainer(".");
        List nodeNames = ctx.prefixPath().nodeName();
        sc.addTail(new String[]{ctx.prefixPath().ROOT().getText()});
        for (SqlBaseParser.NodeNameContext nodeName : nodeNames) {
            sc.addTail(new String[]{nodeName.getText()});
        }
        return new LoadDataOperator(45, this.removeStringQuote(csvPath), sc.toString());
    }

    public Operator visitGrantWatermarkEmbedding(SqlBaseParser.GrantWatermarkEmbeddingContext ctx) {
        List rootOrIdList = ctx.rootOrId();
        ArrayList<String> users = new ArrayList<String>();
        for (SqlBaseParser.RootOrIdContext rootOrId : rootOrIdList) {
            users.add(rootOrId.getText());
        }
        return new DataAuthOperator(34, users);
    }

    public Operator visitRevokeWatermarkEmbedding(SqlBaseParser.RevokeWatermarkEmbeddingContext ctx) {
        List rootOrIdList = ctx.rootOrId();
        ArrayList<String> users = new ArrayList<String>();
        for (SqlBaseParser.RootOrIdContext rootOrId : rootOrIdList) {
            users.add(rootOrId.getText());
        }
        return new DataAuthOperator(35, users);
    }

    public Operator visitListUser(SqlBaseParser.ListUserContext ctx) {
        return new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER);
    }

    public Operator visitListRole(SqlBaseParser.ListRoleContext ctx) {
        return new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE);
    }

    public Operator visitListPrivilegesUser(SqlBaseParser.ListPrivilegesUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.rootOrId().getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitListPrivilegesRole(SqlBaseParser.ListPrivilegesRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.ID().getText());
        operator.setNodeNameList(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitListUserPrivileges(SqlBaseParser.ListUserPrivilegesContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
        operator.setUserName(ctx.rootOrId().getText());
        return operator;
    }

    public Operator visitListRolePrivileges(SqlBaseParser.ListRolePrivilegesContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
        operator.setRoleName(ctx.ID().getText());
        return operator;
    }

    public Operator visitListAllRoleOfUser(SqlBaseParser.ListAllRoleOfUserContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_ROLES);
        operator.setUserName(ctx.rootOrId().getText());
        return operator;
    }

    public Operator visitListAllUserOfRole(SqlBaseParser.ListAllUserOfRoleContext ctx) {
        AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_USERS);
        operator.setRoleName(ctx.ID().getText());
        return operator;
    }

    public Operator visitSetTTLStatement(SqlBaseParser.SetTTLStatementContext ctx) {
        SetTTLOperator operator = new SetTTLOperator(63);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        operator.setDataTTL(Long.parseLong(ctx.INT().getText()));
        return operator;
    }

    public Operator visitUnsetTTLStatement(SqlBaseParser.UnsetTTLStatementContext ctx) {
        SetTTLOperator operator = new SetTTLOperator(64);
        operator.setStorageGroup(this.parsePrefixPath(ctx.prefixPath()));
        return operator;
    }

    public Operator visitShowTTLStatement(SqlBaseParser.ShowTTLStatementContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        List prefixPathList = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixPath : prefixPathList) {
            storageGroups.add(this.parsePrefixPath(prefixPath));
        }
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowAllTTLStatement(SqlBaseParser.ShowAllTTLStatementContext ctx) {
        ArrayList<PartialPath> storageGroups = new ArrayList<PartialPath>();
        return new ShowTTLOperator(storageGroups);
    }

    public Operator visitShowFlushTaskInfo(SqlBaseParser.ShowFlushTaskInfoContext ctx) {
        return new ShowOperator(67);
    }

    public Operator visitShowVersion(SqlBaseParser.ShowVersionContext ctx) {
        return new ShowOperator(72);
    }

    public Operator visitShowTimeseries(SqlBaseParser.ShowTimeseriesContext ctx) {
        boolean orderByHeat = ctx.LATEST() != null;
        ShowTimeSeriesOperator showTimeSeriesOperator = ctx.prefixPath() != null ? new ShowTimeSeriesOperator(73, this.parsePrefixPath(ctx.prefixPath()), orderByHeat) : new ShowTimeSeriesOperator(73, new PartialPath(SQLConstant.getSingleRootArray()), orderByHeat);
        if (ctx.showWhereClause() != null) {
            this.parseShowWhereClause(ctx.showWhereClause(), showTimeSeriesOperator);
        }
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showTimeSeriesOperator);
        }
        return showTimeSeriesOperator;
    }

    public Operator visitShowQueryProcesslist(SqlBaseParser.ShowQueryProcesslistContext ctx) {
        return new ShowOperator(97);
    }

    public Operator visitKillQuery(SqlBaseParser.KillQueryContext ctx) {
        KillQueryOperator killQueryOperator = new KillQueryOperator(98);
        if (ctx.INT() != null) {
            killQueryOperator.setQueryId(Integer.parseInt(ctx.INT().getText()));
        }
        return killQueryOperator;
    }

    public Operator visitShowStorageGroup(SqlBaseParser.ShowStorageGroupContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowStorageGroupOperator(74, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowStorageGroupOperator(74, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowLockInfo(SqlBaseParser.ShowLockInfoContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowLockInfoOperator(105, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowLockInfoOperator(105, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowChildPaths(SqlBaseParser.ShowChildPathsContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildPathsOperator(75, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildPathsOperator(75, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowChildNodes(SqlBaseParser.ShowChildNodesContext ctx) {
        if (ctx.prefixPath() != null) {
            return new ShowChildNodesOperator(99, this.parsePrefixPath(ctx.prefixPath()));
        }
        return new ShowChildNodesOperator(99, new PartialPath(SQLConstant.getSingleRootArray()));
    }

    public Operator visitShowDevices(SqlBaseParser.ShowDevicesContext ctx) {
        ShowDevicesOperator showDevicesOperator = ctx.prefixPath() != null ? new ShowDevicesOperator(76, this.parsePrefixPath(ctx.prefixPath())) : new ShowDevicesOperator(76, new PartialPath(SQLConstant.getSingleRootArray()));
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), showDevicesOperator);
        }
        if (ctx.WITH() != null) {
            showDevicesOperator.setSgCol(true);
        }
        return showDevicesOperator;
    }

    public Operator visitShowMergeStatus(SqlBaseParser.ShowMergeStatusContext ctx) {
        return new ShowMergeStatusOperator(87);
    }

    public Operator visitTracingOn(SqlBaseParser.TracingOnContext ctx) {
        return new TracingOperator(91, true);
    }

    public Operator visitTracingOff(SqlBaseParser.TracingOffContext ctx) {
        return new TracingOperator(91, false);
    }

    public Operator visitSetSystemToReadOnly(SqlBaseParser.SetSystemToReadOnlyContext ctx) {
        return new SetSystemModeOperator(106, true);
    }

    public Operator visitSetSystemToWritable(SqlBaseParser.SetSystemToWritableContext ctx) {
        return new SetSystemModeOperator(106, false);
    }

    public Operator visitCountTimeseries(SqlBaseParser.CountTimeseriesContext ctx) {
        PartialPath path;
        SqlBaseParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath partialPath = path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        if (ctx.INT() != null) {
            return new CountOperator(78, path, Integer.parseInt(ctx.INT().getText()));
        }
        return new CountOperator(77, path);
    }

    public Operator visitCountDevices(SqlBaseParser.CountDevicesContext ctx) {
        SqlBaseParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(95, path);
    }

    public Operator visitCountStorageGroup(SqlBaseParser.CountStorageGroupContext ctx) {
        SqlBaseParser.PrefixPathContext pathContext = ctx.prefixPath();
        PartialPath path = pathContext != null ? this.parsePrefixPath(pathContext) : new PartialPath(SQLConstant.getSingleRootArray());
        return new CountOperator(96, path);
    }

    public Operator visitCountNodes(SqlBaseParser.CountNodesContext ctx) {
        return new CountOperator(79, this.parsePrefixPath(ctx.prefixPath()), Integer.parseInt(ctx.INT().getText()));
    }

    public Operator visitLoadConfigurationStatement(SqlBaseParser.LoadConfigurationStatementContext ctx) {
        if (ctx.GLOBAL() != null) {
            return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.GLOBAL);
        }
        return new LoadConfigurationOperator(LoadConfigurationOperator.LoadConfigurationOperatorType.LOCAL);
    }

    public Operator visitLoadFiles(SqlBaseParser.LoadFilesContext ctx) {
        LoadFilesOperator loadFilesOperator = new LoadFilesOperator(new File(this.removeStringQuote(ctx.stringLiteral().getText())), true, IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel(), true);
        if (ctx.loadFilesClause() != null) {
            this.parseLoadFiles(loadFilesOperator, ctx.loadFilesClause());
        }
        return loadFilesOperator;
    }

    public Operator visitRemoveFile(SqlBaseParser.RemoveFileContext ctx) {
        return new RemoveFileOperator(new File(this.removeStringQuote(ctx.stringLiteral().getText())));
    }

    public Operator visitMoveFile(SqlBaseParser.MoveFileContext ctx) {
        return new MoveFileOperator(new File(this.removeStringQuote(ctx.stringLiteral(0).getText())), new File(this.removeStringQuote(ctx.stringLiteral(1).getText())));
    }

    public Operator visitDeletePartition(SqlBaseParser.DeletePartitionContext ctx) {
        DeletePartitionOperator deletePartitionOperator = new DeletePartitionOperator(88);
        deletePartitionOperator.setStorageGroupName(this.parsePrefixPath(ctx.prefixPath()));
        HashSet<Long> idSet = new HashSet<Long>();
        for (TerminalNode terminalNode : ctx.INT()) {
            idSet.add(Long.parseLong(terminalNode.getText()));
        }
        deletePartitionOperator.setPartitionIds(idSet);
        return deletePartitionOperator;
    }

    public Operator visitCreateSnapshot(SqlBaseParser.CreateSnapshotContext ctx) {
        return new CreateSnapshotOperator(89);
    }

    public Operator visitSelectStatement(SqlBaseParser.SelectStatementContext ctx) {
        Operator operator;
        this.queryOp = new QueryOperator(27);
        SelectOperator selectOp = (SelectOperator)this.visit((ParseTree)ctx.selectElements());
        this.queryOp.setSelectOperator(selectOp);
        FromOperator fromOp = (FromOperator)this.visit((ParseTree)ctx.fromClause());
        this.queryOp.setFromOperator(fromOp);
        if (ctx.topClause() != null) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            int top = Integer.parseInt(ctx.topClause().INT().getText());
            if (top < 0) {
                throw new SQLParserException("TOP <N>: N should be greater than 0.");
            }
            props.put("TOP_K", top);
            this.queryOp.setProps(props);
        }
        if (ctx.whereClause() != null && (operator = (Operator)this.visit((ParseTree)ctx.whereClause())) instanceof FilterOperator) {
            FilterOperator whereOp = (FilterOperator)operator;
            this.queryOp.setFilterOperator(whereOp.getChildren().get(0));
        }
        if (ctx.specialClause() != null) {
            this.visit((ParseTree)ctx.specialClause());
        }
        return this.queryOp;
    }

    public Operator visitAggregationElement(SqlBaseParser.AggregationElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        for (SqlBaseParser.AggregationCallContext aggregationCallContext : ctx.aggregationCall()) {
            SqlBaseParser.BuiltInFunctionCallContext builtInFunctionCallContext = aggregationCallContext.builtInFunctionCall();
            SqlBaseParser.UdfCallContext udfCallContext = aggregationCallContext.udfCall();
            if (builtInFunctionCallContext != null) {
                selectOp.addClusterPath(this.parseSuffixPath(builtInFunctionCallContext.suffixPath()), builtInFunctionCallContext.functionName().getText());
                selectOp.addUdf(null);
                continue;
            }
            if (udfCallContext == null) continue;
            selectOp.addClusterPath(null, null);
            this.parseUdfCall(udfCallContext, selectOp);
        }
        return selectOp;
    }

    public void parseUdfCall(SqlBaseParser.UdfCallContext udfCall, SelectOperator selectOp) {
        String udfName = udfCall.udfName.getText();
        UDFContext udf = new UDFContext(udfName);
        for (SqlBaseParser.SuffixPathContext suffixPathContext : udfCall.udfSuffixPaths().suffixPath()) {
            udf.addPath(this.parseSuffixPath(suffixPathContext));
        }
        for (SqlBaseParser.UdfAttributeContext udfAttributeContext : udfCall.udfAttribute()) {
            udf.addAttribute(this.removeStringQuote(udfAttributeContext.udfAttributeKey.getText()), this.removeStringQuote(udfAttributeContext.udfAttributeValue.getText()));
        }
        selectOp.addUdf(udf);
    }

    public Operator visitLastElement(SqlBaseParser.LastElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        selectOp.setLastQuery();
        SqlBaseParser.LastClauseContext lastClauseContext = ctx.lastClause();
        if (lastClauseContext.asClause().size() != 0) {
            this.parseAsClause(lastClauseContext.asClause(), selectOp);
        } else {
            List suffixPaths = lastClauseContext.suffixPath();
            for (SqlBaseParser.SuffixPathContext suffixPath : suffixPaths) {
                PartialPath path = this.parseSuffixPath(suffixPath);
                selectOp.addSelectPath(path);
            }
        }
        return selectOp;
    }

    public Operator visitAsElement(SqlBaseParser.AsElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        this.parseAsClause(ctx.asClause(), selectOp);
        return selectOp;
    }

    public Operator visitFunctionAsElement(SqlBaseParser.FunctionAsElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        List functionAsClauseContexts = ctx.functionAsClause();
        for (SqlBaseParser.FunctionAsClauseContext functionAsClauseContext : functionAsClauseContexts) {
            SqlBaseParser.BuiltInFunctionCallContext functionCallContext = functionAsClauseContext.builtInFunctionCall();
            PartialPath path = this.parseSuffixPath(functionCallContext.suffixPath());
            if (functionAsClauseContext.ID() != null) {
                path.setTsAlias(functionAsClauseContext.ID().toString());
            }
            selectOp.addClusterPath(path, functionCallContext.functionName().getText());
        }
        return selectOp;
    }

    public Operator visitCreateStorageGroup(SqlBaseParser.CreateStorageGroupContext ctx) {
        SetStorageGroupOperator setStorageGroupOperator = new SetStorageGroupOperator(53);
        PartialPath path = this.parsePrefixPath(ctx.prefixPath());
        setStorageGroupOperator.setPath(path);
        return setStorageGroupOperator;
    }

    public void parseAsClause(List<SqlBaseParser.AsClauseContext> asClauseContexts, SelectOperator selectOp) {
        for (SqlBaseParser.AsClauseContext asClauseContext : asClauseContexts) {
            PartialPath path = this.parseSuffixPath(asClauseContext.suffixPath());
            if (asClauseContext.ID() != null) {
                path.setTsAlias(asClauseContext.ID().toString());
            }
            selectOp.addSelectPath(path);
        }
    }

    public Operator visitSpecialLimitStatement(SqlBaseParser.SpecialLimitStatementContext ctx) {
        return (Operator)this.visit((ParseTree)ctx.specialLimit());
    }

    public Operator visitLimitStatement(SqlBaseParser.LimitStatementContext ctx) {
        this.parseLimitClause(ctx.limitClause(), this.queryOp);
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitSlimitStatement(SqlBaseParser.SlimitStatementContext ctx) {
        this.parseSlimitClause(ctx.slimitClause(), this.queryOp);
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitAlignByDeviceClauseOrDisableAlignStatement(SqlBaseParser.AlignByDeviceClauseOrDisableAlignStatementContext ctx) {
        this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        return this.queryOp;
    }

    private void parseAlignByDeviceClauseOrDisableAlign(SqlBaseParser.AlignByDeviceClauseOrDisableAlignContext ctx) {
        if (ctx.alignByDeviceClause() != null) {
            this.parseAlignByDeviceClause(this.queryOp);
        } else {
            this.parseDisableAlign(this.queryOp);
        }
    }

    public Operator visitWithoutNullStatement(SqlBaseParser.WithoutNullStatementContext ctx) {
        if (ctx.withoutNullClause().WITHOUT() != null) {
            this.queryOp.setWithoutAllNull(ctx.withoutNullClause().ALL() != null);
            this.queryOp.setWithoutAnyNull(ctx.withoutNullClause().ANY() != null);
        }
        if (ctx.limitClause() != null) {
            this.parseLimitClause(ctx.limitClause(), this.queryOp);
        }
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitOrderByTimeStatement(SqlBaseParser.OrderByTimeStatementContext ctx) {
        this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByTimeStatement(SqlBaseParser.GroupByTimeStatementContext ctx) {
        this.parseGroupByTimeClause(ctx.groupByTimeClause(), this.queryOp);
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitGroupByFillStatement(SqlBaseParser.GroupByFillStatementContext ctx) {
        this.parseGroupByFillClause(ctx.groupByFillClause(), this.queryOp);
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitFillStatement(SqlBaseParser.FillStatementContext ctx) {
        this.parseFillClause(ctx.fillClause(), this.queryOp);
        if (ctx.slimitClause() != null) {
            this.parseSlimitClause(ctx.slimitClause(), this.queryOp);
        }
        if (ctx.alignByDeviceClauseOrDisableAlign() != null) {
            this.parseAlignByDeviceClauseOrDisableAlign(ctx.alignByDeviceClauseOrDisableAlign());
        }
        return this.queryOp;
    }

    public Operator visitGroupByLevelStatement(SqlBaseParser.GroupByLevelStatementContext ctx) {
        this.parseGroupByLevelClause(ctx.groupByLevelClause(), this.queryOp);
        if (ctx.orderByTimeClause() != null) {
            this.parseOrderByTimeClause(ctx.orderByTimeClause(), this.queryOp);
        }
        if (ctx.specialLimit() != null) {
            return (Operator)this.visit((ParseTree)ctx.specialLimit());
        }
        return this.queryOp;
    }

    public Operator visitTableElement(SqlBaseParser.TableElementContext ctx) {
        SelectOperator selectOp = new SelectOperator(21, this.zoneId);
        for (SqlBaseParser.TableCallContext tableCallContext : ctx.tableCall()) {
            SqlBaseParser.SuffixPathContext suffixPathContext = tableCallContext.suffixPath();
            SqlBaseParser.UdfCallContext udfCallContext = tableCallContext.udfCall();
            if (suffixPathContext != null) {
                selectOp.addSelectPath(this.parseSuffixPath(suffixPathContext));
                selectOp.addUdf(null);
                continue;
            }
            if (udfCallContext != null) {
                selectOp.addSelectPath(null);
                this.parseUdfCall(udfCallContext, selectOp);
                continue;
            }
            selectOp.addSelectPath(new PartialPath(new String[]{tableCallContext.SINGLE_QUOTE_STRING_LITERAL().getText()}));
            selectOp.addUdf(null);
        }
        return selectOp;
    }

    public Operator visitFromClause(SqlBaseParser.FromClauseContext ctx) {
        FromOperator fromOp = new FromOperator(22);
        List prefixFromPaths = ctx.prefixPath();
        for (SqlBaseParser.PrefixPathContext prefixFromPath : prefixFromPaths) {
            PartialPath path = this.parsePrefixPath(prefixFromPath);
            fromOp.addPrefixTablePath(path);
        }
        return fromOp;
    }

    private void parseIndexPredicate(SqlBaseParser.IndexPredicateClauseContext ctx) {
        Map<String, Object> props;
        PartialPath path = ctx.suffixPath() != null ? this.parseSuffixPath(ctx.suffixPath()) : this.parseFullPath(ctx.fullPath());
        if (ctx.LIKE() != null) {
            if (this.queryOp.getSelectedPaths().size() != 1) {
                throw new SQLParserException("Index query statement allows only one select path");
            }
            if (!path.equals(this.queryOp.getSelectedPaths().get(0))) {
                throw new SQLParserException("In the index query statement, the path in select element and the index predicate should be same");
            }
            props = this.queryOp.getProps() != null ? this.queryOp.getProps() : new HashMap<String, Object>();
            props.put("PATTERN", this.parseSequence(ctx.sequenceClause(0)));
            this.queryOp.setIndexType(IndexType.RTREE_PAA);
        } else if (ctx.CONTAIN() != null) {
            ArrayList<double[]> compositePattern = new ArrayList<double[]>();
            ArrayList<Double> thresholds = new ArrayList<Double>();
            for (int i = 0; i < ctx.sequenceClause().size(); ++i) {
                compositePattern.add(this.parseSequence(ctx.sequenceClause(i)));
                thresholds.add(Double.parseDouble(ctx.constant(i).getText()));
            }
            props = this.queryOp.getProps() != null ? this.queryOp.getProps() : new HashMap<String, Object>();
            ArrayList<PartialPath> suffixPaths = new ArrayList<PartialPath>();
            suffixPaths.add(path);
            this.queryOp.getSelectOperator().setSuffixPathList(suffixPaths);
            props.put("PATTERN", compositePattern);
            props.put("THRESHOLD", thresholds);
            this.queryOp.setIndexType(IndexType.ELB_INDEX);
        } else {
            throw new SQLParserException("Unknown index predicate: " + ctx);
        }
        this.queryOp.setProps(props);
    }

    private double[] parseSequence(SqlBaseParser.SequenceClauseContext ctx) {
        int seqLen = ctx.constant().size();
        double[] sequence = new double[seqLen];
        for (int i = 0; i < seqLen; ++i) {
            sequence[i] = Double.parseDouble(ctx.constant(i).getText());
        }
        return sequence;
    }

    public void parseGroupByLevelClause(SqlBaseParser.GroupByLevelClauseContext ctx, QueryOperator queryOp) {
        if (!queryOp.hasAggregation()) {
            throw new SQLParserException("There is no aggregation function with group by query");
        }
        this.setLevels(queryOp, ctx.LEVEL(), ctx.INT());
    }

    private void setLevels(QueryOperator queryOp, TerminalNode level, List<TerminalNode> anInt) {
        if (level != null && anInt != null) {
            int[] levels = new int[anInt.size()];
            for (int i = 0; i < anInt.size(); ++i) {
                levels[i] = Integer.parseInt(anInt.get(i).getText());
            }
            queryOp.setLevels(levels);
        }
    }

    public void parseFillClause(SqlBaseParser.FillClauseContext ctx, QueryOperator queryOp) {
        FilterOperator filterOperator = queryOp.getFilterOperator();
        if (!filterOperator.isLeaf() || filterOperator.getTokenIntType() != 161) {
            throw new SQLParserException("Only \"=\" can be used in fill function");
        }
        List list = ctx.typeClause();
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        for (SqlBaseParser.TypeClauseContext typeClause : list) {
            this.parseTypeClause(typeClause, fillTypes);
        }
        queryOp.setFill(true);
        queryOp.setFillTypes(fillTypes);
    }

    private void parseLimitClause(SqlBaseParser.LimitClauseContext ctx, Operator operator) {
        int limit;
        try {
            limit = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. LIMIT <N>: N should be Int32.");
        }
        if (limit <= 0) {
            throw new SQLParserException("LIMIT <N>: N should be greater than 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setLimit(limit);
        } else if (operator instanceof ShowDevicesOperator) {
            ((ShowDevicesOperator)operator).setLimit(limit);
        } else {
            ((QueryOperator)operator).setRowLimit(limit);
        }
        if (ctx.offsetClause() != null) {
            this.parseOffsetClause(ctx.offsetClause(), operator);
        }
    }

    private void parseOffsetClause(SqlBaseParser.OffsetClauseContext ctx, Operator operator) {
        int offset;
        try {
            offset = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. OFFSET <OFFSETValue>: OFFSETValue should be Int32.");
        }
        if (offset < 0) {
            throw new SQLParserException("OFFSET <OFFSETValue>: OFFSETValue should >= 0.");
        }
        if (operator instanceof ShowTimeSeriesOperator) {
            ((ShowTimeSeriesOperator)operator).setOffset(offset);
        } else if (operator instanceof ShowDevicesOperator) {
            ((ShowDevicesOperator)operator).setOffset(offset);
        } else {
            ((QueryOperator)operator).setRowOffset(offset);
        }
    }

    private void parseSlimitClause(SqlBaseParser.SlimitClauseContext ctx, QueryOperator queryOp) {
        int slimit;
        try {
            slimit = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SLIMIT <SN>: SN should be Int32.");
        }
        if (slimit <= 0) {
            throw new SQLParserException("SLIMIT <SN>: SN should be greater than 0.");
        }
        queryOp.setSeriesLimit(slimit);
        if (ctx.soffsetClause() != null) {
            this.parseSoffsetClause(ctx.soffsetClause(), queryOp);
        }
    }

    public void parseSoffsetClause(SqlBaseParser.SoffsetClauseContext ctx, QueryOperator queryOp) {
        int soffset;
        try {
            soffset = Integer.parseInt(ctx.INT().getText());
        }
        catch (NumberFormatException e) {
            throw new SQLParserException("Out of range. SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
        if (soffset < 0) {
            throw new SQLParserException("SOFFSET <SOFFSETValue>: SOFFSETValue should >= 0.");
        }
        queryOp.setSeriesOffset(soffset);
    }

    private void parseGroupByTimeClause(SqlBaseParser.GroupByTimeClauseContext ctx, QueryOperator queryOp) {
        if (!queryOp.hasAggregation()) {
            throw new SQLParserException("There is no aggregation function with group by query");
        }
        queryOp.setGroupByTime(true);
        queryOp.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        queryOp.setUnit(this.parseTimeUnitOrSlidingStep(queryOp, ctx.DURATION(0).getText(), true));
        if (ctx.DURATION().size() == 2) {
            queryOp.setSlidingStep(this.parseTimeUnitOrSlidingStep(queryOp, ctx.DURATION(1).getText(), false));
            if (queryOp.getSlidingStep() < queryOp.getUnit()) {
                throw new SQLParserException("The third parameter sliding step shouldn't be smaller than the second parameter time interval.");
            }
        } else {
            queryOp.setSlidingStep(queryOp.getUnit());
            queryOp.setSlidingStepByMonth(queryOp.isIntervalByMonth());
        }
        this.parseTimeInterval(ctx.timeInterval(), queryOp);
        this.setLevels(queryOp, ctx.LEVEL(), ctx.INT());
    }

    private void parseGroupByFillClause(SqlBaseParser.GroupByFillClauseContext ctx, QueryOperator queryOp) {
        if (!queryOp.hasAggregation()) {
            throw new SQLParserException("There is no aggregation function with group by query");
        }
        queryOp.setGroupByTime(true);
        queryOp.setFill(true);
        queryOp.setLeftCRightO(ctx.timeInterval().LS_BRACKET() != null);
        queryOp.setUnit(DatetimeUtils.convertDurationStrToLong(ctx.DURATION().getText()));
        queryOp.setSlidingStep(queryOp.getUnit());
        this.parseTimeInterval(ctx.timeInterval(), queryOp);
        List list = ctx.typeClause();
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        for (SqlBaseParser.TypeClauseContext typeClause : list) {
            if (typeClause.linearClause() != null) {
                throw new SQLParserException("group by fill doesn't support linear fill");
            }
            if (typeClause.ALL() != null) {
                PreviousFill fill;
                long preRange;
                if (typeClause.previousUntilLastClause() != null) {
                    preRange = typeClause.previousUntilLastClause().DURATION() != null ? DatetimeUtils.convertDurationStrToLong(typeClause.previousUntilLastClause().DURATION().getText()) : (long)IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                    fill = new PreviousFill(preRange, true);
                } else {
                    preRange = typeClause.previousClause().DURATION() != null ? DatetimeUtils.convertDurationStrToLong(typeClause.previousClause().DURATION().getText()) : (long)IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
                    fill = new PreviousFill(preRange);
                }
                for (TSDataType tsDataType : TSDataType.values()) {
                    fillTypes.put(tsDataType, ((IFill)fill).copy());
                }
                break;
            }
            this.parseTypeClause(typeClause, fillTypes);
        }
        queryOp.setFill(true);
        queryOp.setFillTypes(fillTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseTypeClause(SqlBaseParser.TypeClauseContext ctx, Map<TSDataType, IFill> fillTypes) {
        TSDataType dataType = this.parseType(ctx.dataType().getText());
        if (ctx.linearClause() != null && dataType == TSDataType.TEXT) {
            throw new SQLParserException(String.format("type %s cannot use %s fill function", dataType, ctx.linearClause().LINEAR().getText()));
        }
        int defaultFillInterval = IoTDBDescriptor.getInstance().getConfig().getDefaultFillInterval();
        if (ctx.linearClause() != null) {
            if (ctx.linearClause().DURATION(0) != null) {
                long beforeRange = DatetimeUtils.convertDurationStrToLong(ctx.linearClause().DURATION(0).getText());
                long afterRange = DatetimeUtils.convertDurationStrToLong(ctx.linearClause().DURATION(1).getText());
                fillTypes.put(dataType, new LinearFill(beforeRange, afterRange));
                return;
            } else {
                fillTypes.put(dataType, new LinearFill(defaultFillInterval, (long)defaultFillInterval));
            }
            return;
        } else if (ctx.previousClause() != null) {
            if (ctx.previousClause().DURATION() != null) {
                long preRange = DatetimeUtils.convertDurationStrToLong(ctx.previousClause().DURATION().getText());
                fillTypes.put(dataType, new PreviousFill(preRange));
                return;
            } else {
                fillTypes.put(dataType, new PreviousFill(defaultFillInterval));
            }
            return;
        } else if (ctx.specificValueClause() != null) {
            if (ctx.specificValueClause().constant() == null) throw new SQLParserException("fill value cannot be null");
            fillTypes.put(dataType, new ValueFill(ctx.specificValueClause().constant().getText(), dataType));
            return;
        } else if (ctx.previousUntilLastClause().DURATION() != null) {
            long preRange = DatetimeUtils.convertDurationStrToLong(ctx.previousUntilLastClause().DURATION().getText());
            fillTypes.put(dataType, new PreviousFill(preRange, true));
            return;
        } else {
            fillTypes.put(dataType, new PreviousFill(defaultFillInterval, true));
        }
    }

    private TSDataType parseType(String datatype) {
        String type;
        switch (type = datatype.toLowerCase()) {
            case "int32": {
                return TSDataType.INT32;
            }
            case "int64": {
                return TSDataType.INT64;
            }
            case "float": {
                return TSDataType.FLOAT;
            }
            case "double": {
                return TSDataType.DOUBLE;
            }
            case "boolean": {
                return TSDataType.BOOLEAN;
            }
            case "text": {
                return TSDataType.TEXT;
            }
        }
        throw new SQLParserException("not a valid fill type : " + type);
    }

    private void parseOrderByTimeClause(SqlBaseParser.OrderByTimeClauseContext ctx, QueryOperator queryOp) {
        queryOp.setColumn(ctx.TIME().getText());
        if (ctx.DESC() != null) {
            queryOp.setAscending(false);
        }
    }

    private void parseAlignByDeviceClause(QueryOperator queryOp) {
        queryOp.setAlignByDevice(true);
    }

    private void parseDisableAlign(QueryOperator queryOp) {
        queryOp.setAlignByTime(false);
    }

    private void parseTimeInterval(SqlBaseParser.TimeIntervalContext timeInterval, QueryOperator queryOp) {
        long currentTime = DatetimeUtils.currentTime();
        long startTime = timeInterval.timeValue(0).INT() != null ? Long.parseLong(timeInterval.timeValue(0).INT().getText()) : (timeInterval.timeValue(0).dateExpression() != null ? this.parseDateExpression(timeInterval.timeValue(0).dateExpression(), currentTime).longValue() : this.parseTimeFormat(timeInterval.timeValue(0).dateFormat().getText(), currentTime));
        long endTime = timeInterval.timeValue(1).INT() != null ? Long.parseLong(timeInterval.timeValue(1).INT().getText()) : (timeInterval.timeValue(1).dateExpression() != null ? this.parseDateExpression(timeInterval.timeValue(1).dateExpression(), currentTime).longValue() : this.parseTimeFormat(timeInterval.timeValue(1).dateFormat().getText(), currentTime));
        queryOp.setStartTime(startTime);
        queryOp.setEndTime(endTime);
        if (startTime >= endTime) {
            throw new SQLParserException("start time should be smaller than endTime in GroupBy");
        }
    }

    private void parseShowWhereClause(SqlBaseParser.ShowWhereClauseContext ctx, ShowTimeSeriesOperator operator) {
        SqlBaseParser.PropertyValueContext propertyValueContext;
        if (ctx.containsExpression() != null) {
            operator.setContains(true);
            propertyValueContext = ctx.containsExpression().propertyValue();
            operator.setKey(ctx.containsExpression().ID().getText());
        } else {
            operator.setContains(false);
            propertyValueContext = ctx.property().propertyValue();
            operator.setKey(ctx.property().ID().getText());
        }
        String value = propertyValueContext.stringLiteral() != null ? this.removeStringQuote(propertyValueContext.getText()) : propertyValueContext.getText();
        operator.setValue(value);
    }

    private String[] parsePrivilege(SqlBaseParser.PrivilegesContext ctx) {
        List privilegeList = ctx.stringLiteral();
        ArrayList<String> privileges = new ArrayList<String>();
        for (SqlBaseParser.StringLiteralContext privilege : privilegeList) {
            privileges.add(this.removeStringQuote(privilege.getText()));
        }
        return privileges.toArray(new String[0]);
    }

    private Pair<Long, Long> parseDeleteTimeInterval(DeleteDataOperator operator) {
        FilterOperator filterOperator = operator.getFilterOperator();
        if (!filterOperator.isLeaf() && filterOperator.getTokenIntType() != 1) {
            throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
        }
        if (filterOperator.isLeaf()) {
            return this.calcOperatorInterval(filterOperator);
        }
        List<FilterOperator> children = filterOperator.getChildren();
        FilterOperator lOperator = children.get(0);
        FilterOperator rOperator = children.get(1);
        if (!lOperator.isLeaf() || !rOperator.isLeaf()) {
            throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
        }
        Pair<Long, Long> leftOpInterval = this.calcOperatorInterval(lOperator);
        Pair<Long, Long> rightOpInterval = this.calcOperatorInterval(rOperator);
        Pair parsedInterval = new Pair((Object)Math.max((Long)leftOpInterval.left, (Long)rightOpInterval.left), (Object)Math.min((Long)leftOpInterval.right, (Long)rightOpInterval.right));
        if ((Long)parsedInterval.left > (Long)parsedInterval.right) {
            throw new SQLParserException("Invalid delete range: [" + parsedInterval.left + ", " + parsedInterval.right + "]");
        }
        return parsedInterval;
    }

    private Pair<Long, Long> calcOperatorInterval(FilterOperator filterOperator) {
        if (filterOperator.getSinglePath() != null && !"time".equals(filterOperator.getSinglePath().getMeasurement())) {
            throw new SQLParserException(DELETE_ONLY_SUPPORT_TIME_EXP_ERROR_MSG);
        }
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        switch (filterOperator.getTokenIntType()) {
            case 164: {
                return new Pair((Object)Long.MIN_VALUE, (Object)(time - 1L));
            }
            case 165: {
                return new Pair((Object)Long.MIN_VALUE, (Object)time);
            }
            case 162: {
                return new Pair((Object)(time + 1L), (Object)Long.MAX_VALUE);
            }
            case 163: {
                return new Pair((Object)time, (Object)Long.MAX_VALUE);
            }
            case 161: {
                return new Pair((Object)time, (Object)time);
            }
        }
        throw new SQLParserException(DELETE_RANGE_ERROR_MSG);
    }

    public Operator visitWhereClause(SqlBaseParser.WhereClauseContext ctx) {
        if (ctx.indexPredicateClause() != null) {
            this.parseIndexPredicate(ctx.indexPredicateClause());
            return this.queryOp;
        }
        FilterOperator whereOp = new FilterOperator(23);
        whereOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
        return whereOp;
    }

    private FilterOperator parseOrExpression(SqlBaseParser.OrExpressionContext ctx) {
        if (ctx.andExpression().size() == 1) {
            return this.parseAndExpression(ctx.andExpression(0));
        }
        FilterOperator binaryOp = new FilterOperator(2);
        if (ctx.andExpression().size() > 2) {
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(0)));
            binaryOp.addChildOperator(this.parseAndExpression(ctx.andExpression(1)));
            for (int i = 2; i < ctx.andExpression().size(); ++i) {
                FilterOperator op = new FilterOperator(2);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parseAndExpression(ctx.andExpression(i)));
                binaryOp = op;
            }
        } else {
            for (SqlBaseParser.AndExpressionContext andExpressionContext : ctx.andExpression()) {
                binaryOp.addChildOperator(this.parseAndExpression(andExpressionContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parseAndExpression(SqlBaseParser.AndExpressionContext ctx) {
        if (ctx.predicate().size() == 1) {
            return this.parsePredicate(ctx.predicate(0));
        }
        FilterOperator binaryOp = new FilterOperator(1);
        int size = ctx.predicate().size();
        if (size > 2) {
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(0)));
            binaryOp.addChildOperator(this.parsePredicate(ctx.predicate(1)));
            for (int i = 2; i < size; ++i) {
                FilterOperator op = new FilterOperator(1);
                op.addChildOperator(binaryOp);
                op.addChildOperator(this.parsePredicate(ctx.predicate(i)));
                binaryOp = op;
            }
        } else {
            for (SqlBaseParser.PredicateContext predicateContext : ctx.predicate()) {
                binaryOp.addChildOperator(this.parsePredicate(predicateContext));
            }
        }
        return binaryOp;
    }

    private FilterOperator parsePredicate(SqlBaseParser.PredicateContext ctx) {
        PartialPath path = null;
        if (ctx.OPERATOR_NOT() != null) {
            FilterOperator notOp = new FilterOperator(3);
            notOp.addChildOperator(this.parseOrExpression(ctx.orExpression()));
            return notOp;
        }
        if (ctx.LR_BRACKET() != null && ctx.OPERATOR_NOT() == null) {
            return this.parseOrExpression(ctx.orExpression());
        }
        if (ctx.REGEXP() != null || ctx.LIKE() != null) {
            if (ctx.suffixPath() != null) {
                path = this.parseSuffixPath(ctx.suffixPath());
            } else if (ctx.fullPath() != null) {
                path = this.parseFullPath(ctx.fullPath());
            }
            if (path == null) {
                throw new SQLParserException("Path is null, please check the sql.");
            }
            return ctx.REGEXP() != null ? new RegexpOperator(ctx.REGEXP().getSymbol().getType(), path, ctx.stringLiteral().getText()) : new LikeOperator(ctx.LIKE().getSymbol().getType(), path, ctx.stringLiteral().getText());
        }
        if (ctx.TIME() != null || ctx.TIMESTAMP() != null) {
            path = new PartialPath(SQLConstant.getSingleTimeArray());
        }
        if (ctx.fullPath() != null) {
            path = this.parseFullPath(ctx.fullPath());
        }
        if (ctx.suffixPath() != null) {
            path = this.parseSuffixPath(ctx.suffixPath());
        }
        if (path == null) {
            throw new SQLParserException("Path is null, please check the sql.");
        }
        if (ctx.inClause() != null) {
            return this.parseInOperator(ctx.inClause(), path);
        }
        return this.parseBasicFunctionOperator(ctx, path);
    }

    private FilterOperator parseInOperator(SqlBaseParser.InClauseContext ctx, PartialPath path) {
        HashSet<String> values = new HashSet<String>();
        boolean not = ctx.OPERATOR_NOT() != null;
        for (SqlBaseParser.ConstantContext constant : ctx.constant()) {
            if (constant.dateExpression() != null) {
                if (!path.equals(SQLConstant.TIME_PATH)) {
                    throw new SQLParserException(path.getFullPath(), "Date can only be used to time");
                }
                values.add(Long.toString(this.parseDateExpression(constant.dateExpression())));
                continue;
            }
            values.add(constant.getText());
        }
        return new InOperator(ctx.OPERATOR_IN().getSymbol().getType(), path, not, values);
    }

    private FilterOperator parseBasicFunctionOperator(SqlBaseParser.PredicateContext ctx, PartialPath path) {
        BasicFunctionOperator basic;
        if (ctx.constant().dateExpression() != null) {
            if (!path.equals(SQLConstant.TIME_PATH)) {
                throw new SQLParserException(path.getFullPath(), "Date can only be used to time");
            }
            basic = new BasicFunctionOperator(ctx.comparisonOperator().type.getType(), path, Long.toString(this.parseDateExpression(ctx.constant().dateExpression())));
        } else {
            basic = new BasicFunctionOperator(ctx.comparisonOperator().type.getType(), path, ctx.constant().getText());
        }
        return basic;
    }

    private Long parseDateExpression(SqlBaseParser.DateExpressionContext ctx) {
        long time = this.parseTimeFormat(ctx.getChild(0).getText());
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if (ctx.getChild(i).getText().equals("+")) {
                time += DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private Long parseDateExpression(SqlBaseParser.DateExpressionContext ctx, long currentTime) {
        long time = this.parseTimeFormat(ctx.getChild(0).getText(), currentTime);
        for (int i = 1; i < ctx.getChildCount(); i += 2) {
            if (ctx.getChild(i).getText().equals("+")) {
                time += DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
                continue;
            }
            time -= DatetimeUtils.convertDurationStrToLong(time, ctx.getChild(i + 1).getText());
        }
        return time;
    }

    private long parseTimeUnitOrSlidingStep(QueryOperator queryOp, String durationStr, boolean isParsingTimeUnit) {
        if (durationStr.toLowerCase().contains("mo")) {
            if (isParsingTimeUnit) {
                queryOp.setIntervalByMonth(true);
            } else {
                queryOp.setSlidingStepByMonth(true);
            }
        }
        return DatetimeUtils.convertDurationStrToLong(durationStr);
    }

    private PartialPath parseSuffixPath(SqlBaseParser.SuffixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = ((SqlBaseParser.NodeNameContext)nodeNames.get(i)).getText();
        }
        return new PartialPath(path);
    }

    private void parseInsertColumnSpec(SqlBaseParser.InsertColumnsSpecContext ctx, InsertOperator insertOp) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutStar();
        ArrayList<String> measurementList = new ArrayList<String>();
        for (SqlBaseParser.NodeNameWithoutStarContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            String measurement = nodeNameWithoutStar.getText();
            measurementList.add(measurement);
        }
        insertOp.setMeasurementList(measurementList.toArray(new String[0]));
    }

    private void parseInsertValuesSpec(SqlBaseParser.InsertValuesSpecContext ctx, InsertOperator insertOp) {
        long timestamp = ctx.dateFormat() != null ? this.parseTimeFormat(ctx.dateFormat().getText()) : Long.parseLong(ctx.INT().getText());
        insertOp.setTime(timestamp);
        ArrayList<String> valueList = new ArrayList<String>();
        List values = ctx.constant();
        for (SqlBaseParser.ConstantContext value : values) {
            valueList.add(value.getText());
        }
        insertOp.setValueList(valueList.toArray(new String[0]));
    }

    private void parseAlterClause(SqlBaseParser.AlterClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        HashMap<String, String> alterMap = new HashMap<String, String>();
        if (ctx.RENAME() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.RENAME);
            alterMap.put(ctx.beforeName.getText(), ctx.currentName.getText());
        } else if (ctx.SET() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.SET);
            this.setMap(ctx, alterMap);
        } else if (ctx.DROP() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.DROP);
            for (TerminalNode dropId : ctx.ID()) {
                alterMap.put(dropId.getText(), null);
            }
        } else if (ctx.TAGS() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_TAGS);
            this.setMap(ctx, alterMap);
        } else if (ctx.ATTRIBUTES() != null) {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.ADD_ATTRIBUTES);
            this.setMap(ctx, alterMap);
        } else {
            alterTimeSeriesOperator.setAlterType(AlterTimeSeriesOperator.AlterType.UPSERT);
            if (ctx.aliasClause() != null) {
                this.parseAliasClause(ctx.aliasClause(), alterTimeSeriesOperator);
            }
            if (ctx.tagClause() != null) {
                this.parseTagClause(ctx.tagClause(), alterTimeSeriesOperator);
            }
            if (ctx.attributeClause() != null) {
                this.parseAttributeClause(ctx.attributeClause(), alterTimeSeriesOperator);
            }
        }
        alterTimeSeriesOperator.setAlterMap(alterMap);
    }

    public void parseAliasClause(SqlBaseParser.AliasClauseContext ctx, AlterTimeSeriesOperator alterTimeSeriesOperator) {
        if (alterTimeSeriesOperator != null && ctx.ID() != null) {
            alterTimeSeriesOperator.setAlias(ctx.ID().getText());
        }
    }

    private void setMap(SqlBaseParser.AlterClauseContext ctx, Map<String, String> alterMap) {
        List tagsList = ctx.property();
        if (ctx.property(0) != null) {
            for (SqlBaseParser.PropertyContext property : tagsList) {
                String value = property.propertyValue().stringLiteral() != null ? this.removeStringQuote(property.propertyValue().getText()) : property.propertyValue().getText();
                alterMap.put(property.ID().getText(), value);
            }
        }
    }

    private String removeStringQuote(String src) {
        if (src.charAt(0) == '\'' && src.charAt(src.length() - 1) == '\'') {
            return src.substring(1, src.length() - 1);
        }
        if (src.charAt(0) == '\"' && src.charAt(src.length() - 1) == '\"') {
            return src.substring(1, src.length() - 1);
        }
        throw new SQLParserException("error format for string with quote:" + src);
    }

    private PartialPath parsePrefixPath(SqlBaseParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = ((SqlBaseParser.NodeNameContext)nodeNames.get(i)).getText();
        }
        return new PartialPath(path);
    }

    public void parseAttributeClauses(SqlBaseParser.AttributeClausesContext ctx, CreateTimeSeriesOperator createTimeSeriesOperator) {
        String dataType = ctx.dataType().getChild(0).getText().toUpperCase();
        TSDataType tsDataType = TSDataType.valueOf((String)dataType);
        createTimeSeriesOperator.setDataType(tsDataType);
        IoTDBDescriptor ioTDBDescriptor = IoTDBDescriptor.getInstance();
        TSEncoding encoding = ioTDBDescriptor.getDefaultEncodingByType(tsDataType);
        if (Objects.nonNull(ctx.encoding())) {
            String encodingString = ctx.encoding().getChild(0).getText().toUpperCase();
            encoding = TSEncoding.valueOf((String)encodingString);
        }
        createTimeSeriesOperator.setEncoding(encoding);
        List properties = ctx.property();
        CompressionType compressor = ctx.compressor() != null ? CompressionType.valueOf((String)ctx.compressor().getText().toUpperCase()) : TSFileDescriptor.getInstance().getConfig().getCompressor();
        HashMap<String, String> props = null;
        if (ctx.property(0) != null) {
            props = new HashMap<String, String>(properties.size());
            for (SqlBaseParser.PropertyContext property : properties) {
                props.put(property.ID().getText().toLowerCase(), property.propertyValue().getText().toLowerCase());
            }
        }
        createTimeSeriesOperator.setCompressor(compressor);
        createTimeSeriesOperator.setProps(props);
        if (ctx.tagClause() != null) {
            this.parseTagClause(ctx.tagClause(), createTimeSeriesOperator);
        }
        if (ctx.attributeClause() != null) {
            this.parseAttributeClause(ctx.attributeClause(), createTimeSeriesOperator);
        }
    }

    public void parseAttributeClause(SqlBaseParser.AttributeClauseContext ctx, Operator operator) {
        Map<String, String> attributes = this.extractMap(ctx.property(), ctx.property(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setAttributes(attributes);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setAttributesMap(attributes);
        }
    }

    public void parseTagClause(SqlBaseParser.TagClauseContext ctx, Operator operator) {
        Map<String, String> tags = this.extractMap(ctx.property(), ctx.property(0));
        if (operator instanceof CreateTimeSeriesOperator) {
            ((CreateTimeSeriesOperator)operator).setTags(tags);
        } else if (operator instanceof AlterTimeSeriesOperator) {
            ((AlterTimeSeriesOperator)operator).setTagsMap(tags);
        }
    }

    private Map<String, String> extractMap(List<SqlBaseParser.PropertyContext> property2, SqlBaseParser.PropertyContext property3) {
        HashMap<String, String> tags = new HashMap<String, String>(property2.size());
        if (property3 != null) {
            for (SqlBaseParser.PropertyContext property : property2) {
                String value = property.propertyValue().stringLiteral() != null ? this.removeStringQuote(property.propertyValue().getText()) : property.propertyValue().getText();
                tags.put(property.ID().getText(), value);
            }
        }
        return tags;
    }

    private PartialPath parseFullPath(SqlBaseParser.FullPathContext ctx) {
        List nodeNamesWithoutStar = ctx.nodeNameWithoutStar();
        String[] path = new String[nodeNamesWithoutStar.size() + 1];
        int i = 0;
        if (ctx.ROOT() != null) {
            path[0] = ctx.ROOT().getText();
        }
        for (SqlBaseParser.NodeNameWithoutStarContext nodeNameWithoutStar : nodeNamesWithoutStar) {
            path[++i] = nodeNameWithoutStar.getText();
        }
        return new PartialPath(path);
    }

    public long parseTimeFormat(String timestampStr) throws SQLParserException {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return DatetimeUtils.currentTime();
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    public long parseTimeFormat(String timestampStr, long currentTime) throws SQLParserException {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new SQLParserException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now()")) {
            return currentTime;
        }
        try {
            return DatetimeUtils.convertDatetimeStrToLong(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new SQLParserException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    private void parseLoadFiles(LoadFilesOperator operator, SqlBaseParser.LoadFilesClauseContext ctx) {
        if (ctx.AUTOREGISTER() != null) {
            operator.setAutoCreateSchema(Boolean.parseBoolean(ctx.booleanClause().getText()));
        } else if (ctx.SGLEVEL() != null) {
            operator.setSgLevel(Integer.parseInt(ctx.INT().getText()));
        } else if (ctx.VERIFY() != null) {
            operator.setVerifyMetadata(Boolean.parseBoolean(ctx.booleanClause().getText()));
        } else {
            throw new SQLParserException(String.format("load tsfile format %s error, please input AUTOREGISTER | SGLEVEL | VERIFY.", ctx.getText()));
        }
        if (ctx.loadFilesClause() != null) {
            this.parseLoadFiles(operator, ctx.loadFilesClause());
        }
    }
}

