/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.service;

import java.lang.reflect.InvocationTargetException;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.service.UDFClassLoader;

public class UDFRegistrationInformation {
    private final String functionName;
    private final String className;
    private final boolean isTemporary;
    private final boolean isBuiltin;
    private Class<?> functionClass;

    public UDFRegistrationInformation(String functionName, String className, boolean isTemporary, boolean isBuiltin, Class<?> functionClass) {
        this.functionName = functionName;
        this.className = className;
        this.isTemporary = isTemporary;
        this.isBuiltin = isBuiltin;
        this.functionClass = functionClass;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isTemporary() {
        return !this.isBuiltin && this.isTemporary;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    public Class<?> getFunctionClass() {
        return this.functionClass;
    }

    public void updateFunctionClass(UDFClassLoader udfClassLoader) throws ClassNotFoundException {
        this.functionClass = Class.forName(this.className, true, udfClassLoader);
    }

    public boolean isUDTF() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) instanceof UDTF;
    }

    public boolean isUDAF() {
        return false;
    }
}

