/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import com.google.common.base.Throwables;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import io.airlift.airline.ParseArgumentsMissingException;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import io.airlift.airline.ParseCommandMissingException;
import io.airlift.airline.ParseCommandUnrecognizedException;
import io.airlift.airline.ParseOptionConversionException;
import io.airlift.airline.ParseOptionMissingException;
import io.airlift.airline.ParseOptionMissingValueException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.utils.Binary;

public class CommonUtils {
    private static final int CPUS = Runtime.getRuntime().availableProcessors();
    public static final int MAX_EXECUTOR_POOL_SIZE = Math.max(100, CommonUtils.getCpuCores() * 5);

    private CommonUtils() {
    }

    public static int getJdkVersion() {
        String[] javaVersionElements = System.getProperty("java.version").split("\\.");
        if (Integer.parseInt(javaVersionElements[0]) == 1) {
            return Integer.parseInt(javaVersionElements[1]);
        }
        return Integer.parseInt(javaVersionElements[0]);
    }

    public static long getUsableSpace(String dir) {
        File dirFile = FSFactoryProducer.getFSFactory().getFile(dir);
        dirFile.mkdirs();
        return dirFile.getFreeSpace();
    }

    public static boolean hasSpace(String dir) {
        return CommonUtils.getUsableSpace(dir) > 0L;
    }

    public static long getOccupiedSpace(String folderPath) throws IOException {
        Path folder = Paths.get(folderPath, new String[0]);
        try (Stream<Path> s = Files.walk(folder, new FileVisitOption[0]);){
            long l = s.filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
            return l;
        }
    }

    public static Object parseValue(TSDataType dataType, String value) throws QueryProcessException {
        try {
            switch (dataType) {
                case BOOLEAN: {
                    return CommonUtils.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TEXT: {
                    if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
                        if (value.length() == 1) {
                            return new Binary(value);
                        }
                        return new Binary(value.substring(1, value.length() - 1));
                    }
                    return new Binary(value);
                }
            }
            throw new QueryProcessException("Unsupported data type:" + dataType);
        }
        catch (NumberFormatException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    public static Object parseValueForTest(TSDataType dataType, String value) throws QueryProcessException {
        try {
            switch (dataType) {
                case BOOLEAN: {
                    return CommonUtils.parseBoolean(value);
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TEXT: {
                    return new Binary(value);
                }
            }
            throw new QueryProcessException("Unsupported data type:" + dataType);
        }
        catch (NumberFormatException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    private static boolean parseBoolean(String value) throws QueryProcessException {
        if ("0".equals(value = value.toLowerCase()) || "false".equals(value)) {
            return false;
        }
        if ("1".equals(value) || "true".equals(value)) {
            return true;
        }
        throw new QueryProcessException("The BOOLEAN should be true/TRUE, false/FALSE or 0/1");
    }

    public static int getCpuCores() {
        return CPUS;
    }

    public static int getMaxExecutorPoolSize() {
        return MAX_EXECUTOR_POOL_SIZE;
    }

    public static int runCli(List<Class<? extends Runnable>> commands, String[] args, String cliName, String cliDescription) {
        Cli.CliBuilder builder = Cli.builder((String)cliName);
        builder.withDescription(cliDescription).withDefaultCommand(Help.class).withCommands(commands);
        Cli parser = builder.build();
        int status = 0;
        try {
            Runnable parse = (Runnable)parser.parse(args);
            parse.run();
        }
        catch (ParseArgumentsMissingException | ParseArgumentsUnexpectedException | ParseCommandMissingException | ParseCommandUnrecognizedException | ParseOptionConversionException | ParseOptionMissingException | ParseOptionMissingValueException | IllegalArgumentException | IllegalStateException e) {
            CommonUtils.badUse((Exception)e);
            status = 1;
        }
        catch (Exception e) {
            CommonUtils.err(Throwables.getRootCause((Throwable)e));
            status = 2;
        }
        return status;
    }

    private static void badUse(Exception e) {
        System.out.println("memory-tool: " + e.getMessage());
        System.out.println("See 'memory-tool help' or 'memory-tool help <command>'.");
    }

    private static void err(Throwable e) {
        System.err.println("error: " + e.getMessage());
        System.err.println("-- StackTrace --");
        System.err.println(Throwables.getStackTraceAsString((Throwable)e));
    }
}

