/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.rescon.TsFileResourceManager;
import org.apache.iotdb.tsfile.utils.TsFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSpaceCompactionExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");

    public static void handleException(String storageGroup, File logFile, List<TsFileResource> targetResourceList, List<TsFileResource> seqResourceList, List<TsFileResource> unseqResourceList, TsFileManager tsFileManager, long timePartition) {
        try {
            if (logFile == null || !logFile.exists()) {
                return;
            }
            LOGGER.info("[Compaction][ExceptionHandler] Cross space compaction start handling exception, source seqFiles is " + seqResourceList + ", source unseqFiles is " + unseqResourceList);
            boolean handleSuccess = true;
            ArrayList<TsFileResource> lostSourceFiles = new ArrayList<TsFileResource>();
            boolean allSeqFilesExist = CrossSpaceCompactionExceptionHandler.checkAllSourceFileExists(seqResourceList, lostSourceFiles);
            boolean allUnseqFilesExist = CrossSpaceCompactionExceptionHandler.checkAllSourceFileExists(unseqResourceList, lostSourceFiles);
            handleSuccess = allSeqFilesExist && allUnseqFilesExist ? CrossSpaceCompactionExceptionHandler.handleWhenAllSourceFilesExist(storageGroup, targetResourceList, seqResourceList, unseqResourceList, tsFileManager, timePartition) : CrossSpaceCompactionExceptionHandler.handleWhenSomeSourceFilesLost(storageGroup, seqResourceList, unseqResourceList, targetResourceList, lostSourceFiles);
            if (!handleSuccess) {
                LOGGER.error("[Compaction][ExceptionHandler] failed to handle exception, set allowCompaction to false in {}", (Object)storageGroup);
                tsFileManager.setAllowCompaction(false);
            } else {
                FileUtils.delete((File)logFile);
            }
        }
        catch (Throwable throwable) {
            LOGGER.error("[Compaction][ExceptionHandler] exception occurs when handling exception in cross space compaction. Set allowCompaction to false in {}", (Object)storageGroup, (Object)throwable);
            tsFileManager.setAllowCompaction(false);
        }
    }

    private static boolean checkAllSourceFileExists(List<TsFileResource> tsFileResources, List<TsFileResource> lostFiles) {
        for (TsFileResource tsFileResource : tsFileResources) {
            if (tsFileResource.getTsFile().exists() && tsFileResource.resourceFileExists()) continue;
            lostFiles.add(tsFileResource);
        }
        return lostFiles.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleWhenAllSourceFilesExist(String storageGroup, List<TsFileResource> targetTsFiles, List<TsFileResource> seqFileList, List<TsFileResource> unseqFileList, TsFileManager tsFileManager, long timePartition) throws IOException {
        TsFileResourceList unseqTsFileResourceList = tsFileManager.getUnsequenceListByTimePartition(timePartition);
        TsFileResourceList seqTsFileResourceList = tsFileManager.getSequenceListByTimePartition(timePartition);
        CompactionUtils.deleteCompactionModsFile(seqFileList, unseqFileList);
        boolean removeAllTargetFile = true;
        tsFileManager.writeLock("CrossSpaceCompactionExceptionHandler");
        try {
            for (TsFileResource targetTsFile : targetTsFiles) {
                targetTsFile.writeLock();
                if (!targetTsFile.remove()) {
                    LOGGER.error("{} [Compaction][Exception] failed to delete target tsfile {} when handling exception", (Object)storageGroup, (Object)targetTsFile);
                    removeAllTargetFile = false;
                }
                targetTsFile.writeUnlock();
                if (!targetTsFile.isFileInList()) continue;
                seqTsFileResourceList.remove(targetTsFile);
                TsFileResourceManager.getInstance().removeTsFileResource(targetTsFile);
            }
            for (TsFileResource tsFileResource : seqFileList) {
                if (tsFileResource.isFileInList()) continue;
                seqTsFileResourceList.keepOrderInsert(tsFileResource);
                TsFileResourceManager.getInstance().registerSealedTsFileResource(tsFileResource);
            }
            for (TsFileResource tsFileResource : unseqFileList) {
                if (tsFileResource.isFileInList()) continue;
                unseqTsFileResourceList.keepOrderInsert(tsFileResource);
                TsFileResourceManager.getInstance().registerSealedTsFileResource(tsFileResource);
            }
        }
        finally {
            tsFileManager.writeUnlock();
        }
        return removeAllTargetFile;
    }

    public static boolean handleWhenSomeSourceFilesLost(String storageGroup, List<TsFileResource> seqFileList, List<TsFileResource> unseqFileList, List<TsFileResource> targetFileList, List<TsFileResource> lostSourceFiles) throws IOException {
        if (!CrossSpaceCompactionExceptionHandler.checkIsTargetFilesComplete(targetFileList, lostSourceFiles, storageGroup)) {
            return false;
        }
        for (TsFileResource unseqFile : unseqFileList) {
            unseqFile.remove();
            unseqFile.setDeleted(true);
        }
        for (TsFileResource seqFile : seqFileList) {
            seqFile.remove();
            seqFile.setDeleted(true);
        }
        CompactionUtils.deleteCompactionModsFile(seqFileList, unseqFileList);
        return true;
    }

    public static boolean checkIsTargetFilesComplete(List<TsFileResource> targetResources, List<TsFileResource> lostSourceResources, String fullStorageGroupName) throws IOException {
        for (TsFileResource targetResource : targetResources) {
            if (TsFileUtils.isTsFileComplete((File)targetResource.getTsFile())) continue;
            LOGGER.error("{} [Compaction][ExceptionHandler] target file {} is not complete, and some source files {} is lost, do nothing. Set allowCompaction to false", new Object[]{fullStorageGroupName, targetResource, lostSourceResources});
            return false;
        }
        return true;
    }
}

