/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner;

import java.io.File;
import java.util.List;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTaskFactory;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionSelector;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionTask;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;

public enum InnerCompactionStrategy {
    SIZE_TIERED_COMPACTION;


    public static InnerCompactionStrategy getInnerCompactionStrategy(String name) {
        if ("SIZE_TIERED_COMPACTION".equalsIgnoreCase(name)) {
            return SIZE_TIERED_COMPACTION;
        }
        throw new RuntimeException("Illegal Compaction Strategy " + name);
    }

    public AbstractInnerSpaceCompactionTask getCompactionTask(String logicalStorageGroupName, String virtualStorageGroup, long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence) {
        switch (this) {
            default: 
        }
        return new SizeTieredCompactionTask(logicalStorageGroupName, virtualStorageGroup, timePartition, tsFileManager, selectedTsFileResourceList, sequence, CompactionTaskManager.currentTaskNum);
    }

    public AbstractInnerSpaceCompactionTask getCompactionRecoverTask(String logicalStorageGroupName, String virtualStorageGroup, long timePartition, File compactionLogFile, String dataDir, boolean sequence, TsFileManager tsFileManager) {
        switch (this) {
            default: 
        }
        return new SizeTieredCompactionRecoverTask(logicalStorageGroupName, virtualStorageGroup, timePartition, compactionLogFile, dataDir, sequence, CompactionTaskManager.currentTaskNum, tsFileManager);
    }

    public AbstractInnerSpaceCompactionSelector getCompactionSelector(String logicalStorageGroupName, String virtualStorageGroupName, long timePartition, TsFileManager tsFileManager, boolean sequence, InnerSpaceCompactionTaskFactory taskFactory) {
        switch (this) {
            default: 
        }
        return new SizeTieredCompactionSelector(logicalStorageGroupName, virtualStorageGroupName, timePartition, tsFileManager, sequence, taskFactory);
    }
}

