/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class CrossSpaceCompactionWriter
extends AbstractCompactionWriter {
    private List<TsFileIOWriter> fileWriterList = new ArrayList<TsFileIOWriter>();
    private List<TsFileResource> seqTsFileResources;
    private int seqFileIndex;
    private final long[] currentDeviceEndTime;
    private final boolean[] isEmptyFile;
    private final boolean[] hasTargetFileStartChunkGroup;
    private final List<TsFileResource> targetTsFileResources;

    public CrossSpaceCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqFileResources) throws IOException {
        this.currentDeviceEndTime = new long[seqFileResources.size()];
        this.isEmptyFile = new boolean[seqFileResources.size()];
        this.hasTargetFileStartChunkGroup = new boolean[seqFileResources.size()];
        for (int i = 0; i < targetResources.size(); ++i) {
            this.fileWriterList.add((TsFileIOWriter)new RestorableTsFileIOWriter(targetResources.get(i).getTsFile()));
            this.isEmptyFile[i] = true;
        }
        this.seqTsFileResources = seqFileResources;
        this.targetTsFileResources = targetResources;
        this.seqFileIndex = 0;
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.deviceId = deviceId;
        this.isAlign = isAlign;
        this.seqFileIndex = 0;
        this.checkIsDeviceExistAndGetDeviceEndTime();
        for (int i = 0; i < this.seqTsFileResources.size(); ++i) {
            this.hasTargetFileStartChunkGroup[i] = false;
        }
    }

    @Override
    public void endChunkGroup() throws IOException {
        for (int i = 0; i < this.seqTsFileResources.size(); ++i) {
            if (!this.hasTargetFileStartChunkGroup[i]) continue;
            this.fileWriterList.get(i).endChunkGroup();
        }
        this.deviceId = null;
    }

    @Override
    public void endMeasurement() throws IOException {
        this.writeRateLimit(this.chunkWriter.estimateMaxSeriesMemSize());
        this.chunkWriter.writeToFileWriter(this.fileWriterList.get(this.seqFileIndex));
        this.chunkWriter = null;
        this.seqFileIndex = 0;
    }

    @Override
    public void write(long timestamp, Object value) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(timestamp);
        this.checkAndMayStartChunkGroup();
        this.writeDataPoint(timestamp, value);
        this.updateDeviceStartAndEndTime(this.targetTsFileResources.get(this.seqFileIndex), timestamp);
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriterList.get(this.seqFileIndex));
        this.isEmptyFile[this.seqFileIndex] = false;
    }

    @Override
    public void write(long[] timestamps, Object values) {
    }

    @Override
    public void endFile() throws IOException {
        for (int i = 0; i < this.isEmptyFile.length; ++i) {
            this.fileWriterList.get(i).endFile();
            if (!this.isEmptyFile[i]) continue;
            this.fileWriterList.get(i).getFile().delete();
        }
    }

    @Override
    public void close() throws IOException {
        for (TsFileIOWriter targetWriter : this.fileWriterList) {
            if (targetWriter == null || !targetWriter.canWrite()) continue;
            targetWriter.close();
        }
        this.fileWriterList = null;
        this.seqTsFileResources = null;
        this.chunkWriter = null;
    }

    private void checkTimeAndMayFlushChunkToCurrentFile(long timestamp) throws IOException {
        while (timestamp > this.currentDeviceEndTime[this.seqFileIndex]) {
            if (this.seqFileIndex != this.seqTsFileResources.size() - 1) {
                this.writeRateLimit(this.chunkWriter.estimateMaxSeriesMemSize());
                this.chunkWriter.writeToFileWriter(this.fileWriterList.get(this.seqFileIndex));
                ++this.seqFileIndex;
                continue;
            }
            return;
        }
    }

    private void checkIsDeviceExistAndGetDeviceEndTime() throws IOException {
        for (int fileIndex = 0; fileIndex < this.seqTsFileResources.size(); ++fileIndex) {
            if (this.seqTsFileResources.get(fileIndex).getTimeIndexType() == 1) {
                this.currentDeviceEndTime[fileIndex] = this.seqTsFileResources.get(fileIndex).getEndTime(this.deviceId);
                continue;
            }
            long endTime = Long.MIN_VALUE;
            Map deviceMetadataMap = FileReaderManager.getInstance().get(this.seqTsFileResources.get(fileIndex).getTsFilePath(), true).readDeviceMetadata(this.deviceId);
            for (Map.Entry entry : deviceMetadataMap.entrySet()) {
                long tmpStartTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getStartTime();
                long tmpEndTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getEndTime();
                if (tmpEndTime < tmpStartTime || endTime >= tmpEndTime) continue;
                endTime = tmpEndTime;
            }
            this.currentDeviceEndTime[fileIndex] = endTime;
        }
    }

    private void checkAndMayStartChunkGroup() throws IOException {
        if (!this.hasTargetFileStartChunkGroup[this.seqFileIndex]) {
            this.fileWriterList.get(this.seqFileIndex).startChunkGroup(this.deviceId);
            this.hasTargetFileStartChunkGroup[this.seqFileIndex] = true;
        }
    }
}

