/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowChildPathsPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.dataset.ShowDevicesDataSet;
import org.apache.iotdb.db.query.dataset.ShowTimeseriesDataSet;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByLevelDataSet;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class QueryDataSetHandler {
    private QueryDataSetHandler() {
    }

    public static Response fillQueryDataSet(QueryDataSet sourceDataSet, PhysicalPlan physicalPlan, int actualRowSizeLimit) throws IOException {
        if (sourceDataSet instanceof ShowDevicesDataSet || sourceDataSet instanceof ListDataSet && !(physicalPlan instanceof LastQueryPlan) || sourceDataSet instanceof ShowTimeseriesDataSet || sourceDataSet instanceof SingleDataSet && !(physicalPlan instanceof AggregationPlan)) {
            return QueryDataSetHandler.fillShowPlanDataSet(sourceDataSet, actualRowSizeLimit);
        }
        if (sourceDataSet instanceof ListDataSet) {
            return QueryDataSetHandler.fillLastQueryPlanDataSet(sourceDataSet, actualRowSizeLimit);
        }
        if (sourceDataSet instanceof SingleDataSet && ((AggregationPlan)physicalPlan).getLevels() != null) {
            return QueryDataSetHandler.fillAggregationPlanDataSet(sourceDataSet, (AggregationPlan)physicalPlan, actualRowSizeLimit);
        }
        if (sourceDataSet instanceof GroupByLevelDataSet) {
            return QueryDataSetHandler.fillGroupByLevelDataSet(sourceDataSet, actualRowSizeLimit, 1L);
        }
        if (physicalPlan instanceof QueryPlan) {
            return QueryDataSetHandler.fillDataSetWithTimestamps(sourceDataSet, (QueryPlan)physicalPlan, actualRowSizeLimit, 1L);
        }
        return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("unsupported query data type: %s", sourceDataSet.getClass().getName()))).build();
    }

    public static Response fillDataSetWithTimestamps(QueryDataSet sourceDataSet, QueryPlan queryPlan, int actualRowSizeLimit, long timePrecision) throws IOException {
        org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.model.QueryDataSet();
        List<ResultColumn> resultColumns = queryPlan.getResultColumns();
        int[] targetDataSetIndexToSourceDataSetIndex = new int[resultColumns.size()];
        Map<String, Integer> sourcePathToQueryDataSetIndex = queryPlan.getPathToIndex();
        for (int i = 0; i < resultColumns.size(); ++i) {
            ResultColumn resultColumn = resultColumns.get(i);
            targetDataSet.addExpressionsItem(resultColumn.getResultColumnName());
            targetDataSet.addValuesItem(new ArrayList());
            targetDataSetIndexToSourceDataSetIndex[i] = sourcePathToQueryDataSetIndex.get(resultColumn.getResultColumnName());
        }
        return QueryDataSetHandler.fillQueryDataSetWithTimestamps(sourceDataSet, actualRowSizeLimit, targetDataSetIndexToSourceDataSetIndex, targetDataSet, timePrecision);
    }

    public static Response fillLastQueryPlanDataSet(QueryDataSet sourceDataSet, int actualRowSizeLimit) throws IOException {
        int[] targetDataSetIndexToSourceDataSetIndex = new int[sourceDataSet.getPaths().size()];
        org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.model.QueryDataSet();
        QueryDataSetHandler.initTargetDatasetOrderByOrderWithSourceDataSet(sourceDataSet, targetDataSetIndexToSourceDataSetIndex, targetDataSet);
        return QueryDataSetHandler.fillQueryDataSetWithTimestamps(sourceDataSet, actualRowSizeLimit, targetDataSetIndexToSourceDataSetIndex, targetDataSet, 1L);
    }

    public static Response fillGroupByLevelDataSet(QueryDataSet sourceDataSet, int actualRowSizeLimit, long timePrecision) throws IOException {
        int[] targetDataSetIndexToSourceDataSetIndex = new int[sourceDataSet.getPaths().size()];
        org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.model.QueryDataSet();
        QueryDataSetHandler.initTargetDatasetExpByOrderWithSourceDataSet(sourceDataSet, targetDataSetIndexToSourceDataSetIndex, targetDataSet);
        return QueryDataSetHandler.fillQueryDataSetWithTimestamps(sourceDataSet, actualRowSizeLimit, targetDataSetIndexToSourceDataSetIndex, targetDataSet, timePrecision);
    }

    private static Response fillAggregationPlanDataSet(QueryDataSet dataSet, AggregationPlan aggregationPlan, int actualRowSizeLimit) throws IOException {
        Map<String, AggregateResult> groupPathsResultMap = aggregationPlan.getGroupPathsResultMap();
        int[] targetDataSetIndexToSourceDataSetIndex = new int[groupPathsResultMap.size()];
        org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.model.QueryDataSet();
        Map<String, Integer> sourcePathToSourceQueryDataSetIndex = aggregationPlan.getPathToIndex();
        Iterator<Map.Entry<String, AggregateResult>> iterator = groupPathsResultMap.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, AggregateResult> next = iterator.next();
            targetDataSet.addColumnNamesItem(next.getKey());
            targetDataSet.addValuesItem(new ArrayList());
            targetDataSetIndexToSourceDataSetIndex[i] = sourcePathToSourceQueryDataSetIndex.get(next.getKey());
            ++i;
        }
        return QueryDataSetHandler.fillQueryDataSetWithoutTimestamps(dataSet, actualRowSizeLimit, targetDataSetIndexToSourceDataSetIndex, targetDataSet);
    }

    private static Response fillShowPlanDataSet(QueryDataSet sourceDataSet, int actualRowSizeLimit) throws IOException {
        int[] targetDataSetIndexToSourceDataSetIndex = new int[sourceDataSet.getPaths().size()];
        org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet = new org.apache.iotdb.db.protocol.rest.model.QueryDataSet();
        QueryDataSetHandler.initTargetDatasetOrderByOrderWithSourceDataSet(sourceDataSet, targetDataSetIndexToSourceDataSetIndex, targetDataSet);
        return QueryDataSetHandler.fillQueryDataSetWithoutTimestamps(sourceDataSet, actualRowSizeLimit, targetDataSetIndexToSourceDataSetIndex, targetDataSet);
    }

    private static void initTargetDatasetOrderByOrderWithSourceDataSet(QueryDataSet sourceDataSet, int[] targetDataSetIndexToSourceDataSetIndex, org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet) {
        if (sourceDataSet.getPaths() != null) {
            for (int i = 0; i < sourceDataSet.getPaths().size(); ++i) {
                Path path = (Path)sourceDataSet.getPaths().get(i);
                targetDataSet.addColumnNamesItem(path.getFullPath());
                targetDataSet.addValuesItem(new ArrayList());
                targetDataSetIndexToSourceDataSetIndex[i] = i;
            }
        }
    }

    private static void initTargetDatasetExpByOrderWithSourceDataSet(QueryDataSet sourceDataSet, int[] targetDataSetIndexToSourceDataSetIndex, org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet) {
        if (sourceDataSet.getPaths() != null) {
            for (int i = 0; i < sourceDataSet.getPaths().size(); ++i) {
                Path path = (Path)sourceDataSet.getPaths().get(i);
                targetDataSet.addExpressionsItem(path.getFullPath());
                targetDataSet.addValuesItem(new ArrayList());
                targetDataSetIndexToSourceDataSetIndex[i] = i;
            }
        }
    }

    private static Response fillQueryDataSetWithTimestamps(QueryDataSet sourceDataSet, int actualRowSizeLimit, int[] targetDataSetIndexToSourceDataSetIndex, org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet, long timePrecision) throws IOException {
        int fetched = 0;
        while (sourceDataSet.hasNext()) {
            if (0 < actualRowSizeLimit && actualRowSizeLimit <= fetched) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("Dataset row size exceeded the given max row size (%d)", actualRowSizeLimit))).build();
            }
            RowRecord sourceDataSetRowRecord = sourceDataSet.next();
            targetDataSet.addTimestampsItem(Long.valueOf(timePrecision == 1L ? sourceDataSetRowRecord.getTimestamp() : sourceDataSetRowRecord.getTimestamp() / timePrecision));
            QueryDataSetHandler.fillSourceRowRecordIntoTargetDataSet(sourceDataSetRowRecord, targetDataSetIndexToSourceDataSetIndex, targetDataSet);
            ++fetched;
        }
        return Response.ok().entity((Object)targetDataSet).build();
    }

    private static Response fillQueryDataSetWithoutTimestamps(QueryDataSet sourceDataSet, int actualRowSizeLimit, int[] targetDataSetIndexToSourceDataSetIndex, org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet) throws IOException {
        int fetched = 0;
        while (sourceDataSet.hasNext()) {
            if (0 < actualRowSizeLimit && actualRowSizeLimit <= fetched) {
                return Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode())).message(String.format("Dataset row size exceeded the given max row size (%d)", actualRowSizeLimit))).build();
            }
            QueryDataSetHandler.fillSourceRowRecordIntoTargetDataSet(sourceDataSet.next(), targetDataSetIndexToSourceDataSetIndex, targetDataSet);
            ++fetched;
        }
        return Response.ok().entity((Object)targetDataSet).build();
    }

    private static void fillSourceRowRecordIntoTargetDataSet(RowRecord sourceDataSetRowRecord, int[] targetDataSetIndexToSourceDataSetIndex, org.apache.iotdb.db.protocol.rest.model.QueryDataSet targetDataSet) {
        int columnSize = targetDataSet.getColumnNames() != null ? targetDataSet.getColumnNames().size() : targetDataSet.getExpressions().size();
        for (int i = 0; i < columnSize; ++i) {
            List targetDataSetColumn = (List)targetDataSet.getValues().get(i);
            Field sourceDataSetField = (Field)sourceDataSetRowRecord.getFields().get(targetDataSetIndexToSourceDataSetIndex[i]);
            if (sourceDataSetField == null) {
                targetDataSetColumn.add(null);
                continue;
            }
            targetDataSetColumn.add(sourceDataSetField.getDataType().equals((Object)TSDataType.TEXT) ? sourceDataSetField.getStringValue() : sourceDataSetField.getObjectValue(sourceDataSetField.getDataType()));
        }
    }

    public static Response fillGrafanaVariablesResult(QueryDataSet dataSet, PhysicalPlan physicalPlan) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        while (dataSet.hasNext()) {
            RowRecord rowRecord = dataSet.next();
            List fields = rowRecord.getFields();
            String nodePaths = ((Field)fields.get(0)).getObjectValue(((Field)fields.get(0)).getDataType()).toString();
            if (physicalPlan instanceof ShowChildPathsPlan) {
                String[] nodeSubPath = nodePaths.split("\\.");
                results.add(nodeSubPath[nodeSubPath.length - 1]);
                continue;
            }
            results.add(nodePaths);
        }
        return Response.ok().entity(results).build();
    }
}

