/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertMultiTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsOfOneDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowsPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.SelectIntoPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AlterTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.ClearCachePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateMultiTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateSnapshotPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DropContinuousQueryPlan;
import org.apache.iotdb.db.qp.physical.sys.DropFunctionPlan;
import org.apache.iotdb.db.qp.physical.sys.DropIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.FlushPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadConfigurationPlan;
import org.apache.iotdb.db.qp.physical.sys.LogPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.MergePlan;
import org.apache.iotdb.db.qp.physical.sys.PruneTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetSystemModePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.StartTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StopTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.StorageGroupMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.qp.utils.EmptyOutputStream;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PhysicalPlan {
    private static final Logger logger = LoggerFactory.getLogger(PhysicalPlan.class);
    private static final String SERIALIZATION_UNIMPLEMENTED = "serialization unimplemented";
    private boolean isQuery = false;
    private Operator.OperatorType operatorType;
    private static final int NULL_VALUE_LEN = -1;
    protected boolean canBeSplit = true;
    private String loginUserName;
    protected long index;
    private boolean debug;
    private boolean isPrefixMatch = false;

    public boolean canBeSplit() {
        return this.canBeSplit;
    }

    protected PhysicalPlan() {
    }

    protected PhysicalPlan(Operator.OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    public abstract List<? extends PartialPath> getPaths();

    public void setPaths(List<PartialPath> paths) {
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public boolean isSelectInto() {
        return false;
    }

    public Operator.OperatorType getOperatorType() {
        return this.operatorType;
    }

    public String getOperatorName() {
        return this.operatorType.toString();
    }

    public void setOperatorType(Operator.OperatorType operatorType) {
        this.operatorType = operatorType;
    }

    public List<String> getAggregations() {
        return Collections.emptyList();
    }

    public void setQuery(boolean query) {
        this.isQuery = query;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getSerializedSize() throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new EmptyOutputStream());
        this.serialize(dataOutputStream);
        return dataOutputStream.size();
    }

    public void serialize(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    public final void serialize(ByteBuffer buffer) {
        buffer.mark();
        try {
            this.serializeImpl(buffer);
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (BufferOverflowException e) {
            buffer.reset();
            throw e;
        }
        catch (Exception e) {
            logger.error("Rollback buffer entry because error occurs when serializing this physical plan.", (Throwable)e);
            buffer.reset();
            throw e;
        }
    }

    protected void serializeImpl(ByteBuffer buffer) {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    public void deserialize(ByteBuffer buffer) throws IllegalPathException, IOException {
        throw new UnsupportedOperationException(SERIALIZATION_UNIMPLEMENTED);
    }

    protected void putString(ByteBuffer buffer, String value) {
        if (value == null) {
            buffer.putInt(-1);
        } else {
            ReadWriteIOUtils.write((String)value, (ByteBuffer)buffer);
        }
    }

    protected void putStrings(ByteBuffer buffer, List<String> values) {
        for (String value : values) {
            this.putString(buffer, value);
        }
    }

    protected void putString(DataOutputStream stream, String value) throws IOException {
        if (value == null) {
            stream.writeInt(-1);
        } else {
            ReadWriteIOUtils.write((String)value, (OutputStream)stream);
        }
    }

    protected void putStrings(DataOutputStream stream, List<String> values) throws IOException {
        for (String value : values) {
            this.putString(stream, value);
        }
    }

    protected String readString(ByteBuffer buffer) {
        int valueLen = buffer.getInt();
        if (valueLen == -1) {
            return null;
        }
        return ReadWriteIOUtils.readStringWithLength((ByteBuffer)buffer, (int)valueLen);
    }

    protected List<String> readStrings(ByteBuffer buffer, int totalSize) {
        ArrayList<String> result = new ArrayList<String>(totalSize);
        for (int i = 0; i < totalSize; ++i) {
            result.add(this.readString(buffer));
        }
        return result;
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        if (this instanceof AuthorPlan) {
            this.loginUserName = loginUserName;
        }
    }

    public boolean isAuthenticationRequired() {
        return true;
    }

    public List<? extends PartialPath> getAuthPaths() {
        return this.getPaths();
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public void checkIntegrity() throws QueryProcessException {
    }

    public boolean isPrefixMatch() {
        return this.isPrefixMatch;
    }

    public void setPrefixMatch(boolean prefixMatch) {
        this.isPrefixMatch = prefixMatch;
    }

    public static enum PhysicalPlanType {
        INSERT,
        DELETE,
        BATCHINSERT,
        SET_STORAGE_GROUP,
        CREATE_TIMESERIES,
        TTL,
        GRANT_WATERMARK_EMBEDDING,
        REVOKE_WATERMARK_EMBEDDING,
        CREATE_ROLE,
        DELETE_ROLE,
        CREATE_USER,
        REVOKE_USER_ROLE,
        REVOKE_ROLE_PRIVILEGE,
        REVOKE_USER_PRIVILEGE,
        GRANT_ROLE_PRIVILEGE,
        GRANT_USER_PRIVILEGE,
        GRANT_USER_ROLE,
        MODIFY_PASSWORD,
        DELETE_USER,
        DELETE_STORAGE_GROUP,
        SHOW_TIMESERIES,
        DELETE_TIMESERIES,
        LOAD_CONFIGURATION,
        CREATE_MULTI_TIMESERIES,
        ALTER_TIMESERIES,
        FLUSH,
        CREATE_INDEX,
        DROP_INDEX,
        CHANGE_TAG_OFFSET,
        CHANGE_ALIAS,
        MNODE,
        MEASUREMENT_MNODE,
        STORAGE_GROUP_MNODE,
        BATCH_INSERT_ONE_DEVICE,
        MULTI_BATCH_INSERT,
        BATCH_INSERT_ROWS,
        SHOW_DEVICES,
        CREATE_TEMPLATE,
        SET_TEMPLATE,
        ACTIVATE_TEMPLATE,
        AUTO_CREATE_DEVICE_MNODE,
        CREATE_ALIGNED_TIMESERIES,
        CLUSTER_LOG,
        CREATE_TRIGGER,
        DROP_TRIGGER,
        START_TRIGGER,
        STOP_TRIGGER,
        CREATE_CONTINUOUS_QUERY,
        DROP_CONTINUOUS_QUERY,
        SHOW_CONTINUOUS_QUERIES,
        MERGE,
        CREATE_SNAPSHOT,
        CLEARCACHE,
        CREATE_FUNCTION,
        DROP_FUNCTION,
        SELECT_INTO,
        SET_SYSTEM_MODE,
        UNSET_TEMPLATE,
        APPEND_TEMPLATE,
        PRUNE_TEMPLATE,
        DROP_TEMPLATE;

    }

    public static class Factory {
        private Factory() {
        }

        public static PhysicalPlan create(ByteBuffer buffer) throws IOException, IllegalPathException {
            PhysicalPlan plan;
            byte typeNum = buffer.get();
            if (typeNum >= PhysicalPlanType.values().length) {
                throw new IOException("unrecognized log type " + typeNum);
            }
            PhysicalPlanType type = PhysicalPlanType.values()[typeNum];
            switch (type) {
                case INSERT: {
                    plan = new InsertRowPlan();
                    break;
                }
                case BATCHINSERT: {
                    plan = new InsertTabletPlan();
                    break;
                }
                case MULTI_BATCH_INSERT: {
                    plan = new InsertMultiTabletPlan();
                    break;
                }
                case DELETE: {
                    plan = new DeletePlan();
                    break;
                }
                case SET_STORAGE_GROUP: {
                    plan = new SetStorageGroupPlan();
                    break;
                }
                case CREATE_TIMESERIES: {
                    plan = new CreateTimeSeriesPlan();
                    break;
                }
                case CREATE_ALIGNED_TIMESERIES: {
                    plan = new CreateAlignedTimeSeriesPlan();
                    break;
                }
                case DELETE_TIMESERIES: {
                    plan = new DeleteTimeSeriesPlan();
                    break;
                }
                case CREATE_INDEX: {
                    plan = new CreateIndexPlan();
                    break;
                }
                case DROP_INDEX: {
                    plan = new DropIndexPlan();
                    break;
                }
                case TTL: {
                    plan = new SetTTLPlan();
                    break;
                }
                case GRANT_WATERMARK_EMBEDDING: {
                    plan = new DataAuthPlan(Operator.OperatorType.GRANT_WATERMARK_EMBEDDING);
                    break;
                }
                case REVOKE_WATERMARK_EMBEDDING: {
                    plan = new DataAuthPlan(Operator.OperatorType.REVOKE_WATERMARK_EMBEDDING);
                    break;
                }
                case CREATE_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.CREATE_ROLE);
                    break;
                }
                case DELETE_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.DELETE_ROLE);
                    break;
                }
                case CREATE_USER: {
                    plan = new AuthorPlan(Operator.OperatorType.CREATE_USER);
                    break;
                }
                case REVOKE_USER_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.REVOKE_USER_ROLE);
                    break;
                }
                case REVOKE_ROLE_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.REVOKE_ROLE_PRIVILEGE);
                    break;
                }
                case REVOKE_USER_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.REVOKE_USER_PRIVILEGE);
                    break;
                }
                case GRANT_ROLE_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.GRANT_ROLE_PRIVILEGE);
                    break;
                }
                case GRANT_USER_PRIVILEGE: {
                    plan = new AuthorPlan(Operator.OperatorType.GRANT_USER_PRIVILEGE);
                    break;
                }
                case GRANT_USER_ROLE: {
                    plan = new AuthorPlan(Operator.OperatorType.GRANT_USER_ROLE);
                    break;
                }
                case MODIFY_PASSWORD: {
                    plan = new AuthorPlan(Operator.OperatorType.MODIFY_PASSWORD);
                    break;
                }
                case DELETE_USER: {
                    plan = new AuthorPlan(Operator.OperatorType.DELETE_USER);
                    break;
                }
                case DELETE_STORAGE_GROUP: {
                    plan = new DeleteStorageGroupPlan();
                    break;
                }
                case SHOW_TIMESERIES: {
                    plan = new ShowTimeSeriesPlan();
                    break;
                }
                case SHOW_DEVICES: {
                    plan = new ShowDevicesPlan();
                    break;
                }
                case LOAD_CONFIGURATION: {
                    plan = new LoadConfigurationPlan();
                    break;
                }
                case ALTER_TIMESERIES: {
                    plan = new AlterTimeSeriesPlan();
                    break;
                }
                case FLUSH: {
                    plan = new FlushPlan();
                    break;
                }
                case CREATE_MULTI_TIMESERIES: {
                    plan = new CreateMultiTimeSeriesPlan();
                    break;
                }
                case CHANGE_ALIAS: {
                    plan = new ChangeAliasPlan();
                    break;
                }
                case CHANGE_TAG_OFFSET: {
                    plan = new ChangeTagOffsetPlan();
                    break;
                }
                case MNODE: {
                    plan = new MNodePlan();
                    break;
                }
                case MEASUREMENT_MNODE: {
                    plan = new MeasurementMNodePlan();
                    break;
                }
                case STORAGE_GROUP_MNODE: {
                    plan = new StorageGroupMNodePlan();
                    break;
                }
                case BATCH_INSERT_ROWS: {
                    plan = new InsertRowsPlan();
                    break;
                }
                case BATCH_INSERT_ONE_DEVICE: {
                    plan = new InsertRowsOfOneDevicePlan();
                    break;
                }
                case CREATE_TRIGGER: {
                    plan = new CreateTriggerPlan();
                    break;
                }
                case DROP_TRIGGER: {
                    plan = new DropTriggerPlan();
                    break;
                }
                case START_TRIGGER: {
                    plan = new StartTriggerPlan();
                    break;
                }
                case STOP_TRIGGER: {
                    plan = new StopTriggerPlan();
                    break;
                }
                case CLUSTER_LOG: {
                    plan = new LogPlan();
                    break;
                }
                case CREATE_TEMPLATE: {
                    plan = new CreateTemplatePlan();
                    break;
                }
                case APPEND_TEMPLATE: {
                    plan = new AppendTemplatePlan();
                    break;
                }
                case PRUNE_TEMPLATE: {
                    plan = new PruneTemplatePlan();
                    break;
                }
                case DROP_TEMPLATE: {
                    plan = new DropTemplatePlan();
                    break;
                }
                case UNSET_TEMPLATE: {
                    plan = new UnsetTemplatePlan();
                    break;
                }
                case SET_TEMPLATE: {
                    plan = new SetTemplatePlan();
                    break;
                }
                case ACTIVATE_TEMPLATE: {
                    plan = new ActivateTemplatePlan();
                    break;
                }
                case AUTO_CREATE_DEVICE_MNODE: {
                    plan = new AutoCreateDeviceMNodePlan();
                    break;
                }
                case CREATE_CONTINUOUS_QUERY: {
                    plan = new CreateContinuousQueryPlan();
                    break;
                }
                case DROP_CONTINUOUS_QUERY: {
                    plan = new DropContinuousQueryPlan();
                    break;
                }
                case MERGE: {
                    plan = new MergePlan();
                    break;
                }
                case CREATE_SNAPSHOT: {
                    plan = new CreateSnapshotPlan();
                    break;
                }
                case CLEARCACHE: {
                    plan = new ClearCachePlan();
                    break;
                }
                case CREATE_FUNCTION: {
                    plan = new CreateFunctionPlan();
                    break;
                }
                case DROP_FUNCTION: {
                    plan = new DropFunctionPlan();
                    break;
                }
                case SELECT_INTO: {
                    plan = new SelectIntoPlan();
                    break;
                }
                case SET_SYSTEM_MODE: {
                    plan = new SetSystemModePlan();
                    break;
                }
                default: {
                    throw new IOException("unrecognized log type " + (Object)((Object)type));
                }
            }
            plan.deserialize(buffer);
            return plan;
        }
    }
}

