/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimeFillPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.qp.physical.crud.MeasurementInfo;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.expression.IExpression;

public class AlignByDevicePlan
extends QueryPlan {
    public static final String MEASUREMENT_ERROR_MESSAGE = "The paths of the SELECT clause can only be measurements or STAR.";
    public static final String ALIAS_ERROR_MESSAGE = "alias %s can only be matched with one time series";
    public static final String DATATYPE_ERROR_MESSAGE = "The data types of the same measurement column should be the same across devices.";
    private List<String> measurements;
    private Map<String, MeasurementInfo> measurementInfoMap;
    private List<PartialPath> deduplicatePaths = new ArrayList<PartialPath>();
    private List<String> aggregations;
    private Map<String, List<Integer>> deviceToPathIndex = new LinkedHashMap<String, List<Integer>>();
    private Map<String, IExpression> deviceToFilterMap;
    private GroupByTimePlan groupByTimePlan;
    private GroupByTimeFillPlan groupByFillPlan;
    private FillQueryPlan fillQueryPlan;
    private AggregationPlan aggregationPlan;

    @Override
    public void deduplicate(PhysicalGenerator physicalGenerator) {
        LinkedHashSet<String> pathWithAggregationSet = new LinkedHashSet<String>();
        ArrayList<String> deduplicatedAggregations = new ArrayList<String>();
        HashSet<String> measurements = new HashSet<String>(this.getMeasurements());
        for (int i = 0; i < this.paths.size(); ++i) {
            String pathStrWithAggregation;
            String aggregation;
            PartialPath path = (PartialPath)this.paths.get(i);
            String measurementWithAggregation = this.getMeasurementStrWithAggregation(path, aggregation = this.aggregations != null ? this.aggregations.get(i) : null);
            if (!measurements.contains(measurementWithAggregation) || pathWithAggregationSet.contains(pathStrWithAggregation = this.getPathStrWithAggregation(path, aggregation))) continue;
            pathWithAggregationSet.add(pathStrWithAggregation);
            this.deduplicatePaths.add(path);
            if (this.aggregations != null) {
                deduplicatedAggregations.add(this.aggregations.get(i));
            }
            this.deviceToPathIndex.computeIfAbsent(path.getDevice(), k -> new ArrayList()).add(this.deduplicatePaths.size() - 1);
        }
        this.setAggregations(deduplicatedAggregations);
        this.paths = null;
    }

    public List<PartialPath> getDeduplicatePaths() {
        return this.deduplicatePaths;
    }

    public void removeDevice(String device) {
        this.deviceToPathIndex.remove(device);
    }

    public void setMeasurementInfoMap(Map<String, MeasurementInfo> measurementInfoMap) {
        this.measurementInfoMap = measurementInfoMap;
    }

    public Map<String, MeasurementInfo> getMeasurementInfoMap() {
        return this.measurementInfoMap;
    }

    @Override
    public TSExecuteStatementResp getTSExecuteStatementResp(boolean isJdbcQuery) {
        TSExecuteStatementResp resp = RpcUtils.getTSExecuteStatementResp((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        ArrayList<String> respColumns = new ArrayList<String>();
        ArrayList<String> columnTypes = new ArrayList<String>();
        respColumns.add("Device");
        columnTypes.add(TSDataType.TEXT.toString());
        LinkedHashSet<String> deduplicatedMeasurements = new LinkedHashSet<String>();
        for (String measurement : this.measurements) {
            MeasurementInfo measurementInfo = this.measurementInfoMap.get(measurement);
            TSDataType type = TSDataType.TEXT;
            String measurementName = measurement;
            if (measurementInfo != null) {
                type = measurementInfo.getColumnDataType();
                measurementName = measurementInfo.getMeasurementAlias();
            }
            respColumns.add(measurementName != null ? measurementName : measurement);
            columnTypes.add(type.toString());
            deduplicatedMeasurements.add(measurement);
        }
        this.measurements = new ArrayList<String>(deduplicatedMeasurements);
        resp.setColumns(respColumns);
        resp.setDataTypeList(columnTypes);
        if (this.getOperatorType() == Operator.OperatorType.AGGREGATION) {
            resp.setIgnoreTimeStamp(true);
        }
        return resp;
    }

    public void setMeasurements(List<String> measurements) {
        this.measurements = measurements;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    @Override
    public List<String> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<String> aggregations) {
        this.aggregations = aggregations.isEmpty() ? null : aggregations;
    }

    public Map<String, List<Integer>> getDeviceToPathIndex() {
        return this.deviceToPathIndex;
    }

    public void setDeviceToPathIndex(Map<String, List<Integer>> deviceToPathIndex) {
        this.deviceToPathIndex = deviceToPathIndex;
    }

    public Map<String, IExpression> getDeviceToFilterMap() {
        return this.deviceToFilterMap;
    }

    public void setDeviceToFilterMap(Map<String, IExpression> deviceToFilterMap) {
        this.deviceToFilterMap = deviceToFilterMap;
    }

    public GroupByTimePlan getGroupByTimePlan() {
        return this.groupByTimePlan;
    }

    public void setGroupByTimePlan(GroupByTimePlan groupByTimePlan) {
        this.groupByTimePlan = groupByTimePlan;
        this.setOperatorType(Operator.OperatorType.GROUP_BY_TIME);
    }

    public GroupByTimeFillPlan getGroupByFillPlan() {
        return this.groupByFillPlan;
    }

    public void setGroupByFillPlan(GroupByTimeFillPlan groupByFillPlan) {
        this.groupByFillPlan = groupByFillPlan;
        this.setOperatorType(Operator.OperatorType.GROUP_BY_FILL);
    }

    public FillQueryPlan getFillQueryPlan() {
        return this.fillQueryPlan;
    }

    public void setFillQueryPlan(FillQueryPlan fillQueryPlan) {
        this.fillQueryPlan = fillQueryPlan;
        this.setOperatorType(Operator.OperatorType.FILL);
    }

    public AggregationPlan getAggregationPlan() {
        return this.aggregationPlan;
    }

    public void setAggregationPlan(AggregationPlan aggregationPlan) {
        this.aggregationPlan = aggregationPlan;
        this.setOperatorType(Operator.OperatorType.AGGREGATION);
    }

    private String getMeasurementStrWithAggregation(PartialPath path, String aggregation) {
        String measurement = path.getMeasurement();
        if (aggregation != null) {
            measurement = aggregation + "(" + measurement + ")";
        }
        return measurement;
    }

    private String getPathStrWithAggregation(PartialPath path, String aggregation) {
        String initialPath = path.getFullPath();
        if (aggregation != null) {
            initialPath = aggregation + "(" + initialPath + ")";
        }
        return initialPath;
    }
}

