/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.GroupByMonthFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.thrift.TException;

public class GroupByTimePlan
extends AggregationPlan {
    protected long startTime;
    protected long endTime;
    protected long interval;
    protected long slidingStep;
    protected boolean isIntervalByMonth;
    protected boolean isSlidingStepByMonth;
    protected boolean leftCRightO = true;

    public GroupByTimePlan() {
        this.setOperatorType(Operator.OperatorType.GROUP_BY_TIME);
    }

    @Override
    public TSExecuteStatementResp getTSExecuteStatementResp(boolean isJdbcQuery) throws TException, MetadataException {
        TSExecuteStatementResp resp = super.getTSExecuteStatementResp(isJdbcQuery);
        resp.setIgnoreTimeStamp(false);
        return resp;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isSlidingStepByMonth() {
        return this.isSlidingStepByMonth;
    }

    public void setSlidingStepByMonth(boolean isSlidingStepByMonth) {
        this.isSlidingStepByMonth = isSlidingStepByMonth;
    }

    public boolean isIntervalByMonth() {
        return this.isIntervalByMonth;
    }

    public void setIntervalByMonth(boolean isIntervalByMonth) {
        this.isIntervalByMonth = isIntervalByMonth;
    }

    public long getSlidingStep() {
        return this.slidingStep;
    }

    public void setSlidingStep(long slidingStep) {
        this.slidingStep = slidingStep;
    }

    public boolean isLeftCRightO() {
        return this.leftCRightO;
    }

    public void setLeftCRightO(boolean leftCRightO) {
        this.leftCRightO = leftCRightO;
    }

    public static GlobalTimeExpression getTimeExpression(GroupByTimePlan plan) throws QueryProcessException {
        if (plan.isSlidingStepByMonth() || plan.isIntervalByMonth()) {
            if (!plan.isAscending()) {
                throw new QueryProcessException("Group by month doesn't support order by time desc now.");
            }
            return new GlobalTimeExpression((Filter)new GroupByMonthFilter(plan.getInterval(), plan.getSlidingStep(), plan.getStartTime(), plan.getEndTime(), plan.isSlidingStepByMonth(), plan.isIntervalByMonth(), SessionManager.getInstance().getCurrSessionTimeZone()));
        }
        return new GlobalTimeExpression((Filter)new GroupByFilter(plan.getInterval(), plan.getSlidingStep(), plan.getStartTime(), plan.getEndTime()));
    }
}

