/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.PathNumOverLimitException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.constant.FilterConstant;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromComponent;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.InOperator;
import org.apache.iotdb.db.qp.logical.crud.LikeOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.RegexpOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.logical.crud.WhereComponent;
import org.apache.iotdb.db.qp.strategy.optimizer.ILogicalOptimizer;
import org.apache.iotdb.db.qp.utils.GroupByLevelController;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.expression.ResultColumn;
import org.apache.iotdb.db.service.IoTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatPathOptimizer
implements ILogicalOptimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcatPathOptimizer.class);
    private static final String WARNING_NO_SUFFIX_PATHS = "failed to concat series paths because the given query operator didn't have suffix paths";
    private static final String WARNING_NO_PREFIX_PATHS = "failed to concat series paths because the given query operator didn't have prefix paths";

    @Override
    public Operator transform(Operator operator) throws LogicalOptimizeException, PathNumOverLimitException {
        QueryOperator queryOperator = (QueryOperator)operator;
        if (!this.optimizable(queryOperator)) {
            return queryOperator;
        }
        this.concatSelect(queryOperator);
        this.removeWildcardsInSelectPaths(queryOperator);
        this.concatFilterAndRemoveWildcards(queryOperator);
        return queryOperator;
    }

    private boolean optimizable(QueryOperator queryOperator) {
        if (queryOperator.isAlignByDevice()) {
            return false;
        }
        SelectComponent select = queryOperator.getSelectComponent();
        if (select == null || select.getResultColumns().isEmpty()) {
            LOGGER.warn(WARNING_NO_SUFFIX_PATHS);
            return false;
        }
        FromComponent from = queryOperator.getFromComponent();
        if (from == null || from.getPrefixPaths().isEmpty()) {
            LOGGER.warn(WARNING_NO_PREFIX_PATHS);
            return false;
        }
        return true;
    }

    private void concatSelect(QueryOperator queryOperator) throws LogicalOptimizeException {
        List<PartialPath> prefixPaths = queryOperator.getFromComponent().getPrefixPaths();
        ArrayList<ResultColumn> resultColumns = new ArrayList<ResultColumn>();
        for (ResultColumn suffixColumn : queryOperator.getSelectComponent().getResultColumns()) {
            boolean needAliasCheck = suffixColumn.hasAlias() && !queryOperator.isGroupByLevel();
            suffixColumn.concat(prefixPaths, resultColumns, needAliasCheck);
        }
        queryOperator.getSelectComponent().setResultColumns(resultColumns);
    }

    private void removeWildcardsInSelectPaths(QueryOperator queryOperator) throws LogicalOptimizeException, PathNumOverLimitException {
        if (queryOperator.getIndexType() != null) {
            return;
        }
        ArrayList<ResultColumn> resultColumns = new ArrayList();
        GroupByLevelController groupByLevelController = null;
        if (queryOperator.isGroupByLevel()) {
            groupByLevelController = new GroupByLevelController(queryOperator);
            queryOperator.resetSLimitOffset();
            resultColumns = new LinkedList();
        }
        WildcardsRemover wildcardsRemover = new WildcardsRemover(queryOperator);
        for (ResultColumn resultColumn : queryOperator.getSelectComponent().getResultColumns()) {
            boolean needAliasCheck = resultColumn.hasAlias() && !queryOperator.isGroupByLevel();
            resultColumn.removeWildcards(wildcardsRemover, resultColumns, needAliasCheck);
            if (groupByLevelController != null) {
                groupByLevelController.control(resultColumn, resultColumns);
            }
            if (!wildcardsRemover.checkIfPathNumberIsOverLimit(resultColumns)) continue;
            break;
        }
        wildcardsRemover.checkIfSoffsetIsExceeded(resultColumns);
        queryOperator.getSelectComponent().setResultColumns(resultColumns);
        if (groupByLevelController != null) {
            queryOperator.getSpecialClauseComponent().setGroupByLevelController(groupByLevelController);
        }
    }

    private void concatFilterAndRemoveWildcards(QueryOperator queryOperator) throws LogicalOptimizeException {
        WhereComponent whereComponent = queryOperator.getWhereComponent();
        if (whereComponent == null) {
            return;
        }
        HashSet<PartialPath> filterPaths = new HashSet<PartialPath>();
        whereComponent.setFilterOperator(this.concatFilterAndRemoveWildcards(queryOperator.getFromComponent().getPrefixPaths(), whereComponent.getFilterOperator(), filterPaths, queryOperator.isPrefixMatchPath()));
        whereComponent.getFilterOperator().setPathSet(filterPaths);
    }

    private FilterOperator concatFilterAndRemoveWildcards(List<PartialPath> fromPaths, FilterOperator operator, Set<PartialPath> filterPaths, boolean isPrefixMatch) throws LogicalOptimizeException {
        if (!operator.isLeaf()) {
            ArrayList<FilterOperator> newFilterList = new ArrayList<FilterOperator>();
            for (FilterOperator child : operator.getChildren()) {
                newFilterList.add(this.concatFilterAndRemoveWildcards(fromPaths, child, filterPaths, isPrefixMatch));
            }
            operator.setChildren(newFilterList);
            return operator;
        }
        FunctionOperator functionOperator = (FunctionOperator)operator;
        PartialPath filterPath = functionOperator.getSinglePath();
        ArrayList<PartialPath> concatPaths = new ArrayList<PartialPath>();
        if (SQLConstant.isReservedPath(filterPath)) {
            filterPaths.add(filterPath);
            return operator;
        }
        if (filterPath.getFirstNode().startsWith("root")) {
            concatPaths.add(filterPath);
        } else {
            fromPaths.forEach(fromPath -> concatPaths.add(fromPath.concatPath(filterPath)));
        }
        List<PartialPath> noStarPaths = this.removeWildcardsInConcatPaths(concatPaths, isPrefixMatch);
        filterPaths.addAll(noStarPaths);
        if (noStarPaths.size() == 1) {
            functionOperator.setSinglePath(noStarPaths.get(0));
            return operator;
        }
        return this.constructBinaryFilterTreeWithAnd(noStarPaths, operator);
    }

    private FilterOperator constructBinaryFilterTreeWithAnd(List<PartialPath> noStarPaths, FilterOperator operator) throws LogicalOptimizeException {
        FilterOperator filterBinaryTree;
        FilterOperator currentNode = filterBinaryTree = new FilterOperator(FilterConstant.FilterType.KW_AND);
        for (int i = 0; i < noStarPaths.size(); ++i) {
            if (i > 0 && i < noStarPaths.size() - 1) {
                FilterOperator newInnerNode = new FilterOperator(FilterConstant.FilterType.KW_AND);
                currentNode.addChildOperator(newInnerNode);
                currentNode = newInnerNode;
            }
            try {
                if (operator instanceof InOperator) {
                    currentNode.addChildOperator(new InOperator(operator.getFilterType(), noStarPaths.get(i), ((InOperator)operator).getNot(), ((InOperator)operator).getValues()));
                    continue;
                }
                if (operator instanceof LikeOperator) {
                    currentNode.addChildOperator(new LikeOperator(operator.getFilterType(), noStarPaths.get(i), ((LikeOperator)operator).getValue()));
                    continue;
                }
                if (operator instanceof RegexpOperator) {
                    currentNode.addChildOperator(new RegexpOperator(operator.getFilterType(), noStarPaths.get(i), ((RegexpOperator)operator).getValue()));
                    continue;
                }
                currentNode.addChildOperator(new BasicFunctionOperator(operator.getFilterType(), noStarPaths.get(i), ((BasicFunctionOperator)operator).getValue()));
                continue;
            }
            catch (SQLParserException e) {
                throw new LogicalOptimizeException(e.getMessage());
            }
        }
        return filterBinaryTree;
    }

    private List<PartialPath> removeWildcardsInConcatPaths(List<PartialPath> originalPaths, boolean isPrefixMatch) throws LogicalOptimizeException {
        HashSet actualPaths = new HashSet();
        try {
            for (PartialPath originalPath : originalPaths) {
                List all = (List)IoTDB.metaManager.getMeasurementPathsWithAlias((PartialPath)originalPath, (int)0, (int)0, (boolean)isPrefixMatch).left;
                if (all.isEmpty()) {
                    throw new LogicalOptimizeException(String.format("Unknown time series %s in `where clause`", originalPath));
                }
                actualPaths.addAll(all);
            }
        }
        catch (MetadataException e) {
            throw new LogicalOptimizeException("error when remove star: " + e.getMessage());
        }
        return new ArrayList<PartialPath>(actualPaths);
    }

    public static <T> void cartesianProduct(List<List<T>> dimensionValue, List<List<T>> resultList, int layer, List<T> currentList) {
        block7: {
            block6: {
                if (layer >= dimensionValue.size() - 1) break block6;
                if (dimensionValue.get(layer).isEmpty()) {
                    ConcatPathOptimizer.cartesianProduct(dimensionValue, resultList, layer + 1, currentList);
                } else {
                    for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                        ArrayList<T> list = new ArrayList<T>(currentList);
                        list.add(dimensionValue.get(layer).get(i));
                        ConcatPathOptimizer.cartesianProduct(dimensionValue, resultList, layer + 1, list);
                    }
                }
                break block7;
            }
            if (layer != dimensionValue.size() - 1) break block7;
            if (dimensionValue.get(layer).isEmpty()) {
                resultList.add(currentList);
            } else {
                for (int i = 0; i < dimensionValue.get(layer).size(); ++i) {
                    ArrayList<T> list = new ArrayList<T>(currentList);
                    list.add(dimensionValue.get(layer).get(i));
                    resultList.add(list);
                }
            }
        }
    }
}

