/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FirstValueAggrResult
extends AggregateResult {
    protected long timestamp = Long.MAX_VALUE;

    public FirstValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.FIRST_VALUE);
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.timestamp = Long.MAX_VALUE;
    }

    @Override
    public Object getResult() {
        return this.hasCandidateResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        if (this.hasFinalResult()) {
            return;
        }
        Serializable firstVal = statistics.getFirstValue();
        this.setValue(firstVal);
        this.timestamp = statistics.getStartTime();
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        if (this.hasFinalResult()) {
            return;
        }
        if (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() < maxBound && batchIterator.currentTime() >= minBound) {
            this.setValue(batchIterator.currentValue());
            this.timestamp = batchIterator.currentTime();
            batchIterator.next();
        }
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        int timeLength;
        if (this.hasFinalResult()) {
            return;
        }
        long[] timesForFirstValue = new long[100];
        for (int currentPos = 0; currentPos < length; currentPos += timeLength) {
            timeLength = Math.min(length - currentPos, 100);
            System.arraycopy(timestamps, currentPos, timesForFirstValue, 0, timeLength);
            Object[] values = dataReader.getValuesInTimestamps(timesForFirstValue, timeLength);
            for (int i = 0; i < timeLength; ++i) {
                if (values[i] == null) continue;
                this.setValue(values[i]);
                this.timestamp = timesForFirstValue[i];
                return;
            }
        }
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        if (this.hasFinalResult()) {
            return;
        }
        if (valueIterator.hasNext()) {
            this.timestamp = timestamps[valueIterator.getCurPos()];
            this.setValue(valueIterator.next());
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.hasCandidateResult;
    }

    @Override
    public void merge(AggregateResult another) {
        FirstValueAggrResult anotherFirst = (FirstValueAggrResult)another;
        if (this.getValue() == null || this.timestamp > anotherFirst.timestamp) {
            this.setValue(anotherFirst.getValue());
            this.timestamp = anotherFirst.timestamp;
        }
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
        this.timestamp = buffer.getLong();
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.timestamp, (OutputStream)outputStream);
    }
}

