/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;

public class MaxValueAggrResult
extends AggregateResult {
    public MaxValueAggrResult(TSDataType dataType) {
        super(dataType, AggregationType.MAX_VALUE);
        this.reset();
    }

    @Override
    public Object getResult() {
        return this.hasCandidateResult() ? this.getValue() : null;
    }

    @Override
    public void updateResultFromStatistics(Statistics statistics) {
        Comparable maxVal = (Comparable)((Object)statistics.getMaxValue());
        this.updateResult(maxVal);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator) {
        this.updateResultFromPageData(batchIterator, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public void updateResultFromPageData(IBatchDataIterator batchIterator, long minBound, long maxBound) {
        Comparable maxVal = null;
        while (batchIterator.hasNext(minBound, maxBound) && batchIterator.currentTime() < maxBound && batchIterator.currentTime() >= minBound) {
            if (maxVal == null || maxVal.compareTo(batchIterator.currentValue()) < 0) {
                maxVal = (Comparable)batchIterator.currentValue();
            }
            batchIterator.next();
        }
        this.updateResult(maxVal);
    }

    @Override
    public void updateResultUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable maxVal = null;
        Object[] values = dataReader.getValuesInTimestamps(timestamps, length);
        for (int i = 0; i < length; ++i) {
            if (values[i] == null || maxVal != null && maxVal.compareTo(values[i]) >= 0) continue;
            maxVal = (Comparable)values[i];
        }
        this.updateResult(maxVal);
    }

    @Override
    public void updateResultUsingValues(long[] timestamps, int length, ValueIterator valueIterator) {
        Comparable maxVal = null;
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (maxVal != null && maxVal.compareTo(value) >= 0) continue;
            maxVal = (Comparable)value;
        }
        this.updateResult(maxVal);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void merge(AggregateResult another) {
        this.updateResult((Comparable)another.getResult());
    }

    @Override
    protected void deserializeSpecificFields(ByteBuffer buffer) {
    }

    @Override
    protected void serializeSpecificFields(OutputStream outputStream) {
    }

    private void updateResult(Comparable<Object> maxVal) {
        if (maxVal == null) {
            return;
        }
        if (!this.hasCandidateResult() || maxVal.compareTo(this.getValue()) > 0) {
            this.setValue(maxVal);
        }
    }
}

