/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.expression.unary;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.db.query.expression.Expression;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.layer.IntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.LayerMemoryAssigner;
import org.apache.iotdb.db.query.udf.core.layer.RawQueryInputLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnMultiReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.layer.SingleInputColumnSingleReferenceIntermediateLayer;
import org.apache.iotdb.db.query.udf.core.transformer.ArithmeticNegationTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class NegationExpression
extends Expression {
    protected Expression expression;

    public NegationExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.expression.isConstantOperand();
    }

    @Override
    public List<Expression> getExpressions() {
        return Collections.singletonList(this.expression);
    }

    @Override
    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return !this.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public boolean isUserDefinedAggregationFunctionExpression() {
        return this.expression.isUserDefinedAggregationFunctionExpression() || this.expression.isPlainAggregationFunctionExpression();
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        ArrayList<Expression> resultExpressionsForRecursion = new ArrayList<Expression>();
        this.expression.concat(prefixPaths, resultExpressionsForRecursion);
        for (Expression resultExpression : resultExpressionsForRecursion) {
            resultExpressions.add(new NegationExpression(resultExpression));
        }
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        ArrayList<Expression> resultExpressionsForRecursion = new ArrayList<Expression>();
        this.expression.removeWildcards(wildcardsRemover, resultExpressionsForRecursion);
        for (Expression resultExpression : resultExpressionsForRecursion) {
            resultExpressions.add(new NegationExpression(resultExpression));
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        this.expression.collectPaths(pathSet);
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        this.expression.constructUdfExecutors(expressionName2Executor, zoneId);
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        this.expression.updateStatisticsForMemoryAssigner(memoryAssigner);
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFPlan udtfPlan, RawQueryInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            float memoryBudgetInMB = memoryAssigner.assign();
            IntermediateLayer parentLayerPointReader = this.expression.constructIntermediateLayer(queryId, udtfPlan, rawTimeSeriesInputLayer, expressionIntermediateLayerMap, expressionDataTypeMap, memoryAssigner);
            ArithmeticNegationTransformer transformer = new ArithmeticNegationTransformer(parentLayerPointReader.constructPointReader());
            expressionDataTypeMap.put(this, transformer.getDataType());
            expressionIntermediateLayerMap.put(this, memoryAssigner.getReference(this) == 1 || this.isConstantOperand() ? new SingleInputColumnSingleReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer) : new SingleInputColumnMultiReferenceIntermediateLayer(this, queryId, memoryBudgetInMB, transformer));
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public String getExpressionStringInternal() {
        return "-" + this.expression.toString();
    }
}

