/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.metrics.Metric;
import org.apache.iotdb.db.service.metrics.MetricsServiceMBean;
import org.apache.iotdb.db.service.metrics.Tag;
import org.apache.iotdb.metrics.MetricService;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.config.ReloadLevel;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsService
extends MetricService
implements MetricsServiceMBean,
IService {
    private static final Logger logger = LoggerFactory.getLogger(MetricsService.class);
    private final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", this.getID().getJmxName());

    private MetricsService() {
    }

    @Override
    public void start() throws StartupException {
        try {
            if (this.isEnable()) {
                logger.info("Start to start metric Service.");
                JMXService.registerMBean(MetricsService.getInstance(), this.mbeanName);
                this.startService();
                logger.info("Finish start metric Service");
            }
        }
        catch (Exception e) {
            logger.error("Failed to start {} because: ", (Object)this.getID().getName(), (Object)e);
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
        if (this.isEnable()) {
            logger.info("Stop metric Service.");
            this.stopService();
            JMXService.deregisterMBean(this.mbeanName);
            logger.info("Finish stop metric Service");
        }
    }

    @Override
    public void restartService() throws StartupException {
        this.stopService();
        this.startService();
    }

    public void collectFileSystemInfo() {
        logger.info("start collecting fileSize and fileCount of wal/seq/unseq");
        String walDir = DirectoryManager.getInstance().getWALFolder();
        this.metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)walDir, org.apache.iotdb.db.utils.FileUtils::getDirSize, new String[]{Tag.NAME.toString(), "wal"});
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        this.metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "sequence";
            return org.apache.iotdb.db.utils.FileUtils.getDirSize(dir);
        }).sum(), new String[]{Tag.NAME.toString(), "seq"});
        this.metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "unsequence";
            return org.apache.iotdb.db.utils.FileUtils.getDirSize(dir);
        }).sum(), new String[]{Tag.NAME.toString(), "unseq"});
        this.metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)walDir, value -> {
            File walFolder = new File((String)value);
            if (walFolder.exists() && walFolder.isDirectory()) {
                return FileUtils.listFiles((File)new File((String)value), null, (boolean)true).size();
            }
            return 0L;
        }, new String[]{Tag.NAME.toString(), "wal"});
        this.metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "sequence";
            return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
        }).sum(), new String[]{Tag.NAME.toString(), "seq"});
        this.metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "unsequence";
            return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
        }).sum(), new String[]{Tag.NAME.toString(), "unseq"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadProperties(ReloadLevel reloadLevel) {
        logger.info("Reload properties of metric service");
        MetricsService metricsService = this;
        synchronized (metricsService) {
            try {
                switch (reloadLevel) {
                    case START_METRIC: {
                        this.isEnableMetric = true;
                        this.start();
                        break;
                    }
                    case STOP_METRIC: {
                        this.stop();
                        this.isEnableMetric = false;
                        break;
                    }
                    case RESTART_METRIC: {
                        this.stop();
                        this.isEnableMetric = true;
                        this.start();
                        break;
                    }
                    case RESTART_REPORTER: {
                        this.compositeReporter.restartAll();
                        logger.info("Finish restart metric reporters.");
                        break;
                    }
                    case NOTHING: {
                        logger.debug("There are nothing change in metric module.");
                        break;
                    }
                }
            }
            catch (StartupException startupException) {
                logger.error("Failed to start metric when reload properties");
            }
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.METRICS_SERVICE;
    }

    public static MetricsService getInstance() {
        return MetricsServiceHolder.INSTANCE;
    }

    private static class MetricsServiceHolder {
        private static final MetricsService INSTANCE = new MetricsService();

        private MetricsServiceHolder() {
        }
    }
}

