/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.comparator.DefaultCompactionTaskComparatorImpl;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.service.metrics.recorder.CompactionMetricsRecorder;
import org.apache.iotdb.db.utils.datastructure.FixedPriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionTaskManager
implements IService {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private static final long MAX_WAITING_TIME = 120000L;
    private static final CompactionTaskManager INSTANCE = new CompactionTaskManager();
    private WrappedThreadPoolExecutor taskExecutionPool;
    private WrappedThreadPoolExecutor subCompactionTaskExecutionPool;
    public static volatile AtomicInteger currentTaskNum = new AtomicInteger(0);
    private FixedPriorityBlockingQueue<AbstractCompactionTask> candidateCompactionTaskQueue = new FixedPriorityBlockingQueue<AbstractCompactionTask>(1024, new DefaultCompactionTaskComparatorImpl());
    private Map<String, Map<AbstractCompactionTask, Future<CompactionTaskSummary>>> storageGroupTasks = new HashMap<String, Map<AbstractCompactionTask, Future<CompactionTaskSummary>>>();
    private ScheduledExecutorService compactionTaskSubmissionThreadPool;
    private final long TASK_SUBMIT_INTERVAL = IoTDBDescriptor.getInstance().getConfig().getCompactionSubmissionIntervalInMs();
    private final RateLimiter mergeWriteRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    public static CompactionTaskManager getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
        if (this.taskExecutionPool == null && IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() > 0 && (this.config.isEnableSeqSpaceCompaction() || this.config.isEnableUnseqSpaceCompaction() || this.config.isEnableCrossSpaceCompaction())) {
            this.taskExecutionPool = (WrappedThreadPoolExecutor)IoTDBThreadPoolFactory.newFixedThreadPool((int)IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread(), (String)ThreadName.COMPACTION_SERVICE.getName());
            this.subCompactionTaskExecutionPool = (WrappedThreadPoolExecutor)IoTDBThreadPoolFactory.newFixedThreadPool((int)(IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() * IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum()), (String)ThreadName.COMPACTION_SUB_SERVICE.getName());
            currentTaskNum = new AtomicInteger(0);
            this.compactionTaskSubmissionThreadPool = IoTDBThreadPoolFactory.newScheduledThreadPool((int)1, (String)ThreadName.COMPACTION_SERVICE.getName());
            this.candidateCompactionTaskQueue.regsitPollLastHook(AbstractCompactionTask::resetCompactionCandidateStatusForAllSourceFiles);
            this.candidateCompactionTaskQueue.regsitPollLastHook(x -> CompactionMetricsRecorder.recordTaskInfo(x, CompactionTaskStatus.POLL_FROM_QUEUE, this.candidateCompactionTaskQueue.size()));
            ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.compactionTaskSubmissionThreadPool, this::submitTaskFromTaskQueue, (long)this.TASK_SUBMIT_INTERVAL, (long)this.TASK_SUBMIT_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        logger.info("Compaction task manager started.");
    }

    public void stop() {
        if (this.taskExecutionPool != null) {
            this.taskExecutionPool.shutdownNow();
            this.compactionTaskSubmissionThreadPool.shutdownNow();
            logger.info("Waiting for task taskExecutionPool to shut down");
            this.waitTermination();
            this.storageGroupTasks.clear();
            this.candidateCompactionTaskQueue.clear();
        }
    }

    public void waitAndStop(long milliseconds) {
        if (this.taskExecutionPool != null) {
            this.awaitTermination((ExecutorService)this.taskExecutionPool, milliseconds);
            this.awaitTermination(this.compactionTaskSubmissionThreadPool, milliseconds);
            logger.info("Waiting for task taskExecutionPool to shut down in {} ms", (Object)milliseconds);
            this.waitTermination();
            this.storageGroupTasks.clear();
        }
    }

    public void waitAllCompactionFinish() {
        long sleepingStartTime = 0L;
        if (this.taskExecutionPool != null) {
            while (this.taskExecutionPool.getActiveCount() > 0 || this.taskExecutionPool.getQueue().size() > 0) {
                try {
                    Thread.sleep(200L);
                    if ((sleepingStartTime += 200L) % 10000L == 0L) {
                        logger.warn("Has waiting {} seconds for all compaction task finish", (Object)(sleepingStartTime / 1000L));
                    }
                    if (sleepingStartTime < 120000L) continue;
                    return;
                }
                catch (InterruptedException e) {
                    logger.error("thread interrupted while waiting for compaction to end", (Throwable)e);
                    return;
                }
            }
            this.storageGroupTasks.clear();
            this.candidateCompactionTaskQueue.clear();
            logger.info("All compaction task finish");
        }
    }

    private void waitTermination() {
        long startTime = System.currentTimeMillis();
        while (!this.taskExecutionPool.isTerminated()) {
            int timeMillis = 0;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            long time = System.currentTimeMillis() - startTime;
            if ((timeMillis += 200) % 60000 != 0) continue;
            logger.info("CompactionManager has wait for {} seconds to stop", (Object)(time / 1000L));
        }
        this.taskExecutionPool = null;
        this.storageGroupTasks.clear();
        logger.info("CompactionManager stopped");
    }

    private void awaitTermination(ExecutorService service, long milliseconds) {
        try {
            service.shutdown();
            service.awaitTermination(milliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("CompactionThreadPool can not be closed in {} ms", (Object)milliseconds);
            Thread.currentThread().interrupt();
        }
        service.shutdownNow();
    }

    public ServiceType getID() {
        return ServiceType.COMPACTION_SERVICE;
    }

    public synchronized boolean addTaskToWaitingQueue(AbstractCompactionTask compactionTask) throws InterruptedException {
        if (!this.candidateCompactionTaskQueue.contains(compactionTask) && !this.isTaskRunning(compactionTask)) {
            compactionTask.setSourceFilesToCompactionCandidate();
            this.candidateCompactionTaskQueue.put(compactionTask);
            CompactionMetricsRecorder.recordTaskInfo(compactionTask, CompactionTaskStatus.ADD_TO_QUEUE, this.candidateCompactionTaskQueue.size());
            return true;
        }
        return false;
    }

    private boolean isTaskRunning(AbstractCompactionTask task) {
        String storageGroupName = task.getFullStorageGroupName();
        return this.storageGroupTasks.computeIfAbsent(storageGroupName, x -> new HashMap()).containsKey(task);
    }

    public synchronized void submitTaskFromTaskQueue() {
        try {
            while (currentTaskNum.get() < IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() && !this.candidateCompactionTaskQueue.isEmpty()) {
                AbstractCompactionTask task = this.candidateCompactionTaskQueue.take();
                CompactionMetricsRecorder.recordTaskInfo(task, CompactionTaskStatus.POLL_FROM_QUEUE, this.candidateCompactionTaskQueue.size());
                if (task != null && task.checkValidAndSetMerging()) {
                    this.submitTask(task);
                    CompactionMetricsRecorder.recordTaskInfo(task, CompactionTaskStatus.READY_TO_EXECUTE, currentTaskNum.get());
                    continue;
                }
                logger.warn("A task {} is not submitted", (Object)task);
            }
        }
        catch (InterruptedException e) {
            logger.error("Exception occurs while submitting compaction task", (Throwable)e);
        }
    }

    public RateLimiter getMergeWriteRateLimiter() {
        this.setWriteMergeRate(IoTDBDescriptor.getInstance().getConfig().getCompactionWriteThroughputMbPerSec());
        return this.mergeWriteRateLimiter;
    }

    private void setWriteMergeRate(double throughoutMbPerSec) {
        double throughout = throughoutMbPerSec * 1024.0 * 1024.0;
        if (throughout == 0.0) {
            throughout = Double.MAX_VALUE;
        }
        if (this.mergeWriteRateLimiter.getRate() != throughout) {
            this.mergeWriteRateLimiter.setRate(throughout);
        }
    }

    public static void mergeRateLimiterAcquire(RateLimiter limiter, long bytesLength) {
        while (bytesLength >= Integer.MAX_VALUE) {
            limiter.acquire(Integer.MAX_VALUE);
            bytesLength -= Integer.MAX_VALUE;
        }
        if (bytesLength > 0L) {
            limiter.acquire((int)bytesLength);
        }
    }

    public synchronized void removeRunningTaskFuture(AbstractCompactionTask task) {
        String storageGroupName = task.getFullStorageGroupName();
        if (this.storageGroupTasks.containsKey(storageGroupName)) {
            this.storageGroupTasks.get(storageGroupName).remove(task);
        }
        CompactionMetricsRecorder.recordTaskInfo(task, CompactionTaskStatus.FINISHED, currentTaskNum.get());
    }

    public synchronized Future<CompactionTaskSummary> submitTask(AbstractCompactionTask compactionTask) throws RejectedExecutionException {
        if (this.taskExecutionPool != null && !this.taskExecutionPool.isShutdown()) {
            Future future = this.taskExecutionPool.submit((Callable)compactionTask);
            this.storageGroupTasks.computeIfAbsent(compactionTask.getFullStorageGroupName(), x -> new HashMap()).put(compactionTask, future);
            return future;
        }
        logger.warn("A CompactionTask failed to be submitted to CompactionTaskManager because {}", (Object)(this.taskExecutionPool == null ? "taskExecutionPool is null" : "taskExecutionPool is terminated"));
        return null;
    }

    public synchronized Future<Void> submitSubTask(Callable<Void> subCompactionTask) {
        if (this.subCompactionTaskExecutionPool != null && !this.subCompactionTaskExecutionPool.isShutdown()) {
            return this.subCompactionTaskExecutionPool.submit(subCompactionTask);
        }
        return null;
    }

    public synchronized List<AbstractCompactionTask> abortCompaction(String storageGroupName) {
        ArrayList<AbstractCompactionTask> compactionTaskOfCurSG = new ArrayList<AbstractCompactionTask>();
        if (this.storageGroupTasks.containsKey(storageGroupName)) {
            for (Map.Entry<AbstractCompactionTask, Future<CompactionTaskSummary>> taskFutureEntry : this.storageGroupTasks.get(storageGroupName).entrySet()) {
                taskFutureEntry.getValue().cancel(true);
                compactionTaskOfCurSG.add(taskFutureEntry.getKey());
            }
        }
        this.storageGroupTasks.remove(storageGroupName);
        this.candidateCompactionTaskQueue.clear();
        return compactionTaskOfCurSG;
    }

    public boolean isAnyTaskInListStillRunning(List<AbstractCompactionTask> compactionTasks) {
        boolean anyTaskRunning = false;
        for (AbstractCompactionTask task : compactionTasks) {
            anyTaskRunning = anyTaskRunning || task.isTaskRan() && !task.isTaskFinished();
        }
        return anyTaskRunning;
    }

    public int getExecutingTaskCount() {
        return this.taskExecutionPool.getActiveCount() + this.taskExecutionPool.getQueue().size();
    }

    public int getTotalTaskCount() {
        return this.getExecutingTaskCount() + this.candidateCompactionTaskQueue.size();
    }

    public synchronized List<AbstractCompactionTask> getRunningCompactionTaskList() {
        ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
        for (Map<AbstractCompactionTask, Future<CompactionTaskSummary>> taskFutureMap : this.storageGroupTasks.values()) {
            tasks.addAll(taskFutureMap.keySet());
        }
        return tasks;
    }

    public long getFinishTaskNum() {
        return this.taskExecutionPool.getCompletedTaskCount();
    }

    public void restart() throws InterruptedException {
        if (IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() > 0) {
            if (this.taskExecutionPool != null) {
                this.taskExecutionPool.shutdownNow();
                if (!this.taskExecutionPool.awaitTermination(120000L, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException("Has been waiting over 120 seconds for all compaction tasks to finish.");
                }
            }
            if (this.subCompactionTaskExecutionPool != null) {
                this.subCompactionTaskExecutionPool.shutdownNow();
                if (!this.subCompactionTaskExecutionPool.awaitTermination(120000L, TimeUnit.MILLISECONDS)) {
                    throw new InterruptedException("Has been waiting over 120 seconds for all sub compaction tasks to finish.");
                }
            }
            if (this.subCompactionTaskExecutionPool != null) {
                this.subCompactionTaskExecutionPool.shutdownNow();
                if (!this.subCompactionTaskExecutionPool.awaitTermination(120000L, TimeUnit.MILLISECONDS)) {
                    throw new RuntimeException("Failed to shutdown subCompactionTaskExecutionPool");
                }
            }
            this.taskExecutionPool = (WrappedThreadPoolExecutor)IoTDBThreadPoolFactory.newFixedThreadPool((int)IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread(), (String)ThreadName.COMPACTION_SERVICE.getName());
            this.subCompactionTaskExecutionPool = (WrappedThreadPoolExecutor)IoTDBThreadPoolFactory.newFixedThreadPool((int)(IoTDBDescriptor.getInstance().getConfig().getConcurrentCompactionThread() * IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum()), (String)ThreadName.COMPACTION_SUB_SERVICE.getName());
            this.compactionTaskSubmissionThreadPool = IoTDBThreadPoolFactory.newScheduledThreadPool((int)1, (String)ThreadName.COMPACTION_SERVICE.getName());
            this.candidateCompactionTaskQueue.regsitPollLastHook(AbstractCompactionTask::resetCompactionCandidateStatusForAllSourceFiles);
            this.candidateCompactionTaskQueue.clear();
        }
        currentTaskNum = new AtomicInteger(0);
        logger.info("Compaction task manager started.");
    }

    public void clearCandidateQueue() {
        this.candidateCompactionTaskQueue.clear();
    }
}

