/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.cross.AbstractCrossSpaceEstimator;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.RewriteCompactionFileSelector;
import org.apache.iotdb.db.engine.compaction.cross.utils.IFileQueryMemMeasurement;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InplaceCompactionEstimator
extends AbstractCrossSpaceEstimator {
    private static final Logger logger = LoggerFactory.getLogger(RewriteCompactionFileSelector.class);
    private static final String LOG_FILE_COST = "Memory cost of file {} is {}";
    private boolean tightEstimate = false;
    private long maxSeqFileCost = 0L;
    private final int concurrentSeriesNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();
    private final Map<TsFileResource, Long> fileMetaSizeMap = new HashMap<TsFileResource, Long>();
    private final Map<TsFileResource, Long> maxSeriesQueryCostMap = new HashMap<TsFileResource, Long>();

    @Override
    public long estimateCrossCompactionMemory(List<TsFileResource> seqResources, TsFileResource unseqResource) throws IOException {
        if (this.tightEstimate) {
            return this.calculateTightMemoryCost(unseqResource, seqResources);
        }
        return this.calculateLooseMemoryCost(unseqResource, seqResources);
    }

    private long calculateMemoryCost(TsFileResource unseqResource, List<TsFileResource> seqResources, IFileQueryMemMeasurement unseqMeasurement, IFileQueryMemMeasurement seqMeasurement) throws IOException {
        long cost = 0L;
        Long fileCost = unseqMeasurement.measure(unseqResource);
        cost += fileCost.longValue();
        for (TsFileResource seqFile : seqResources) {
            fileCost = seqMeasurement.measure(seqFile);
            if (fileCost > this.maxSeqFileCost) {
                cost -= this.maxSeqFileCost;
                cost += fileCost.longValue();
                this.maxSeqFileCost = fileCost;
            }
            cost += this.calculateMetadataSize(seqFile);
        }
        return cost;
    }

    private long calculateLooseMemoryCost(TsFileResource unseqResource, List<TsFileResource> seqResources) throws IOException {
        return this.calculateMemoryCost(unseqResource, seqResources, TsFileResource::getTsFileSize, this::calculateMetadataSize);
    }

    private long calculateTightMemoryCost(TsFileResource unseqResource, List<TsFileResource> seqResources) throws IOException {
        return this.calculateMemoryCost(unseqResource, seqResources, this::calculateTightUnseqMemoryCost, this::calculateTightSeqMemoryCost);
    }

    private long calculateMetadataSize(TsFileResource seqFile) throws IOException {
        Long cost = this.fileMetaSizeMap.get(seqFile);
        if (cost == null) {
            cost = this.getFileReader(seqFile).getFileMetadataSize();
            this.fileMetaSizeMap.put(seqFile, cost);
            logger.debug(LOG_FILE_COST, (Object)seqFile, (Object)cost);
        }
        return cost;
    }

    private long calculateTightFileMemoryCost(TsFileResource seqFile, IFileQueryMemMeasurement measurement) throws IOException {
        Long cost = this.maxSeriesQueryCostMap.get(seqFile);
        if (cost == null) {
            long[] chunkNums = this.findTotalAndLargestSeriesChunkNum(seqFile, this.getFileReader(seqFile));
            long totalChunkNum = chunkNums[0];
            long maxChunkNum = chunkNums[1];
            cost = measurement.measure(seqFile) * maxChunkNum / totalChunkNum;
            this.maxSeriesQueryCostMap.put(seqFile, cost);
            logger.debug(LOG_FILE_COST, (Object)seqFile, (Object)cost);
        }
        return cost;
    }

    private long calculateTightSeqMemoryCost(TsFileResource seqFile) throws IOException {
        long singleSeriesCost = this.calculateTightFileMemoryCost(seqFile, this::calculateMetadataSize);
        long multiSeriesCost = (long)this.concurrentSeriesNum * singleSeriesCost;
        long maxCost = this.calculateMetadataSize(seqFile);
        return Math.min(multiSeriesCost, maxCost);
    }

    private long calculateTightUnseqMemoryCost(TsFileResource unseqFile) throws IOException {
        long singleSeriesCost = this.calculateTightFileMemoryCost(unseqFile, TsFileResource::getTsFileSize);
        long multiSeriesCost = (long)this.concurrentSeriesNum * singleSeriesCost;
        long maxCost = unseqFile.getTsFileSize();
        return Math.min(multiSeriesCost, maxCost);
    }

    private long[] findTotalAndLargestSeriesChunkNum(TsFileResource tsFileResource, TsFileSequenceReader sequenceReader) throws IOException {
        long totalChunkNum = 0L;
        long maxChunkNum = Long.MIN_VALUE;
        List paths = sequenceReader.getAllPaths();
        for (Path path : paths) {
            List chunkMetadataList = sequenceReader.getChunkMetadataList(path, true);
            totalChunkNum += (long)chunkMetadataList.size();
            maxChunkNum = (long)chunkMetadataList.size() > maxChunkNum ? (long)chunkMetadataList.size() : maxChunkNum;
        }
        logger.debug("In file {}, total chunk num {}, series max chunk num {}", new Object[]{tsFileResource, totalChunkNum, maxChunkNum});
        return new long[]{totalChunkNum, maxChunkNum};
    }

    public void setTightEstimate(boolean tightEstimate) {
        this.tightEstimate = tightEstimate;
    }
}

