/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.selectinto;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.selectinto.InsertTabletPlanGenerator;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertTabletPlansIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertTabletPlansIterator.class);
    private static final Pattern LEVELED_PATH_NODE_PATTERN = Pattern.compile("\\$\\{\\w+}");
    private final QueryPlan queryPlan;
    private final QueryDataSet queryDataSet;
    private final PartialPath fromPath;
    private final List<PartialPath> intoPaths;
    private final boolean isIntoPathsAligned;
    private final int tabletRowLimit;
    private InsertTabletPlanGenerator[] insertTabletPlanGenerators;

    public InsertTabletPlansIterator(QueryPlan queryPlan, QueryDataSet queryDataSet, PartialPath fromPath, List<PartialPath> intoPaths, boolean isIntoPathsAligned) throws IllegalPathException {
        this.queryPlan = queryPlan;
        this.queryDataSet = queryDataSet;
        this.fromPath = fromPath;
        this.intoPaths = intoPaths;
        this.isIntoPathsAligned = isIntoPathsAligned;
        this.tabletRowLimit = IoTDBDescriptor.getInstance().getConfig().getSelectIntoInsertTabletPlanRowLimit();
        this.generateActualIntoPaths();
        this.constructInsertTabletPlanGenerators();
    }

    private void generateActualIntoPaths() throws IllegalPathException {
        for (int i = 0; i < this.intoPaths.size(); ++i) {
            this.intoPaths.set(i, this.generateActualIntoPath(i));
        }
    }

    private PartialPath generateActualIntoPath(int index) throws IllegalPathException {
        String[] nodes = this.fromPath.getNodes();
        StringBuffer sb = new StringBuffer();
        Matcher m = LEVELED_PATH_NODE_PATTERN.matcher(this.intoPaths.get(index).getFullPath());
        while (m.find()) {
            String param = m.group();
            String value = nodes[Integer.parseInt(param.substring(2, param.length() - 1).trim())];
            m.appendReplacement(sb, value == null ? "" : value);
        }
        m.appendTail(sb);
        return new PartialPath(sb.toString());
    }

    private void constructInsertTabletPlanGenerators() {
        Map<String, Integer> sourcePathToQueryDataSetIndex = this.queryPlan.getPathToIndex();
        List<String> sourcePaths = this.findSourcePaths();
        HashMap<String, InsertTabletPlanGenerator> deviceToPlanGeneratorMap = new HashMap<String, InsertTabletPlanGenerator>();
        int intoPathsSize = this.intoPaths.size();
        for (int i = 0; i < intoPathsSize; ++i) {
            String device = this.intoPaths.get(i).getDevice();
            if (!deviceToPlanGeneratorMap.containsKey(device)) {
                deviceToPlanGeneratorMap.put(device, new InsertTabletPlanGenerator(device, this.tabletRowLimit, this.isIntoPathsAligned));
            }
            ((InsertTabletPlanGenerator)deviceToPlanGeneratorMap.get(device)).collectTargetPathInformation(this.intoPaths.get(i).getMeasurement(), sourcePathToQueryDataSetIndex.get(sourcePaths.get(i)));
        }
        this.insertTabletPlanGenerators = deviceToPlanGeneratorMap.values().toArray(new InsertTabletPlanGenerator[0]);
    }

    private List<String> findSourcePaths() {
        List<ResultColumn> queryPlanColumns = this.queryPlan.getResultColumns();
        List queryDataSetPaths = this.queryDataSet.getPaths();
        Map<String, Integer> sourcePathToQueryDataSetIndex = this.queryPlan.getPathToIndex();
        ArrayList<String> sourcePaths = new ArrayList<String>(Math.max(queryPlanColumns.size(), queryDataSetPaths.size()));
        if (queryPlanColumns.size() == this.intoPaths.size()) {
            for (ResultColumn resultColumn : queryPlanColumns) {
                String path = resultColumn.getResultColumnName();
                if (!sourcePathToQueryDataSetIndex.containsKey(path)) {
                    sourcePaths.clear();
                    break;
                }
                sourcePaths.add(path);
            }
        }
        if (sourcePaths.isEmpty() && queryDataSetPaths.size() == this.intoPaths.size()) {
            for (Path path : queryDataSetPaths) {
                if (!sourcePathToQueryDataSetIndex.containsKey(path.getFullPath())) {
                    sourcePaths.clear();
                    break;
                }
                sourcePaths.add(path.getFullPath());
            }
        }
        if (sourcePaths.isEmpty()) {
            LOGGER.warn("select into: sourcePaths.isEmpty()");
        }
        return sourcePaths;
    }

    public boolean hasNext() throws IOException {
        return this.queryDataSet.hasNext();
    }

    public List<InsertTabletPlan> next() throws IOException, IllegalPathException {
        for (InsertTabletPlanGenerator insertTabletPlanGenerator : this.insertTabletPlanGenerators) {
            insertTabletPlanGenerator.internallyConstructNewPlan();
        }
        this.collectRowRecordIntoInsertTabletPlanGenerators();
        ArrayList<InsertTabletPlan> insertTabletPlans = new ArrayList<InsertTabletPlan>();
        for (InsertTabletPlanGenerator insertTabletPlanGenerator : this.insertTabletPlanGenerators) {
            InsertTabletPlan insertTabletPlan = insertTabletPlanGenerator.generateInsertTabletPlan();
            if (insertTabletPlan.getColumns().length == 0) continue;
            insertTabletPlans.add(insertTabletPlan);
        }
        return insertTabletPlans;
    }

    private void collectRowRecordIntoInsertTabletPlanGenerators() throws IOException {
        for (int count = 0; this.queryDataSet.hasNext() && count < this.tabletRowLimit; ++count) {
            RowRecord rowRecord = this.queryDataSet.next();
            for (InsertTabletPlanGenerator insertTabletPlanGenerator : this.insertTabletPlanGenerators) {
                insertTabletPlanGenerator.collectRowRecord(rowRecord);
            }
        }
    }
}

