/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotLoader {
    private Logger LOGGER = LoggerFactory.getLogger(SnapshotLoader.class);
    private String storageGroupName;
    private String snapshotPath;
    private String dataRegionId;

    public SnapshotLoader(String snapshotPath, String storageGroupName, String dataRegionId) {
        this.snapshotPath = snapshotPath;
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
    }

    private DataRegion loadSnapshot() {
        try {
            return new DataRegion(IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "storage_groups" + File.separator + this.storageGroupName, this.dataRegionId, StorageEngineV2.getInstance().getFileFlushPolicy(), this.storageGroupName);
        }
        catch (Exception e) {
            this.LOGGER.error("Exception occurs while load snapshot from {}", (Object)this.snapshotPath, (Object)e);
            return null;
        }
    }

    public DataRegion loadSnapshotForStateMachine() {
        this.LOGGER.info("Loading snapshot for {}-{}, source directory is {}", new Object[]{this.storageGroupName, this.dataRegionId, this.snapshotPath});
        try {
            this.deleteAllFilesInDataDirs();
            this.LOGGER.info("Remove all data files in original data dir");
        }
        catch (IOException e) {
            return null;
        }
        File sourceDataDir = new File(this.snapshotPath);
        if (sourceDataDir.exists()) {
            try {
                this.createLinksFromSnapshotDirToDataDir(sourceDataDir);
                this.LOGGER.info("Move data files from snapshot to data directory");
            }
            catch (IOException | DiskSpaceInsufficientException e) {
                this.LOGGER.error("Exception occurs when creating links from snapshot directory to data directory", (Throwable)e);
                return null;
            }
        }
        return this.loadSnapshot();
    }

    private void deleteAllFilesInDataDirs() throws IOException {
        String[] dataDirPaths = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        ArrayList<File> timePartitions = new ArrayList<File>();
        for (String dataDirPath : dataDirPaths) {
            File[] files;
            File unseqDataDirForThisRegion;
            File[] files2;
            File seqDataDirForThisRegion = new File(dataDirPath + File.separator + "sequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId);
            if (seqDataDirForThisRegion.exists() && (files2 = seqDataDirForThisRegion.listFiles()) != null) {
                timePartitions.addAll(Arrays.asList(files2));
            }
            if (!(unseqDataDirForThisRegion = new File(dataDirPath + File.separator + "unsequence" + File.separator + this.storageGroupName + File.separator + this.dataRegionId)).exists() || (files = unseqDataDirForThisRegion.listFiles()) == null) continue;
            timePartitions.addAll(Arrays.asList(files));
        }
        try {
            for (File timePartition : timePartitions) {
                FileUtils.forceDelete((File)timePartition);
            }
        }
        catch (IOException e) {
            this.LOGGER.error("Exception occurs when deleting time partition directory for {}-{}", new Object[]{this.storageGroupName, this.dataRegionId, e});
            throw e;
        }
    }

    private void createLinksFromSnapshotDirToDataDir(File sourceDir) throws IOException, DiskSpaceInsufficientException {
        File[] unseqRegionDirs;
        File seqFileDir = new File(sourceDir, "sequence" + File.separator + this.storageGroupName);
        File unseqFileDir = new File(sourceDir, "unsequence" + File.separator + this.storageGroupName);
        if (!seqFileDir.exists() && !unseqFileDir.exists()) {
            throw new IOException(String.format("Cannot find %s or %s", seqFileDir.getAbsolutePath(), unseqFileDir.getAbsolutePath()));
        }
        File[] seqRegionDirs = seqFileDir.listFiles();
        if (seqRegionDirs != null && seqRegionDirs.length > 0) {
            for (File seqRegionDir : seqRegionDirs) {
                if (!seqRegionDir.isDirectory()) {
                    this.LOGGER.info("Skip {}, because it is not a directory", (Object)seqRegionDir);
                    continue;
                }
                File[] seqPartitionDirs = seqRegionDir.listFiles();
                if (seqPartitionDirs == null || seqPartitionDirs.length <= 0) continue;
                for (File seqPartitionDir : seqPartitionDirs) {
                    String[] splitPath = seqPartitionDir.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : File.separator);
                    long timePartition = Long.parseLong(splitPath[splitPath.length - 1]);
                    File[] files = seqPartitionDir.listFiles();
                    if (files == null || files.length <= 0) continue;
                    Arrays.sort(files, Comparator.comparing(File::getName));
                    String currDir = DirectoryManager.getInstance().getNextFolderForSequenceFile();
                    for (File file : files) {
                        File targetFile;
                        if (file.getName().endsWith(".tsfile")) {
                            currDir = DirectoryManager.getInstance().getNextFolderForSequenceFile();
                        }
                        if (!(targetFile = new File(currDir, this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartition + File.separator + file.getName())).getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                            throw new IOException(String.format("Failed to create dir %s", targetFile.getParent()));
                        }
                        Files.createLink(targetFile.toPath(), file.toPath());
                    }
                }
            }
        }
        if ((unseqRegionDirs = unseqFileDir.listFiles()) != null && unseqRegionDirs.length > 0) {
            for (File unseqRegionDir : unseqRegionDirs) {
                if (!unseqRegionDir.isDirectory()) {
                    this.LOGGER.info("Skip {}, because it is not a directory", (Object)unseqRegionDir);
                    continue;
                }
                File[] unseqPartitionDirs = unseqRegionDir.listFiles();
                if (unseqPartitionDirs == null || unseqPartitionDirs.length <= 0) continue;
                for (File unseqPartitionDir : unseqPartitionDirs) {
                    String[] splitPath = unseqPartitionDir.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : File.separator);
                    long timePartition = Long.parseLong(splitPath[splitPath.length - 1]);
                    File[] files = unseqPartitionDir.listFiles();
                    if (files == null || files.length <= 0) continue;
                    Arrays.sort(files, Comparator.comparing(File::getName));
                    String currDir = DirectoryManager.getInstance().getNextFolderForUnSequenceFile();
                    for (File file : files) {
                        File targetFile;
                        if (file.getName().endsWith(".tsfile")) {
                            currDir = DirectoryManager.getInstance().getNextFolderForUnSequenceFile();
                        }
                        if (!(targetFile = new File(currDir, this.storageGroupName + File.separator + this.dataRegionId + File.separator + timePartition + File.separator + file.getName())).getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                            throw new IOException(String.format("Failed to create dir %s", targetFile.getParent()));
                        }
                        Files.createLink(targetFile.toPath(), file.toPath());
                    }
                }
            }
        }
    }
}

