/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceList;
import org.apache.iotdb.db.exception.WriteLockFailedException;
import org.apache.iotdb.db.rescon.TsFileResourceManager;
import org.apache.iotdb.db.sync.sender.manager.TsFileSyncManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileManager.class);
    private String storageGroupName;
    private String dataRegion;
    private String storageGroupDir;
    private final ReadWriteLock resourceListLock = new ReentrantReadWriteLock();
    private String writeLockHolder;
    private Map<Long, TsFileResourceList> sequenceFiles = new TreeMap<Long, TsFileResourceList>();
    private Map<Long, TsFileResourceList> unsequenceFiles = new TreeMap<Long, TsFileResourceList>();
    private List<TsFileResource> sequenceRecoverTsFileResources = new ArrayList<TsFileResource>();
    private List<TsFileResource> unsequenceRecoverTsFileResources = new ArrayList<TsFileResource>();
    private boolean allowCompaction = true;
    private AtomicLong currentCompactionTaskSerialId = new AtomicLong(0L);

    public TsFileManager(String storageGroupName, String dataRegion, String storageGroupDir) {
        this.storageGroupName = storageGroupName;
        this.storageGroupDir = storageGroupDir;
        this.dataRegion = dataRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TsFileResource> getTsFileList(boolean sequence) {
        this.readLock();
        try {
            ArrayList<TsFileResource> allResources = new ArrayList<TsFileResource>();
            Map<Long, TsFileResourceList> chosenMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry<Long, TsFileResourceList> entry : chosenMap.entrySet()) {
                allResources.addAll(entry.getValue().getArrayList());
            }
            ArrayList<TsFileResource> arrayList = allResources;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileResourceList getSequenceListByTimePartition(long timePartition) {
        this.readLock();
        try {
            TsFileResourceList tsFileResourceList = this.sequenceFiles.computeIfAbsent(timePartition, l -> new TsFileResourceList());
            return tsFileResourceList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TsFileResourceList getUnsequenceListByTimePartition(long timePartition) {
        this.readLock();
        try {
            TsFileResourceList tsFileResourceList = this.unsequenceFiles.computeIfAbsent(timePartition, l -> new TsFileResourceList());
            return tsFileResourceList;
        }
        finally {
            this.readUnlock();
        }
    }

    public Iterator<TsFileResource> getIterator(boolean sequence) {
        this.readLock();
        try {
            Iterator<TsFileResource> iterator = this.getTsFileList(sequence).iterator();
            return iterator;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock("remove");
        try {
            Map<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry<Long, TsFileResourceList> entry : selectedMap.entrySet()) {
                if (!entry.getValue().contains(tsFileResource)) continue;
                entry.getValue().remove(tsFileResource);
                TsFileResourceManager.getInstance().removeTsFileResource(tsFileResource);
                break;
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock("removeAll");
        try {
            for (TsFileResource resource : tsFileResourceList) {
                this.remove(resource, sequence);
                TsFileResourceManager.getInstance().removeTsFileResource(resource);
            }
        }
        finally {
            this.writeLock("removeAll");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertToPartitionFileList(TsFileResource tsFileResource, boolean sequence, int insertPos) {
        this.writeLock("add");
        try {
            Map<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            TsFileResourceList tsFileResources = selectedMap.computeIfAbsent(tsFileResource.getTimePartition(), o -> new TsFileResourceList());
            tsFileResources.set(insertPos, tsFileResource);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TsFileResource tsFileResource, boolean sequence) {
        this.writeLock("add");
        try {
            Map<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            selectedMap.computeIfAbsent(tsFileResource.getTimePartition(), o -> new TsFileResourceList()).add(tsFileResource);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepOrderInsert(TsFileResource tsFileResource, boolean sequence) throws IOException {
        this.writeLock("keepOrderInsert");
        try {
            Map<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            selectedMap.computeIfAbsent(tsFileResource.getTimePartition(), o -> new TsFileResourceList()).keepOrderInsert(tsFileResource);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void addForRecover(TsFileResource tsFileResource, boolean sequence) {
        if (sequence) {
            this.sequenceRecoverTsFileResources.add(tsFileResource);
        } else {
            this.unsequenceRecoverTsFileResources.add(tsFileResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<TsFileResource> tsFileResourceList, boolean sequence) {
        this.writeLock("add");
        try {
            for (TsFileResource resource : tsFileResourceList) {
                this.add(resource, sequence);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(List<TsFileResource> seqFileResources, List<TsFileResource> unseqFileResources, List<TsFileResource> targetFileResources, long timePartition, boolean isTargetSequence) throws IOException {
        this.writeLock("replace");
        try {
            for (TsFileResource tsFileResource : seqFileResources) {
                if (!this.sequenceFiles.get(timePartition).remove(tsFileResource)) continue;
                TsFileResourceManager.getInstance().removeTsFileResource(tsFileResource);
            }
            for (TsFileResource tsFileResource : unseqFileResources) {
                if (!this.unsequenceFiles.get(timePartition).remove(tsFileResource)) continue;
                TsFileResourceManager.getInstance().removeTsFileResource(tsFileResource);
            }
            if (isTargetSequence) {
                for (TsFileResource resource : targetFileResources) {
                    TsFileResourceManager.getInstance().registerSealedTsFileResource(resource);
                    this.sequenceFiles.get(timePartition).keepOrderInsert(resource);
                }
            } else {
                for (TsFileResource resource : targetFileResources) {
                    TsFileResourceManager.getInstance().registerSealedTsFileResource(resource);
                    this.unsequenceFiles.get(timePartition).keepOrderInsert(resource);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(TsFileResource tsFileResource, boolean sequence) {
        this.readLock();
        try {
            Map<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            TsFileResourceList list = selectedMap.getOrDefault(tsFileResource.getTimePartition(), null);
            boolean bl = list != null && list.contains(tsFileResource);
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    public void clear() {
        this.writeLock("clear");
        try {
            this.sequenceFiles.clear();
            this.unsequenceFiles.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(boolean sequence) {
        this.readLock();
        try {
            Map<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry<Long, TsFileResourceList> entry : selectedMap.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(boolean sequence) {
        this.readLock();
        try {
            int totalSize = 0;
            Map<Long, TsFileResourceList> selectedMap = sequence ? this.sequenceFiles : this.unsequenceFiles;
            for (Map.Entry<Long, TsFileResourceList> entry : selectedMap.entrySet()) {
                totalSize += entry.getValue().size();
            }
            int n = totalSize;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    public void readLock() {
        this.resourceListLock.readLock().lock();
    }

    public void readUnlock() {
        this.resourceListLock.readLock().unlock();
    }

    public void writeLock(String holder) {
        this.resourceListLock.writeLock().lock();
        this.writeLockHolder = holder;
    }

    public void writeLockWithTimeout(String holder, long timeout) throws WriteLockFailedException {
        try {
            if (!this.resourceListLock.writeLock().tryLock(timeout, TimeUnit.MILLISECONDS)) {
                throw new WriteLockFailedException(String.format("cannot get write lock in %d ms", timeout));
            }
            this.writeLockHolder = holder;
        }
        catch (InterruptedException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            Thread.interrupted();
            throw new WriteLockFailedException("thread is interrupted");
        }
    }

    public void writeUnlock() {
        this.resourceListLock.writeLock().unlock();
        this.writeLockHolder = "";
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public String getStorageGroupDir() {
        return this.storageGroupDir;
    }

    public void setStorageGroupDir(String storageGroupDir) {
        this.storageGroupDir = storageGroupDir;
    }

    public Set<Long> getTimePartitions() {
        this.readLock();
        try {
            HashSet<Long> timePartitions;
            HashSet<Long> hashSet = timePartitions = new HashSet<Long>(this.sequenceFiles.keySet());
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isAllowCompaction() {
        return this.allowCompaction;
    }

    public void setAllowCompaction(boolean allowCompaction) {
        this.allowCompaction = allowCompaction;
    }

    public String getDataRegion() {
        return this.dataRegion;
    }

    public void setDataRegion(String dataRegion) {
        this.dataRegion = dataRegion;
    }

    public List<TsFileResource> getSequenceRecoverTsFileResources() {
        return this.sequenceRecoverTsFileResources;
    }

    public List<TsFileResource> getUnsequenceRecoverTsFileResources() {
        return this.unsequenceRecoverTsFileResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> collectHistoryTsFileForSync(long dataStartTime) {
        this.readLock();
        try {
            ArrayList<File> historyTsFiles = new ArrayList<File>();
            this.collectTsFile(historyTsFiles, this.getTsFileList(true), dataStartTime);
            this.collectTsFile(historyTsFiles, this.getTsFileList(false), dataStartTime);
            ArrayList<File> arrayList = historyTsFiles;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    private void collectTsFile(List<File> historyTsFiles, List<TsFileResource> tsFileResources, long dataStartTime) {
        TsFileSyncManager syncManager = TsFileSyncManager.getInstance();
        for (TsFileResource tsFileResource : tsFileResources) {
            File mods;
            long modsOffset;
            File hardlink;
            if (tsFileResource.getFileEndTime() < dataStartTime) continue;
            TsFileProcessor tsFileProcessor = tsFileResource.getProcessor();
            boolean isRealTimeTsFile = false;
            if (tsFileProcessor != null) {
                isRealTimeTsFile = tsFileProcessor.isMemtableNotNull();
            }
            File tsFile = tsFileResource.getTsFile();
            if (isRealTimeTsFile || (hardlink = syncManager.createHardlink(tsFile, modsOffset = (mods = new File(tsFileResource.getModFile().getFilePath())).exists() ? mods.length() : 0L)) == null) continue;
            historyTsFiles.add(hardlink);
        }
    }

    public static int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            int cmpVersion = Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
            if (cmpVersion == 0) {
                return Long.compare(Long.parseLong(items1[2]), Long.parseLong(items2[2]));
            }
            return cmpVersion;
        }
        return cmp;
    }

    public long getNextCompactionTaskId() {
        return this.currentCompactionTaskSerialId.getAndIncrement();
    }
}

