/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import java.io.IOException;
import org.apache.iotdb.db.engine.trigger.executor.TriggerExecutor;
import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.metadata.lastCache.container.LastCacheContainer;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.container.IMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.container.MNodeContainers;
import org.apache.iotdb.db.metadata.mnode.visitor.MNodeVisitor;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.qp.physical.sys.MeasurementMNodePlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementMNode
extends MNode
implements IMeasurementMNode {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementMNode.class);
    protected String alias;
    private long offset = -1L;
    private IMeasurementSchema schema;
    private volatile ILastCacheContainer lastCacheContainer = null;

    public static IMeasurementMNode getMeasurementMNode(IEntityMNode parent, String measurementName, IMeasurementSchema schema, String alias) {
        return new MeasurementMNode(parent, measurementName, schema, alias);
    }

    public MeasurementMNode(IMNode parent, String name, IMeasurementSchema schema, String alias) {
        super(parent, name);
        this.schema = schema;
        this.alias = alias;
    }

    @Override
    public IEntityMNode getParent() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getAsEntityMNode();
    }

    @Override
    public MeasurementPath getMeasurementPath() {
        MeasurementPath result = new MeasurementPath(super.getPartialPath(), this.schema);
        result.setUnderAlignedEntity(this.getParent().isAligned());
        return result;
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.schema;
    }

    @Override
    public TSDataType getDataType(String measurementId) {
        return this.schema.getType();
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public TriggerExecutor getTriggerExecutor() {
        return this.triggerExecutor;
    }

    @Override
    public void setTriggerExecutor(TriggerExecutor triggerExecutor) {
        this.triggerExecutor = triggerExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILastCacheContainer getLastCacheContainer() {
        if (this.lastCacheContainer == null) {
            MeasurementMNode measurementMNode = this;
            synchronized (measurementMNode) {
                if (this.lastCacheContainer == null) {
                    this.lastCacheContainer = new LastCacheContainer();
                }
            }
        }
        return this.lastCacheContainer;
    }

    @Override
    public void setLastCacheContainer(ILastCacheContainer lastCacheContainer) {
        this.lastCacheContainer = lastCacheContainer;
    }

    @Override
    public void serializeTo(MLogWriter logWriter) throws IOException {
        logWriter.serializeMeasurementMNode(this);
    }

    @Override
    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return visitor.visitMeasurementMNode(this, context);
    }

    public static IMeasurementMNode deserializeFrom(MeasurementMNodePlan plan) {
        IMeasurementMNode node = MeasurementMNode.getMeasurementMNode(null, plan.getName(), plan.getSchema(), plan.getAlias());
        node.setOffset(plan.getOffset());
        return node;
    }

    @Override
    public String getFullPath() {
        if (this.fullPath != null) {
            return this.fullPath;
        }
        return this.concatFullPath();
    }

    @Override
    public boolean hasChild(String name) {
        return false;
    }

    @Override
    public IMNode getChild(String name) {
        logger.warn("current node {} is a MeasurementMNode, can not get child {}", (Object)this.name, (Object)name);
        throw new RuntimeException(String.format("current node %s is a MeasurementMNode, can not get child %s", this.name, name));
    }

    @Override
    public IMNode addChild(String name, IMNode child) {
        return null;
    }

    @Override
    public IMNode addChild(IMNode child) {
        return null;
    }

    @Override
    public IMNode deleteChild(String name) {
        return null;
    }

    @Override
    public void replaceChild(String oldChildName, IMNode newChildNode) {
    }

    @Override
    public IMNodeContainer getChildren() {
        return MNodeContainers.emptyMNodeContainer();
    }

    @Override
    public void setChildren(IMNodeContainer children) {
    }

    @Override
    public Template getUpperTemplate() {
        return this.parent.getUpperTemplate();
    }

    @Override
    public Template getSchemaTemplate() {
        logger.warn("current node {} is a MeasurementMNode, can not get Device Template", (Object)this.name);
        throw new RuntimeException(String.format("current node %s is a MeasurementMNode, can not get Device Template", this.name));
    }

    @Override
    public void setSchemaTemplate(Template schemaTemplate) {
    }

    @Override
    public void setUseTemplate(boolean useTemplate) {
    }

    @Override
    public boolean isMeasurement() {
        return true;
    }
}

