/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode.container;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.container.IMNodeContainer;
import org.apache.iotdb.db.metadata.mnode.container.MNodeContainerMapImpl;
import org.apache.iotdb.db.metadata.mtree.store.disk.CachedMNodeContainer;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.jetbrains.annotations.NotNull;

public class MNodeContainers {
    private static final IMNodeContainer EMPTY_CONTAINER = new EmptyContainer();

    public static IMNodeContainer emptyMNodeContainer() {
        return EMPTY_CONTAINER;
    }

    public static boolean isEmptyContainer(IMNodeContainer container) {
        return EMPTY_CONTAINER.equals(container);
    }

    public static IMNodeContainer getNewMNodeContainer() {
        if (IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode().equals(SchemaEngineMode.Schema_File.toString())) {
            return new CachedMNodeContainer();
        }
        return new MNodeContainerMapImpl();
    }

    private static class EmptyContainer
    extends AbstractMap<String, IMNode>
    implements IMNodeContainer {
        private EmptyContainer() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public IMNode get(Object key) {
            return null;
        }

        @Override
        @NotNull
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<IMNode> values() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, IMNode>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }
    }
}

