/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.utils.AlignedResourceByPathUtils;
import org.apache.iotdb.db.metadata.utils.MeasurementResourceByPathUtils;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.SeriesReader;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;

public abstract class ResourceByPathUtils {
    public static ResourceByPathUtils getResourceInstance(PartialPath path) {
        if (path instanceof AlignedPath) {
            return new AlignedResourceByPathUtils(path);
        }
        if (path instanceof MeasurementPath) {
            return new MeasurementResourceByPathUtils(path);
        }
        throw new UnsupportedOperationException("Should call exact sub class!");
    }

    public abstract LastPointReader createLastPointReader(TSDataType var1, Set<String> var2, QueryContext var3, QueryDataSource var4, long var5, Filter var7);

    public abstract SeriesReader createSeriesReader(Set<String> var1, TSDataType var2, QueryContext var3, QueryDataSource var4, Filter var5, Filter var6, TsFileFilter var7, boolean var8);

    public abstract SeriesReader createSeriesReader(Set<String> var1, TSDataType var2, QueryContext var3, List<TsFileResource> var4, List<TsFileResource> var5, Filter var6, Filter var7, boolean var8);

    public abstract TsFileResource createTsFileResource(List<ReadOnlyMemChunk> var1, List<IChunkMetadata> var2, TsFileResource var3) throws IOException;

    public abstract ITimeSeriesMetadata generateTimeSeriesMetadata(List<ReadOnlyMemChunk> var1, List<IChunkMetadata> var2) throws IOException;

    public abstract ReadOnlyMemChunk getReadOnlyMemChunkFromMemTable(IMemTable var1, List<Pair<Modification, IMemTable>> var2, long var3) throws QueryProcessException, IOException;

    public abstract List<IChunkMetadata> getVisibleMetadataListFromWriter(RestorableTsFileIOWriter var1, TsFileResource var2, QueryContext var3);

    protected List<Modification> getModificationsForMemtable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }
}

