/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common;

import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.common.ResultNodeContext;
import org.apache.iotdb.db.mpp.common.SessionInfo;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;

public class MPPQueryContext {
    private String sql;
    private QueryId queryId;
    private SessionInfo session;
    private QueryType queryType = QueryType.READ;
    private TEndPoint localDataBlockEndpoint;
    private TEndPoint localInternalEndpoint;
    private ResultNodeContext resultNodeContext;

    public MPPQueryContext(QueryId queryId) {
        this.queryId = queryId;
    }

    public MPPQueryContext(String sql, QueryId queryId, SessionInfo session, TEndPoint localDataBlockEndpoint, TEndPoint localInternalEndpoint) {
        this.sql = sql;
        this.queryId = queryId;
        this.session = session;
        this.localDataBlockEndpoint = localDataBlockEndpoint;
        this.localInternalEndpoint = localInternalEndpoint;
        this.resultNodeContext = new ResultNodeContext(queryId);
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public ResultNodeContext getResultNodeContext() {
        return this.resultNodeContext;
    }

    public TEndPoint getLocalDataBlockEndpoint() {
        return this.localDataBlockEndpoint;
    }

    public TEndPoint getLocalInternalEndpoint() {
        return this.localInternalEndpoint;
    }
}

