/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.QueryState;
import org.apache.iotdb.db.mpp.execution.StateMachine;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceState;

public class QueryStateMachine {
    private final String name;
    private final StateMachine<QueryState> queryState;
    private final Map<FragmentInstanceId, FragmentInstanceState> fragInstanceStateMap;
    private Executor stateMachineExecutor;
    private Throwable failureException;

    public QueryStateMachine(QueryId queryId, ExecutorService executor) {
        this.name = String.format("QueryStateMachine[%s]", queryId);
        this.stateMachineExecutor = executor;
        this.fragInstanceStateMap = new ConcurrentHashMap<FragmentInstanceId, FragmentInstanceState>();
        this.queryState = new StateMachine<QueryState>(queryId.toString(), this.stateMachineExecutor, QueryState.QUEUED, QueryState.TERMINAL_INSTANCE_STATES);
    }

    public void initialFragInstanceState(FragmentInstanceId id, FragmentInstanceState state) {
        this.fragInstanceStateMap.put(id, state);
    }

    public void updateFragInstanceState(FragmentInstanceId id, FragmentInstanceState state) {
        boolean allFinished;
        this.fragInstanceStateMap.put(id, state);
        if (state.isFailed()) {
            this.transitionToFailed(new RuntimeException(String.format("FragmentInstance[%s] is failed.", id)));
        }
        if (allFinished = this.fragInstanceStateMap.values().stream().allMatch(currentState -> currentState == FragmentInstanceState.FINISHED)) {
            this.transitionToFinished();
        }
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    private String getName() {
        return this.name;
    }

    public QueryState getState() {
        return this.queryState.get();
    }

    public void transitionToPlanned() {
        this.queryState.set(QueryState.PLANNED);
    }

    public void transitionToDispatching() {
        this.queryState.set(QueryState.DISPATCHING);
    }

    public void transitionToRunning() {
        this.queryState.set(QueryState.RUNNING);
    }

    public void transitionToFinished() {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.queryState.set(QueryState.FINISHED);
    }

    public void transitionToCanceled() {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.queryState.set(QueryState.CANCELED);
    }

    public void transitionToAborted() {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.queryState.set(QueryState.ABORTED);
    }

    public void transitionToFailed(Throwable throwable) {
        if (this.queryState.get().isDone()) {
            return;
        }
        this.failureException = throwable;
        this.queryState.set(QueryState.FAILED);
    }

    public String getFailureMessage() {
        if (this.failureException != null) {
            return this.failureException.getMessage();
        }
        return "no detailed failure reason in QueryStateMachine";
    }
}

