/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.LastValueDescAccumulator;
import org.apache.iotdb.db.mpp.aggregation.MaxTimeDescAccumulator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.Gt;
import org.apache.iotdb.tsfile.read.filter.operator.GtEq;
import org.apache.iotdb.tsfile.utils.Binary;

public class LastQueryUtil {
    private static final boolean CACHE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled();

    public static TsBlockBuilder createTsBlockBuilder() {
        return new TsBlockBuilder((List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT));
    }

    public static TsBlockBuilder createTsBlockBuilder(int initialExpectedEntries) {
        return new TsBlockBuilder(initialExpectedEntries, (List)ImmutableList.of((Object)TSDataType.TEXT, (Object)TSDataType.TEXT, (Object)TSDataType.TEXT));
    }

    public static void appendLastValue(TsBlockBuilder builder, long lastTime, String fullPath, String lastValue, String dataType) {
        builder.getTimeColumnBuilder().writeLong(lastTime);
        builder.getColumnBuilder(0).writeBinary(new Binary(fullPath));
        builder.getColumnBuilder(1).writeBinary(new Binary(lastValue));
        builder.getColumnBuilder(2).writeBinary(new Binary(dataType));
        builder.declarePosition();
    }

    public static boolean satisfyFilter(Filter filter, TimeValuePair tvPair) {
        return filter == null || filter.satisfy(tvPair.getTimestamp(), tvPair.getValue().getValue());
    }

    public static List<Aggregator> createAggregators(TSDataType dataType) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>(2);
        aggregators.add(new Aggregator(new MaxTimeDescAccumulator(), AggregationStep.SINGLE, Collections.singletonList(new InputLocation[]{new InputLocation(0, 0)})));
        aggregators.add(new Aggregator(new LastValueDescAccumulator(dataType), AggregationStep.SINGLE, Collections.singletonList(new InputLocation[]{new InputLocation(0, 0)})));
        return aggregators;
    }

    public static boolean needUpdateCache(Filter timeFilter) {
        return CACHE_ENABLED && (timeFilter == null || timeFilter instanceof GtEq) || timeFilter instanceof Gt;
    }
}

