/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.TransformOperator;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterOperator
extends TransformOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterOperator.class);
    private LayerPointReader filterPointReader;

    public FilterOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> inputDataTypes, Map<String, List<InputLocation>> inputLocations, Expression filterExpression, Expression[] outputExpressions, boolean keepNull, ZoneId zoneId, TypeProvider typeProvider, boolean isAscending) throws QueryProcessException, IOException {
        super(operatorContext, inputOperator, inputDataTypes, inputLocations, FilterOperator.bindExpressions(filterExpression, outputExpressions), keepNull, zoneId, typeProvider, isAscending);
    }

    private static Expression[] bindExpressions(Expression filterExpression, Expression[] outputExpressions) {
        Expression[] expressions = new Expression[outputExpressions.length + 1];
        System.arraycopy(outputExpressions, 0, expressions, 0, outputExpressions.length);
        expressions[expressions.length - 1] = filterExpression;
        return expressions;
    }

    @Override
    protected void initTransformers(Map<String, List<InputLocation>> inputLocations, Expression[] outputExpressions, TypeProvider typeProvider) throws QueryProcessException, IOException {
        super.initTransformers(inputLocations, outputExpressions, typeProvider);
        this.filterPointReader = this.transformers[this.transformers.length - 1];
        if (this.filterPointReader.getDataType() != TSDataType.BOOLEAN) {
            throw new UnSupportedDataTypeException(String.format("Data type of the filter expression should be BOOLEAN, but %s is received.", this.filterPointReader.getDataType()));
        }
    }

    @Override
    public TsBlock next() {
        try {
            YieldableState yieldableState = this.iterateAllColumnsToNextValid();
            if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                return null;
            }
            TsBlockBuilder tsBlockBuilder = TsBlockBuilder.createWithOnlyTimeColumn();
            int outputColumnCount = this.transformers.length - 1;
            if (this.outputDataTypes == null) {
                this.outputDataTypes = new ArrayList();
                for (int i = 0; i < outputColumnCount; ++i) {
                    this.outputDataTypes.add(this.transformers[i].getDataType());
                }
            }
            tsBlockBuilder.buildValueColumnBuilders(this.outputDataTypes);
            TimeColumnBuilder timeBuilder = tsBlockBuilder.getTimeColumnBuilder();
            ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
            int rowCount = 0;
            while (!this.timeHeap.isEmpty()) {
                long currentTime = this.timeHeap.pollFirst();
                yieldableState = this.filterPointReader.yield();
                if (yieldableState == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                    this.timeHeap.add(currentTime);
                    tsBlockBuilder.declarePositions(rowCount);
                    return tsBlockBuilder.build();
                }
                if (yieldableState == YieldableState.YIELDABLE && this.filterPointReader.currentTime() == currentTime) {
                    int i;
                    boolean isReaderContinueNull = true;
                    for (i = 0; isReaderContinueNull && i < outputColumnCount; ++i) {
                        isReaderContinueNull = this.collectReaderAppendIsNull(this.transformers[i], currentTime);
                    }
                    if (!this.filterPointReader.isCurrentNull() && this.filterPointReader.currentBoolean() && !isReaderContinueNull) {
                        timeBuilder.writeLong(currentTime);
                        for (i = 0; i < outputColumnCount; ++i) {
                            yieldableState = this.collectDataPoint(this.transformers[i], columnBuilders[i], currentTime, i);
                            if (yieldableState != YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) continue;
                            for (int j = 0; j <= i; ++j) {
                                this.shouldIterateReadersToNextValid[j] = false;
                            }
                            this.timeHeap.add(currentTime);
                            tsBlockBuilder.declarePositions(rowCount);
                            return tsBlockBuilder.build();
                        }
                        this.shouldIterateReadersToNextValid[outputColumnCount] = true;
                        for (i = 0; i <= outputColumnCount; ++i) {
                            if (!this.shouldIterateReadersToNextValid[i]) continue;
                            this.transformers[i].readyForNext();
                        }
                        ++rowCount;
                    } else {
                        for (i = 0; i < outputColumnCount; ++i) {
                            yieldableState = this.skipDataPoint(this.transformers[i], currentTime, i);
                            if (yieldableState != YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) continue;
                            for (int j = 0; j <= i; ++j) {
                                this.shouldIterateReadersToNextValid[j] = false;
                            }
                            this.timeHeap.add(currentTime);
                            tsBlockBuilder.declarePositions(rowCount);
                            return tsBlockBuilder.build();
                        }
                        this.shouldIterateReadersToNextValid[outputColumnCount] = true;
                        for (i = 0; i <= outputColumnCount; ++i) {
                            if (!this.shouldIterateReadersToNextValid[i]) continue;
                            this.transformers[i].readyForNext();
                        }
                    }
                } else {
                    int i;
                    for (i = 0; i < outputColumnCount; ++i) {
                        yieldableState = this.skipDataPoint(this.transformers[i], currentTime, i);
                        if (yieldableState != YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) continue;
                        for (int j = 0; j <= i; ++j) {
                            this.shouldIterateReadersToNextValid[j] = false;
                        }
                        this.timeHeap.add(currentTime);
                        tsBlockBuilder.declarePositions(rowCount);
                        return tsBlockBuilder.build();
                    }
                    for (i = 0; i < outputColumnCount; ++i) {
                        if (!this.shouldIterateReadersToNextValid[i]) continue;
                        this.transformers[i].readyForNext();
                    }
                }
                if ((yieldableState = this.iterateAllColumnsToNextValid()) == YieldableState.NOT_YIELDABLE_WAITING_FOR_DATA) {
                    tsBlockBuilder.declarePositions(rowCount);
                    return tsBlockBuilder.build();
                }
                this.inputLayer.updateRowRecordListEvictionUpperBound();
            }
            tsBlockBuilder.declarePositions(rowCount);
            return tsBlockBuilder.build();
        }
        catch (Exception e) {
            LOGGER.error("FilterOperator#next()", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private YieldableState skipDataPoint(LayerPointReader reader, long currentTime, int readerIndex) throws IOException, QueryProcessException {
        YieldableState yieldableState = reader.yield();
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        if (reader.currentTime() == currentTime) {
            this.shouldIterateReadersToNextValid[readerIndex] = true;
        }
        return YieldableState.YIELDABLE;
    }
}

