/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.process;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.slidingwindow.SlidingWindowAggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.RawDataAggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;

public class SlidingWindowAggregationOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final Operator child;
    private TsBlock cachedTsBlock;
    private final List<SlidingWindowAggregator> aggregators;
    private final ITimeRangeIterator timeRangeIterator;
    private TimeRange curTimeRange;
    private final boolean ascending;
    private final TsBlockBuilder tsBlockBuilder;

    public SlidingWindowAggregationOperator(OperatorContext operatorContext, List<SlidingWindowAggregator> aggregators, Operator child, boolean ascending, GroupByTimeParameter groupByTimeParameter) {
        Preconditions.checkArgument((groupByTimeParameter != null ? 1 : 0) != 0, (Object)"GroupByTimeParameter cannot be null in SlidingWindowAggregationOperator");
        this.operatorContext = operatorContext;
        this.aggregators = aggregators;
        this.child = child;
        ArrayList<TSDataType> outputDataTypes = new ArrayList<TSDataType>();
        for (Aggregator aggregator : aggregators) {
            outputDataTypes.addAll(Arrays.asList(aggregator.getOutputType()));
        }
        this.tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        this.timeRangeIterator = SeriesAggregationScanOperator.initTimeRangeIterator(groupByTimeParameter, ascending, false);
        this.ascending = ascending;
    }

    @Override
    public boolean hasNext() {
        return this.curTimeRange != null || this.timeRangeIterator.hasNextTimeRange();
    }

    @Override
    public TsBlock next() {
        if (this.curTimeRange == null && this.timeRangeIterator.hasNextTimeRange()) {
            this.curTimeRange = this.timeRangeIterator.nextTimeRange();
            for (Aggregator aggregator : this.aggregators) {
                aggregator.updateTimeRange(this.curTimeRange);
            }
        }
        boolean canCallNext = true;
        while (!this.calcFromTsBlock(this.cachedTsBlock, this.curTimeRange)) {
            this.cachedTsBlock = null;
            if (this.child.hasNext() && canCallNext) {
                this.cachedTsBlock = this.child.next();
                canCallNext = false;
                continue;
            }
            if (!this.child.hasNext()) break;
            return null;
        }
        this.curTimeRange = null;
        return AggregationOperator.updateResultTsBlockFromAggregators(this.tsBlockBuilder, this.aggregators, this.timeRangeIterator);
    }

    private boolean calcFromTsBlock(TsBlock inputTsBlock, TimeRange timeRange) {
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return false;
        }
        if (RawDataAggregationOperator.satisfied(inputTsBlock, timeRange, this.ascending)) {
            if (this.ascending && inputTsBlock.getStartTime() < timeRange.getMin() || !this.ascending && inputTsBlock.getStartTime() > timeRange.getMax()) {
                inputTsBlock = RawDataAggregationOperator.skipOutOfTimeRangePoints(inputTsBlock, timeRange, this.ascending);
            }
            int lastReadRowIndex = 0;
            for (SlidingWindowAggregator aggregator : this.aggregators) {
                lastReadRowIndex = Math.max(lastReadRowIndex, aggregator.processTsBlock((TsBlock)inputTsBlock));
            }
            inputTsBlock = lastReadRowIndex >= inputTsBlock.getPositionCount() ? null : inputTsBlock.subTsBlock(lastReadRowIndex);
        }
        return inputTsBlock != null && (this.ascending ? inputTsBlock.getEndTime() > timeRange.getMax() : inputTsBlock.getEndTime() < timeRange.getMin());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.child.isBlocked();
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public void close() throws Exception {
        this.child.close();
    }
}

