/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class LevelTimeSeriesCountOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final PartialPath partialPath;
    private final boolean isPrefixPath;
    private final int level;
    private boolean isFinished;

    public LevelTimeSeriesCountOperator(PlanNodeId sourceId, OperatorContext operatorContext, PartialPath partialPath, boolean isPrefixPath, int level) {
        this.sourceId = sourceId;
        this.operatorContext = operatorContext;
        this.partialPath = partialPath;
        this.isPrefixPath = isPrefixPath;
        this.level = level;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        Map<PartialPath, Integer> countMap;
        this.isFinished = true;
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(HeaderConstant.countLevelTimeSeriesHeader.getRespDataTypes());
        try {
            countMap = ((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getMeasurementCountGroupByLevel(this.partialPath, this.level, this.isPrefixPath);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        countMap.forEach((path, count) -> {
            tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
            tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(path.getFullPath()));
            tsBlockBuilder.getColumnBuilder(1).writeInt(count.intValue());
            tsBlockBuilder.declarePosition();
        });
        return tsBlockBuilder.build();
    }

    @Override
    public boolean hasNext() {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }
}

